/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import java.util.HashMap;
import java.util.Map;
import org.tango.DeviceState;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoTypeUtils;

public final class PublisherAttribute
implements IAttributeBehavior {
    private static final Map<String, Class<?>> JAVA_TYPES_MAP = new HashMap();
    private static final Map<Class<?>, Object> RESULTS_MAP;
    private AttributeValue readValue;
    private final AttributeConfiguration configAttr = new AttributeConfiguration();

    public PublisherAttribute(String ... config) throws DevFailed {
        if (config.length >= 1) {
            this.configAttr.setName(config[0]);
        } else {
            this.configAttr.setName("");
            DevFailedUtils.throwDevFailed("DEVICE_PROP_ERROR", "unknown attribute config");
        }
        if (config.length == 2) {
            Class<?> c = JAVA_TYPES_MAP.get(config[1].toLowerCase());
            this.configAttr.setType(c);
        } else if (config.length >= 3) {
            int typeAttr = 0;
            try {
                typeAttr = Integer.parseInt(config[1]);
            }
            catch (NumberFormatException e) {
                typeAttr = TangoTypeUtils.getAttributeType(config[1]);
            }
            if (config[2].equalsIgnoreCase("SCALAR")) {
                this.configAttr.setTangoType(typeAttr, AttrDataFormat.SCALAR);
            } else if (config[2].equalsIgnoreCase("SPECTRUM")) {
                this.configAttr.setTangoType(typeAttr, AttrDataFormat.SPECTRUM);
            } else if (config[2].equalsIgnoreCase("IMAGE")) {
                this.configAttr.setTangoType(typeAttr, AttrDataFormat.IMAGE);
            } else {
                DevFailedUtils.throwDevFailed("DEVICE_PROP_ERROR", "unknown attribute format: " + config[1]);
            }
        } else {
            DevFailedUtils.throwDevFailed("DEVICE_PROP_ERROR", "unknown attribute config: " + config[1]);
        }
        this.readValue = new AttributeValue();
        this.readValue.setValue(RESULTS_MAP.get(this.configAttr.getType()));
    }

    @Override
    public AttributeConfiguration getConfiguration() throws DevFailed {
        this.configAttr.setWritable(AttrWriteType.WRITE);
        this.configAttr.setMemorized(true);
        AttributePropertiesImpl prop = new AttributePropertiesImpl();
        prop.setLabel(this.configAttr.getName());
        this.configAttr.setAttributeProperties(prop);
        return this.configAttr;
    }

    @Override
    public AttributeValue getValue() throws DevFailed {
        this.readValue.setTime(System.currentTimeMillis());
        return this.readValue;
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
        this.readValue = value;
    }

    @Override
    public StateMachineBehavior getStateMachine() {
        return null;
    }

    static {
        JAVA_TYPES_MAP.put("int", Integer.TYPE);
        JAVA_TYPES_MAP.put("long", Long.TYPE);
        JAVA_TYPES_MAP.put("double", Double.TYPE);
        JAVA_TYPES_MAP.put("float", Float.TYPE);
        JAVA_TYPES_MAP.put("boolean", Boolean.TYPE);
        JAVA_TYPES_MAP.put("byte", Byte.TYPE);
        JAVA_TYPES_MAP.put("short", Short.TYPE);
        JAVA_TYPES_MAP.put("string", String.class);
        JAVA_TYPES_MAP.put("devstate", DeviceState.class);
        JAVA_TYPES_MAP.put("state", DeviceState.class);
        JAVA_TYPES_MAP.put("devencoded", DevEncoded.class);
        JAVA_TYPES_MAP.put("int[]", int[].class);
        JAVA_TYPES_MAP.put("long[]", long[].class);
        JAVA_TYPES_MAP.put("double[]", double[].class);
        JAVA_TYPES_MAP.put("float[]", float[].class);
        JAVA_TYPES_MAP.put("boolean[]", boolean[].class);
        JAVA_TYPES_MAP.put("byte[]", byte[].class);
        JAVA_TYPES_MAP.put("short[]", short[].class);
        JAVA_TYPES_MAP.put("string[]", String[].class);
        JAVA_TYPES_MAP.put("devstate[]", DeviceState[].class);
        JAVA_TYPES_MAP.put("state[]", DeviceState[].class);
        JAVA_TYPES_MAP.put("devencoded[]", DevEncoded[].class);
        JAVA_TYPES_MAP.put("int[][]", int[][].class);
        JAVA_TYPES_MAP.put("long[][]", long[][].class);
        JAVA_TYPES_MAP.put("double[][]", double[][].class);
        JAVA_TYPES_MAP.put("float[][]", float[][].class);
        JAVA_TYPES_MAP.put("boolean[][]", boolean[][].class);
        JAVA_TYPES_MAP.put("byte[][]", byte[][].class);
        JAVA_TYPES_MAP.put("short[][]", short[][].class);
        JAVA_TYPES_MAP.put("string[][]", String[][].class);
        JAVA_TYPES_MAP.put("state[][]", DeviceState[][].class);
        JAVA_TYPES_MAP.put("devstate[][]", DeviceState[][].class);
        JAVA_TYPES_MAP.put("devencoded[][]", DevEncoded[][].class);
        RESULTS_MAP = new HashMap();
        RESULTS_MAP.put(Boolean.TYPE, false);
        RESULTS_MAP.put(Short.TYPE, (short)0);
        RESULTS_MAP.put(Integer.TYPE, 0);
        RESULTS_MAP.put(Byte.TYPE, (byte)0);
        RESULTS_MAP.put(Float.TYPE, Float.valueOf(0.0f));
        RESULTS_MAP.put(Long.TYPE, 0L);
        RESULTS_MAP.put(Double.TYPE, 0.0);
        RESULTS_MAP.put(String.class, "");
        RESULTS_MAP.put(DeviceState.class, (Object)DeviceState.ON);
        RESULTS_MAP.put(DevEncoded.class, new DevEncoded());
        RESULTS_MAP.put(short[].class, new short[0]);
        RESULTS_MAP.put(int[].class, new int[0]);
        RESULTS_MAP.put(byte[].class, new byte[0]);
        RESULTS_MAP.put(float[].class, new float[0]);
        RESULTS_MAP.put(double[].class, new double[0]);
        RESULTS_MAP.put(long[].class, new long[0]);
        RESULTS_MAP.put(String[].class, new String[0]);
        RESULTS_MAP.put(boolean[].class, new boolean[0]);
        RESULTS_MAP.put(DeviceState[].class, new DeviceState[0]);
        RESULTS_MAP.put(DevEncoded[].class, new DevEncoded[0]);
        RESULTS_MAP.put(short[][].class, new short[][]{new short[0]});
        RESULTS_MAP.put(int[][].class, new int[][]{new int[0]});
        RESULTS_MAP.put(byte[][].class, new byte[][]{new byte[0]});
        RESULTS_MAP.put(float[][].class, new float[][]{new float[0]});
        RESULTS_MAP.put(double[][].class, new double[][]{new double[0]});
        RESULTS_MAP.put(long[][].class, new long[][]{new long[0]});
        RESULTS_MAP.put(String[][].class, new String[][]{new String[0]});
        RESULTS_MAP.put(boolean[][].class, new boolean[][]{new boolean[0]});
        RESULTS_MAP.put(DeviceState[][].class, new DeviceState[][]{new DeviceState[0]});
        RESULTS_MAP.put(DevEncoded[][].class, new DevEncoded[][]{new DevEncoded[0]});
    }
}

