/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic;

import fr.esrf.Tango.DevFailed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.server.command.CommandImpl;
import org.tango.server.command.ICommandBehavior;
import org.tango.server.properties.AttributePropertiesManager;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

public final class DynamicManager {
    private final XLogger xlogger = XLoggerFactory.getXLogger(DynamicManager.class);
    private final DeviceImpl deviceImpl;
    private final Map<String, AttributeImpl> dynamicAttributes = new HashMap<String, AttributeImpl>();
    private final Map<String, CommandImpl> dynamicCommands = new HashMap<String, CommandImpl>();
    private final List<String> forwardedAttributes = new ArrayList<String>();

    public DynamicManager(DeviceImpl deviceImpl) {
        this.deviceImpl = deviceImpl;
    }

    public void addAttribute(IAttributeBehavior behavior) throws DevFailed {
        String attributeName = behavior.getConfiguration().getName();
        this.xlogger.entry("adding dynamic attribute {}", attributeName);
        if (behavior instanceof ForwardedAttribute) {
            ForwardedAttribute att = (ForwardedAttribute)behavior;
            String deviceName = this.deviceImpl.getName();
            String rootAttributeName = behavior.getConfiguration().getAttributeProperties().loadAttributeRootName(deviceName, attributeName);
            if (rootAttributeName == null || rootAttributeName.isEmpty() || rootAttributeName.equalsIgnoreCase("Not specified")) {
                att.init(deviceName);
                behavior.getConfiguration().getAttributeProperties().persistAttributeRootName(deviceName, attributeName);
            } else {
                att.init(deviceName, rootAttributeName);
            }
            String lower = att.getRootName().toLowerCase(Locale.ENGLISH);
            if (this.forwardedAttributes.contains(lower)) {
                throw DevFailedUtils.newDevFailed("FWD_DOUBLE_USED", "root attribute already used in this device");
            }
            this.forwardedAttributes.add(lower);
        } else {
            AttributeConfiguration config = behavior.getConfiguration();
            AttributePropertiesImpl prop = config.getAttributeProperties();
            if (prop.getLabel().isEmpty()) {
                prop.setLabel(config.getName());
            }
            if (prop.getFormat().equals("Not specified")) {
                prop.setDefaultFormat(config.getScalarType());
            }
        }
        AttributeImpl attrImpl = new AttributeImpl(behavior, this.deviceImpl.getName());
        attrImpl.setStateMachine(behavior.getStateMachine());
        this.deviceImpl.addAttribute(attrImpl);
        this.dynamicAttributes.put(attributeName.toLowerCase(Locale.ENGLISH), attrImpl);
        this.deviceImpl.pushInterfaceChangeEvent(false);
        this.xlogger.exit();
    }

    public void removeAttribute(String attributeName) throws DevFailed {
        AttributeImpl toRemove = this.dynamicAttributes.get(attributeName.toLowerCase(Locale.ENGLISH));
        if (toRemove.getBehavior() instanceof ForwardedAttribute) {
            ForwardedAttribute att = (ForwardedAttribute)toRemove.getBehavior();
            String lower = att.getRootName().toLowerCase(Locale.ENGLISH);
            this.forwardedAttributes.remove(lower);
        }
        this.deviceImpl.removeAttribute(toRemove);
        this.dynamicAttributes.remove(toRemove);
        this.deviceImpl.pushInterfaceChangeEvent(false);
    }

    public void removeAttribute(String attributeName, boolean clearAttributeProperties) throws DevFailed {
        this.removeAttribute(attributeName);
        if (clearAttributeProperties) {
            new AttributePropertiesManager(this.deviceImpl.getName()).removeAttributeProperties(attributeName);
        }
    }

    public void clearAttributesWithExclude(String ... exclude) throws DevFailed {
        Object[] toExclude = new String[exclude.length];
        for (int i = 0; i < toExclude.length; ++i) {
            toExclude[i] = exclude[i].toLowerCase(Locale.ENGLISH);
        }
        for (String attributeName : this.dynamicAttributes.keySet()) {
            if (ArrayUtils.contains(toExclude, attributeName)) continue;
            this.removeAttribute(attributeName);
        }
    }

    public void clearAttributes() throws DevFailed {
        for (AttributeImpl attributeImpl : this.dynamicAttributes.values()) {
            this.deviceImpl.removeAttribute(attributeImpl);
        }
        this.forwardedAttributes.clear();
        this.dynamicAttributes.clear();
    }

    public void clearAttributes(boolean clearAttributeProperties) throws DevFailed {
        this.clearAttributes();
        if (clearAttributeProperties) {
            new AttributePropertiesManager(this.deviceImpl.getName()).removeAttributeProperties(new String[0]);
        }
    }

    public List<IAttributeBehavior> getDynamicAttributes() {
        ArrayList<IAttributeBehavior> result = new ArrayList<IAttributeBehavior>();
        for (AttributeImpl attributeImpl : this.dynamicAttributes.values()) {
            result.add(attributeImpl.getBehavior());
        }
        return result;
    }

    public IAttributeBehavior getAttribute(String attributeName) {
        return this.dynamicAttributes.get(attributeName.toLowerCase(Locale.ENGLISH)).getBehavior();
    }

    public void addCommand(ICommandBehavior behavior) throws DevFailed {
        String cmdName = behavior.getConfiguration().getName();
        this.xlogger.entry("adding dynamic command {}", cmdName);
        CommandImpl commandImpl = new CommandImpl(behavior, this.deviceImpl.getName());
        commandImpl.setStateMachine(behavior.getStateMachine());
        this.deviceImpl.addCommand(commandImpl);
        this.dynamicCommands.put(cmdName.toLowerCase(Locale.ENGLISH), commandImpl);
        this.deviceImpl.pushInterfaceChangeEvent(false);
        this.xlogger.exit();
    }

    public void removeCommand(String commandName) throws DevFailed {
        CommandImpl toRemove = this.dynamicCommands.get(commandName.toLowerCase(Locale.ENGLISH));
        this.deviceImpl.removeCommand(toRemove);
        this.dynamicCommands.remove(toRemove);
        this.deviceImpl.pushInterfaceChangeEvent(false);
    }

    public ICommandBehavior getCommand(String commandName) {
        return this.dynamicCommands.get(commandName.toLowerCase(Locale.ENGLISH)).getBehavior();
    }

    public void clearCommands() throws DevFailed {
        for (CommandImpl cmdImpl : this.dynamicCommands.values()) {
            this.deviceImpl.removeCommand(cmdImpl);
        }
        this.dynamicCommands.clear();
    }

    public void clearCommandsWithExclude(String ... exclude) throws DevFailed {
        Object[] toExclude = new String[exclude.length];
        for (int i = 0; i < toExclude.length; ++i) {
            toExclude[i] = exclude[i].toLowerCase(Locale.ENGLISH);
        }
        for (String cmdName : this.dynamicCommands.keySet()) {
            if (ArrayUtils.contains(toExclude, cmdName)) continue;
            this.removeCommand(cmdName);
        }
    }

    public List<ICommandBehavior> getDynamicCommands() {
        ArrayList<ICommandBehavior> result = new ArrayList<ICommandBehavior>();
        for (CommandImpl cmdImpl : this.dynamicCommands.values()) {
            result.add(cmdImpl.getBehavior());
        }
        return result;
    }

    public void clearAll() throws DevFailed {
        this.clearCommands();
        this.clearAttributes();
    }

    public void clearAll(boolean clearAttributeProperties) throws DevFailed {
        this.clearCommands();
        this.clearAttributes(clearAttributeProperties);
    }
}

