/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.cache;

import fr.esrf.Tango.DevFailed;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.InvocationContext;
import org.tango.server.command.CommandImpl;
import org.tango.server.device.AroundInvokeImpl;
import org.tango.server.device.DeviceLocker;

public final class CommandCacheEntryFactory
implements CacheEntryFactory {
    private final Logger logger = LoggerFactory.getLogger(CommandCacheEntryFactory.class);
    private static final double NANO_TO_MILLI = 1000000.0;
    private final CommandImpl command;
    private final DeviceLocker deviceLock;
    private final AroundInvokeImpl aroundInvoke;
    private long lastUpdateTime;

    public CommandCacheEntryFactory(CommandImpl command, DeviceLocker deviceLock, AroundInvokeImpl aroundInvoke) {
        this.deviceLock = deviceLock;
        this.command = command;
        this.aroundInvoke = aroundInvoke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createEntry(Object key) throws DevFailed {
        this.logger.debug("Creating entry for key = {} , command {} ", key, (Object)this.command.getName());
        Object result = null;
        Object lock = this.deviceLock.getCommandLock();
        Object object = lock != null ? lock : new Object();
        synchronized (object) {
            this.aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_COMMAND, InvocationContext.CallType.POLLING, null, this.command.getName()));
            try {
                long time1 = System.nanoTime();
                result = this.command.execute(null);
                long now = System.nanoTime();
                long nowMilli = System.currentTimeMillis();
                long deltaTime = now - this.lastUpdateTime;
                this.lastUpdateTime = now;
                long executionDuration = this.lastUpdateTime - time1;
                this.command.addToHistory(result);
                this.command.setPollingStats((double)executionDuration / 1000000.0, nowMilli, (double)deltaTime / 1000000.0);
            }
            catch (DevFailed e) {
                try {
                    this.command.addErrorToHistory(e);
                    throw e;
                }
                catch (Throwable throwable) {
                    this.aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_COMMAND, InvocationContext.CallType.POLLING, null, this.command.getName()));
                    throw throwable;
                }
            }
            this.aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_COMMAND, InvocationContext.CallType.POLLING, null, this.command.getName()));
        }
        return result;
    }
}

