/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.ServerManager;
import org.tango.server.annotation.AroundInvoke;
import org.tango.server.annotation.Attribute;
import org.tango.server.annotation.ClassProperty;
import org.tango.server.annotation.Command;
import org.tango.server.annotation.Delete;
import org.tango.server.annotation.Device;
import org.tango.server.annotation.DeviceManagement;
import org.tango.server.annotation.DeviceProperties;
import org.tango.server.annotation.DeviceProperty;
import org.tango.server.annotation.DynamicManagement;
import org.tango.server.annotation.Init;
import org.tango.server.annotation.Pipe;
import org.tango.server.annotation.Schedule;
import org.tango.server.annotation.State;
import org.tango.server.annotation.Status;
import org.tango.server.annotation.TransactionType;
import org.tango.server.build.AroundInvokeBuilder;
import org.tango.server.build.AttributeFieldBuilder;
import org.tango.server.build.AttributeMethodBuilder;
import org.tango.server.build.ClassPropertyBuilder;
import org.tango.server.build.CommandBuilder;
import org.tango.server.build.DeleteBuilder;
import org.tango.server.build.DeviceManagerBuilder;
import org.tango.server.build.DevicePropertiesBuilder;
import org.tango.server.build.DevicePropertyBuilder;
import org.tango.server.build.DeviceSchedulerBuilder;
import org.tango.server.build.DynamicManagerBuilder;
import org.tango.server.build.InitBuilder;
import org.tango.server.build.PipeBuilder;
import org.tango.server.build.StateBuilder;
import org.tango.server.build.StatusBuilder;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.ReflectionScanner;

public final class DeviceBuilder {
    private static final String MUST_BE_UNIQUE = " must be unique";
    private final Logger logger = LoggerFactory.getLogger(DeviceBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(DeviceBuilder.class);
    private final Class<?> clazz;
    private final String className;
    private final String name;
    private DeviceImpl device;
    private Object businessObject;

    DeviceBuilder(Class<?> clazz, String className, String name) {
        this.clazz = clazz;
        this.className = className;
        this.name = name;
    }

    public DeviceImpl createDevice() throws DevFailed {
        MDC.put("deviceName", this.name);
        this.xlogger.entry(new Object[0]);
        this.checkIsTangoDevice(this.clazz, this.name);
        DeviceManagerBuilder.clear();
        DynamicManagerBuilder.clear();
        try {
            Device annotation = this.clazz.getAnnotation(Device.class);
            TransactionType txType = ServerManager.getInstance().getTransactionType();
            if (txType == null) {
                txType = annotation.transactionType();
            }
            String deviceType = annotation.deviceType();
            this.businessObject = this.clazz.newInstance();
            this.device = new DeviceImpl(this.name, this.className, txType, this.businessObject, deviceType);
            this.addSuperDevices();
            ReflectionScanner deviceImplScanner = new ReflectionScanner(this.device.getClass());
            this.createBusinessObjectAttrField(deviceImplScanner, true);
            this.createBusinessObjectAttrCmd(deviceImplScanner, true);
            ReflectionScanner boScanner = new ReflectionScanner(this.clazz);
            this.createBusinessObjectFields(boScanner);
            this.createBusinessObjectAttrField(boScanner, false);
            this.createBusinessObjectAttrCmd(boScanner, false);
            this.createBusinessObjectInitDelete(boScanner);
            this.createBusinessObjectAroundInvoke(boScanner);
            this.createBusinessObjectDeviceProperties(boScanner);
            this.createBusinessObjectProps(boScanner);
            this.createBusinessObjectPipes(boScanner);
            this.createBusinessObjectState(boScanner);
        }
        catch (InstantiationException e) {
            DevFailedUtils.throwDevFailed(e);
        }
        catch (IllegalAccessException e) {
            DevFailedUtils.throwDevFailed(e);
        }
        this.device.initDevice();
        this.xlogger.exit();
        return this.device;
    }

    private void addSuperDevices() throws DevFailed {
        for (Class<?> superDeviceClass = this.clazz.getSuperclass(); superDeviceClass != null && superDeviceClass.getAnnotation(Device.class) != null; superDeviceClass = superDeviceClass.getSuperclass()) {
            this.logger.debug("adding super class to device {}", (Object)superDeviceClass.getCanonicalName());
            ReflectionScanner superClassScanner = new ReflectionScanner(superDeviceClass);
            this.createBusinessObjectAttrCmd(superClassScanner, false);
            this.createBusinessObjectAttrField(superClassScanner, false);
            this.createBusinessObjectProps(superClassScanner);
            this.createBusinessObjectFields(superClassScanner);
            this.createBusinessObjectInitDelete(superClassScanner);
            this.createBusinessObjectPipes(superClassScanner);
            this.createBusinessObjectState(superClassScanner);
        }
    }

    private void createBusinessObjectAttrCmd(ReflectionScanner scanner, boolean isOnDeviceImpl) throws DevFailed {
        Set<Method> attrs;
        Set<Method> cmds = scanner.getMethodsAnnotatedWith(Command.class);
        if (cmds != null) {
            CommandBuilder cmd = new CommandBuilder();
            for (Method method : cmds) {
                cmd.build(this.device, this.businessObject, method, isOnDeviceImpl);
            }
        }
        if ((attrs = scanner.getMethodsAnnotatedWith(Attribute.class)) != null) {
            AttributeMethodBuilder attr = new AttributeMethodBuilder();
            for (Method method : attrs) {
                attr.build(this.device, this.businessObject, method, isOnDeviceImpl);
            }
        }
    }

    private void createBusinessObjectInitDelete(ReflectionScanner scanner) throws DevFailed {
        Set<Method> scheduleM;
        Set<Method> deleteM;
        Set<Method> initM = scanner.getMethodsAnnotatedWith(Init.class);
        if (initM != null && initM.size() > 1) {
            DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", Init.class + MUST_BE_UNIQUE);
        }
        if (initM != null && initM.size() == 1) {
            new InitBuilder().build(initM.iterator().next(), this.device, this.businessObject);
        }
        if ((deleteM = scanner.getMethodsAnnotatedWith(Delete.class)) != null && deleteM.size() > 1) {
            DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", Delete.class + MUST_BE_UNIQUE);
        }
        if (deleteM != null && deleteM.size() == 1) {
            new DeleteBuilder().build(deleteM.iterator().next(), this.device);
        }
        if ((scheduleM = scanner.getMethodsAnnotatedWith(Schedule.class)) != null && scheduleM.size() == 1) {
            new DeviceSchedulerBuilder().build(scheduleM, this.device);
        }
    }

    private void createBusinessObjectAroundInvoke(ReflectionScanner scanner) throws DevFailed {
        Set<Method> invokeM = scanner.getMethodsAnnotatedWith(AroundInvoke.class);
        if (invokeM != null && invokeM.size() > 1) {
            DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", AroundInvoke.class + MUST_BE_UNIQUE);
        }
        if (invokeM != null && invokeM.size() == 1) {
            new AroundInvokeBuilder().build(invokeM.iterator().next(), this.device, this.businessObject);
        }
    }

    private void createBusinessObjectAttrField(ReflectionScanner scanner, boolean isOnDeviceImpl) throws DevFailed {
        Set<Field> attributeF = scanner.getFieldsAnnotatedWith(Attribute.class);
        if (attributeF != null) {
            AttributeFieldBuilder attr = new AttributeFieldBuilder();
            for (Field field : attributeF) {
                attr.build(this.device, this.businessObject, field, isOnDeviceImpl);
            }
        }
    }

    private void createBusinessObjectPipes(ReflectionScanner scanner) throws DevFailed {
        Set<Field> fields = scanner.getFieldsAnnotatedWith(Pipe.class);
        if (fields != null) {
            PipeBuilder pipe = new PipeBuilder();
            for (Field field : fields) {
                pipe.build(this.device, this.businessObject, field);
            }
        }
    }

    private void createBusinessObjectFields(ReflectionScanner scanner) throws DevFailed {
        Set<Field> deviceF;
        Set<Field> dynF = scanner.getFieldsAnnotatedWith(DynamicManagement.class);
        if (dynF != null) {
            if (dynF.size() > 1) {
                DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", DynamicManagement.class + MUST_BE_UNIQUE);
            }
            if (dynF.size() == 1) {
                new DynamicManagerBuilder().build(dynF.iterator().next(), this.device, this.businessObject);
            }
        }
        if ((deviceF = scanner.getFieldsAnnotatedWith(DeviceManagement.class)) != null) {
            if (deviceF.size() > 1) {
                DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", DeviceManagement.class + MUST_BE_UNIQUE);
            }
            if (deviceF.size() == 1) {
                new DeviceManagerBuilder().build(deviceF.iterator().next(), this.device, this.businessObject);
            }
        }
    }

    private void createBusinessObjectState(ReflectionScanner scanner) throws DevFailed {
        Set<Field> statusF;
        Set<Field> stateF = scanner.getFieldsAnnotatedWith(State.class);
        if (stateF != null) {
            StateBuilder stateB = new StateBuilder();
            if (stateF.size() > 1) {
                DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", State.class + MUST_BE_UNIQUE);
            }
            if (stateF.size() == 1) {
                stateB.build(this.clazz, stateF.iterator().next(), this.device, this.businessObject);
            }
        }
        if ((statusF = scanner.getFieldsAnnotatedWith(Status.class)) != null) {
            StatusBuilder statusB = new StatusBuilder();
            if (statusF.size() > 1) {
                DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", Status.class + MUST_BE_UNIQUE);
            }
            if (statusF.size() == 1) {
                statusB.build(this.clazz, statusF.iterator().next(), this.device, this.businessObject);
            }
        }
    }

    private void createBusinessObjectDeviceProperties(ReflectionScanner scanner) throws DevFailed {
        Set<Field> devicePropsF = scanner.getFieldsAnnotatedWith(DeviceProperties.class);
        if (devicePropsF != null) {
            DevicePropertiesBuilder devicePropsB = new DevicePropertiesBuilder();
            if (devicePropsF.size() > 1) {
                DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", DeviceProperties.class + MUST_BE_UNIQUE);
            }
            if (devicePropsF.size() == 1) {
                devicePropsB.build(this.clazz, devicePropsF.iterator().next(), this.device, this.businessObject);
            }
        }
    }

    private void createBusinessObjectProps(ReflectionScanner scanner) throws DevFailed {
        Set<Field> classPropF;
        Set<Field> devicePropF;
        Set<Field> devicePropsF = scanner.getFieldsAnnotatedWith(DeviceProperties.class);
        if (devicePropsF != null) {
            DevicePropertiesBuilder devicePropsB = new DevicePropertiesBuilder();
            if (devicePropsF.size() > 1) {
                DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", DeviceProperties.class + MUST_BE_UNIQUE);
            }
            if (devicePropsF.size() == 1) {
                devicePropsB.build(this.clazz, devicePropsF.iterator().next(), this.device, this.businessObject);
            }
        }
        if ((devicePropF = scanner.getFieldsAnnotatedWith(DeviceProperty.class)) != null) {
            DevicePropertyBuilder devicePropB = new DevicePropertyBuilder();
            for (Field field : devicePropF) {
                devicePropB.build(this.clazz, field, this.device, this.businessObject);
            }
        }
        if ((classPropF = scanner.getFieldsAnnotatedWith(ClassProperty.class)) != null) {
            ClassPropertyBuilder classPropB = new ClassPropertyBuilder();
            for (Field field : classPropF) {
                classPropB.build(this.clazz, field, this.device, this.businessObject);
            }
        }
    }

    private void checkIsTangoDevice(Class<?> clazz, String name) throws DevFailed {
        if (clazz == null) {
            DevFailedUtils.throwDevFailed("INIT_FAILED", "create device " + name + " - is not a tango device");
        }
        if (clazz.getAnnotation(Device.class) == null) {
            DevFailedUtils.throwDevFailed("INIT_FAILED", "create device " + name + " of class " + clazz.getName() + " - is not a tango device");
        }
    }
}

