/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.annotation.Command;
import org.tango.server.build.BuilderUtils;
import org.tango.server.command.CommandConfiguration;
import org.tango.server.command.CommandImpl;
import org.tango.server.command.ReflectCommandBehavior;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class CommandBuilder {
    private final Logger logger = LoggerFactory.getLogger(CommandBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(CommandBuilder.class);

    CommandBuilder() {
    }

    public void build(DeviceImpl device, Object businessObject, Method m, boolean isOnDeviceImpl) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        Command annot = m.getAnnotation(Command.class);
        Class<?>[] paramTypeTable = m.getParameterTypes();
        if (paramTypeTable.length > 1) {
            DevFailedUtils.throwDevFailed("INIT_FAILED", "Command can have only one parameter");
        }
        Class paramType = paramTypeTable.length == 0 ? Void.class : paramTypeTable[0];
        Class<?> returnedType = m.getReturnType();
        String cmdName = "".equals(annot.name()) ? m.getName() : annot.name();
        this.logger.debug("Has a command: {} type {}", (Object)cmdName, (Object)paramType.getCanonicalName());
        CommandConfiguration config = new CommandConfiguration(cmdName, paramType, returnedType, annot.inTypeDesc(), annot.outTypeDesc(), DispLevel.from_int(annot.displayLevel()), annot.isPolled(), annot.pollingPeriod());
        ReflectCommandBehavior behavior = null;
        behavior = isOnDeviceImpl ? new ReflectCommandBehavior(m, device, config) : new ReflectCommandBehavior(m, businessObject, config);
        CommandImpl command = new CommandImpl(behavior, device.getName());
        BuilderUtils.setStateMachine(m, command);
        device.addCommand(command);
        this.xlogger.exit();
    }
}

