/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.InvocationContext;
import org.tango.server.device.AroundInvokeImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class AroundInvokeBuilder {
    private final Logger logger = LoggerFactory.getLogger(AroundInvokeBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(AroundInvokeBuilder.class);

    AroundInvokeBuilder() {
    }

    public void build(Method method, DeviceImpl device, Object businessObject) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(InvocationContext.class) || !method.getReturnType().equals(Void.TYPE)) {
            DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", method + " be like: void invoke(InvocationContext ctx)");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            DevFailedUtils.throwDevFailed("TANGO_BUILD_FAILED", method + " must not be static");
        }
        this.logger.debug("has an AroundInvoke method {} ", (Object)method.getName());
        device.setAroundInvokeImpl(new AroundInvokeImpl(businessObject, method));
        this.xlogger.exit();
    }
}

