/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class AttributeAppender
extends AppenderBase<ILoggingEvent> {
    private final int depth;
    private volatile String[][] log;
    private int currentPosition;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yy.MM.dd '-' HH:mm:ss ");

    public AttributeAppender() {
        this(1000);
    }

    public AttributeAppender(int depth) {
        this.depth = depth;
        this.log = new String[depth][3];
        for (int i = 0; i < depth; ++i) {
            Arrays.fill(this.log[i], "");
        }
        this.currentPosition = 0;
    }

    @Override
    protected void append(ILoggingEvent eventObject) {
        this.log[this.currentPosition][0] = DATE_FORMAT.format(new Date(eventObject.getTimeStamp()));
        this.log[this.currentPosition][1] = eventObject.getLevel().toString();
        this.log[this.currentPosition][2] = eventObject.getFormattedMessage();
        ++this.currentPosition;
        if (this.currentPosition >= this.depth) {
            this.currentPosition = 0;
        }
    }

    public String[][] getLog() {
        return this.log;
    }
}

