/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server;

import fr.esrf.Tango.DevFailed;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.logging.LoggingManager;
import org.tango.orb.ORBManager;
import org.tango.server.annotation.TransactionType;
import org.tango.server.cache.TangoCacheManager;
import org.tango.server.events.EventManager;
import org.tango.server.export.TangoExporter;
import org.tango.utils.DevFailedUtils;

public final class ServerManager {
    private static final String SERVER_NAME_LOGGING = "serverName";
    private static final String NODB = "-nodb";
    public static final int SERVER_NAME_MAX_LENGTH = 255;
    private static final String INIT_ERROR = "INIT_ERROR";
    private final Logger logger = LoggerFactory.getLogger(ServerManager.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(ServerManager.class);
    private boolean useDb;
    private final AtomicBoolean isStarted = new AtomicBoolean();
    private static final ServerManager INSTANCE = new ServerManager();
    private String execName;
    private String instanceName;
    private String serverName;
    private String hostName;
    private String pid = "0";
    private final Map<String, Class<?>> tangoClasses = new LinkedHashMap();
    private TangoExporter tangoExporter;
    private String lastClass;
    private TransactionType transactionType;

    private ServerManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                MDC.put(ServerManager.SERVER_NAME_LOGGING, ServerManager.this.serverName);
                ServerManager.this.logger.debug("Shutdown hook unregister " + ServerManager.this.serverName);
                try {
                    ServerManager.getInstance().stop();
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
            }
        }));
    }

    public static ServerManager getInstance() {
        return INSTANCE;
    }

    public void addClass(String tangoClass, Class<?> deviceClass) {
        this.lastClass = tangoClass;
        this.tangoClasses.put(tangoClass, deviceClass);
    }

    public void startDevice(String deviceName, Class<?> deviceClass) throws DevFailed {
        if (!this.isStarted.get()) {
            DevFailedUtils.throwDevFailed("the server must be started");
        }
        if (this.tangoExporter != null && this.tangoClasses.containsValue(deviceClass)) {
            this.tangoExporter.buildDevice(deviceName, deviceClass);
        }
    }

    public void stopDevice(String deviceName) throws DevFailed {
        if (!this.isStarted.get()) {
            DevFailedUtils.throwDevFailed("the server must be started");
        }
        if (this.tangoExporter != null) {
            this.tangoExporter.unexportDevice(deviceName);
        }
    }

    public synchronized void start(String[] args, String execName) {
        if (!this.isStarted.get()) {
            try {
                this.init(args, execName);
            }
            catch (DevFailed e) {
                DevFailedUtils.printDevFailed(e);
            }
        }
    }

    public synchronized void startError(String[] args, String execName) throws DevFailed {
        if (this.isStarted.get()) {
            DevFailedUtils.throwDevFailed("this server is already started");
        }
        this.init(args, execName);
    }

    public synchronized void start(String[] args, Class<?> deviceClass) {
        if (!this.isStarted.get()) {
            this.addClass(deviceClass.getSimpleName(), deviceClass);
            try {
                this.init(args, deviceClass.getSimpleName());
            }
            catch (DevFailed e) {
                DevFailedUtils.printDevFailed(e);
            }
        }
    }

    private void init(String[] args, String execName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        System.setProperty("java.awt.headless", "true");
        this.execName = execName;
        this.checkArgs(args);
        this.serverName = this.execName + "/" + this.instanceName;
        MDC.put(SERVER_NAME_LOGGING, this.serverName);
        this.logger.debug("Starting server {}", (Object)this.serverName);
        StringBuilder tmp = new StringBuilder(this.serverName);
        if (tmp.length() > 255) {
            DevFailedUtils.throwDevFailed(INIT_ERROR, "The device server name is too long! Max length is 255 characters.");
        }
        this.isStarted.set(true);
        this.initPIDAndHostName();
        String toBeImported = "dserver/" + this.serverName;
        ORBManager.init(this.useDb, toBeImported);
        this.tangoExporter = new TangoExporter(this.hostName, this.serverName, this.pid, this.tangoClasses);
        this.tangoExporter.exportAll();
        this.logger.info("TANGO server {} started", (Object)this.serverName);
        ORBManager.startDetached();
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws DevFailed {
        try {
            if (this.isStarted.get()) {
                this.tangoClasses.clear();
                if (this.tangoExporter != null) {
                    this.tangoExporter.clearClass();
                    this.tangoExporter.unexportAll();
                }
                TangoCacheManager.shutdown();
                EventManager.getInstance().close();
            }
        }
        finally {
            ORBManager.shutdown();
            this.logger.info("everything has been shutdown normally");
            this.isStarted.set(false);
        }
    }

    private String getUsage() {
        return "usage : java -DTANGO_HOST=$TANGO_HOST " + this.execName + " instance_name [-v[trace level]]  [-nodb [-dlist <device name list>] [-file=fileName]]";
    }

    private void checkArgs(String[] argv) throws DevFailed {
        if (argv.length < 1) {
            DevFailedUtils.throwDevFailed(INIT_ERROR, this.getUsage());
        }
        this.instanceName = argv[0];
        this.useDb = true;
        DatabaseFactory.setUseDb(true);
        ArrayList<String> noDbDevices = new ArrayList();
        for (int i = 1; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.startsWith("-h")) {
                System.out.println("instance list for server " + this.execName + ": " + Arrays.toString(DatabaseFactory.getDatabase().getInstanceNameList(this.execName)));
                continue;
            }
            if (arg.startsWith("-v")) {
                try {
                    int level = Integer.parseInt(arg.substring(arg.lastIndexOf(118) + 1));
                    LoggingManager.getInstance().setLoggingLevel(level, this.tangoClasses.values().toArray(new Class[this.tangoClasses.size()]));
                }
                catch (NumberFormatException e) {
                    DevFailedUtils.throwDevFailed("Logging level error. Must be a number");
                }
                continue;
            }
            if (arg.startsWith("-dlist")) {
                noDbDevices = this.configureNoDB(argv, i);
                this.useDb = false;
                continue;
            }
            if (!arg.startsWith("-file")) continue;
            this.configureNoDBFile(argv, arg, noDbDevices);
            this.useDb = false;
        }
    }

    private List<String> configureNoDB(String[] argv, int currentIdx) throws DevFailed {
        ArrayList<String> noDbDevices = new ArrayList<String>();
        if (!ArrayUtils.contains(argv, NODB)) {
            DevFailedUtils.throwDevFailed(INIT_ERROR, this.getUsage());
        } else {
            for (int j = currentIdx + 1; j < argv.length && !argv[j].startsWith("-"); ++j) {
                String[] devices = argv[j].split(",");
                if (devices.length > 1) {
                    for (String device : devices) {
                        noDbDevices.add(device);
                    }
                } else {
                    noDbDevices.add(argv[j]);
                }
                this.logger.warn("Device with no db: " + argv[j]);
            }
            DatabaseFactory.setNoDbDevices(noDbDevices.toArray(new String[noDbDevices.size()]), this.lastClass);
        }
        return noDbDevices;
    }

    private void configureNoDBFile(String[] argv, String arg, List<String> noDbDevices) throws DevFailed {
        if (!ArrayUtils.contains(argv, NODB)) {
            DevFailedUtils.throwDevFailed(INIT_ERROR, this.getUsage());
        } else {
            String name = arg.split("=")[1];
            File file = new File(name);
            if (!file.exists() && !file.isFile()) {
                DevFailedUtils.throwDevFailed(INIT_ERROR, name + " does not exists or is not a file");
            }
            this.logger.warn("Tango Database is not used - with file {} ", (Object)file.getPath());
            DatabaseFactory.setDbFile(file, noDbDevices.toArray(new String[noDbDevices.size()]), this.lastClass);
        }
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    private void initPIDAndHostName() throws DevFailed {
        RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
        String pidAndHost = rmxb.getName();
        String[] splitted = pidAndHost.split("@");
        if (splitted.length > 1) {
            this.pid = splitted[0];
        }
        try {
            InetAddress addr = ORBManager.OAI_ADDR != null && !ORBManager.OAI_ADDR.isEmpty() ? InetAddress.getByName(ORBManager.OAI_ADDR) : InetAddress.getLocalHost();
            this.hostName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            DevFailedUtils.throwDevFailed(e);
        }
        this.logger.debug("pid: " + this.pid);
        this.logger.debug("hostName: " + this.hostName);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPid() {
        return this.pid;
    }

    public String getExecName() {
        return this.execName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String[] getDevicesOfClass(String tangoClass) throws DevFailed {
        return this.tangoExporter.getDevicesOfClass(tangoClass);
    }

    public String getAdminDeviceName() {
        return "dserver/" + this.serverName;
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }
}

