/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevSource;
import java.util.Arrays;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.utils.ClientIDUtil;

public final class InvocationContext {
    private final ContextType context;
    private final CallType callType;
    private final String[] names;
    private final ClntIdent clientID;

    public InvocationContext(ContextType context, CallType callType, ClntIdent clientID, String ... names) {
        this.context = context;
        this.callType = callType;
        this.names = names;
        this.clientID = clientID;
    }

    public String[] getNames() {
        return Arrays.copyOf(this.names, this.names.length);
    }

    public CallType getCallType() {
        return this.callType;
    }

    public ContextType getContext() {
        return this.context;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("context", (Object)this.context);
        builder.append("callType", (Object)this.callType);
        builder.append("clientID", ClientIDUtil.toString(this.clientID));
        builder.append("names", Arrays.toString(this.names));
        return builder.toString();
    }

    public ClntIdent getClientID() {
        return this.clientID;
    }

    public static enum CallType {
        DEV,
        CACHE,
        CACHE_DEV,
        POLLING,
        UNKNOWN;


        public static CallType getFromDevSource(DevSource devSource) {
            if (devSource == null) {
                return UNKNOWN;
            }
            switch (devSource.value()) {
                case 1: {
                    return CACHE;
                }
                case 0: {
                    return DEV;
                }
                case 2: {
                    return CACHE_DEV;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum ContextType {
        PRE_READ_ATTRIBUTES,
        PRE_READ_ATTRIBUTE,
        POST_READ_ATTRIBUTE,
        POST_READ_ATTRIBUTES,
        PRE_WRITE_ATTRIBUTE,
        POST_WRITE_ATTRIBUTE,
        PRE_COMMAND,
        POST_COMMAND,
        PRE_WRITE_READ_ATTRIBUTES,
        PRE_PIPE_WRITE,
        POST_PIPE_WRITE,
        PRE_PIPE_READ,
        POST_PIPE_READ,
        PRE_PIPE_WRITE_READ,
        POST_PIPE_WRITE_READ,
        POST_WRITE_READ_ATTRIBUTES;

    }
}

