/*
 * Decompiled with CFR 0.152.
 */
package org.tango.orb;

import java.net.InetAddress;
import java.net.Socket;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.ETF.Connection;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerRequestInterceptor
extends LocalObject
implements org.omg.PortableInterceptor.ServerRequestInterceptor {
    private final Logger logger = LoggerFactory.getLogger(ServerRequestInterceptor.class);
    private static final long serialVersionUID = 1L;
    private String clientHostName = "";
    private String giopHostAddress;
    private String clientIPAddress;
    private static final ServerRequestInterceptor INSTANCE = new ServerRequestInterceptor();

    private ServerRequestInterceptor() {
    }

    @Override
    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    @Override
    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        try {
            if (ri instanceof ServerRequestInfoImpl) {
                ServerRequestInfoImpl infoImpl = (ServerRequestInfoImpl)ri;
                Connection connection = infoImpl.getConnection().getTransport();
                if (connection instanceof ServerIIOPConnection) {
                    ServerIIOPConnection connex = (ServerIIOPConnection)connection;
                    Socket sock = connex.getSocket();
                    if (sock != null) {
                        this.clientIPAddress = sock.getInetAddress().getHostAddress();
                        int remotePort = sock.getPort();
                        this.clientHostName = InetAddress.getByName(this.clientIPAddress).getCanonicalHostName();
                        this.giopHostAddress = "giop:tcp:" + this.clientIPAddress + ":" + remotePort;
                    }
                } else {
                    InetAddress addr = InetAddress.getLocalHost();
                    this.clientIPAddress = addr.getHostAddress();
                    this.clientHostName = addr.getCanonicalHostName();
                    this.giopHostAddress = "giop:tcp:" + this.clientIPAddress;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("", e);
        }
    }

    @Override
    public void send_reply(ServerRequestInfo ri) {
    }

    @Override
    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    @Override
    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    @Override
    public String name() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void destroy() {
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public String getGiopHostAddress() {
        return this.giopHostAddress;
    }

    public static ServerRequestInterceptor getInstance() {
        return INSTANCE;
    }
}

