/*
 * Decompiled with CFR 0.152.
 */
package org.tango.command;

import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.tango.DeviceState;
import org.tango.utils.DevFailedUtils;

public enum CommandTangoType {
    VOID(0, Void.TYPE),
    DEVBOOLEAN(1, Boolean.TYPE),
    DEVVARBOOLEANARRAY(31, boolean[].class),
    DEVLONG64(23, Long.TYPE),
    DEVVARLONG64ARRAY(25, long[].class),
    DEVULONG64(24, Long.TYPE),
    DEVVARULONG64ARRAY(26, long[].class),
    DEVSHORT(2, Short.TYPE),
    DEVVARSHORTARRAY(10, short[].class),
    DEVUSHORT(6, Short.TYPE),
    DEVVARUSHORTARRAY(14, short[].class),
    DEVLONG(3, Integer.TYPE),
    DEVVARLONGARRAY(11, int[].class),
    DEVULONG(7, Integer.TYPE),
    DEVVARULONGARRAY(15, int[].class),
    DEVFLOAT(4, Float.TYPE),
    DEVVARFLOATARRAY(12, float[].class),
    DEVDOUBLE(5, Double.TYPE),
    DEVVARDOUBLEARRAY(13, double[].class),
    DEVSTRING(8, String.class),
    DEVVARSTRINGARRAY(16, String[].class),
    DEVSTATE(19, DevState.class),
    DEVVARCHARARRAY(9, byte[].class),
    DEVUCHAR(22, Byte.TYPE),
    DEVENCONDED(28, DevEncoded.class),
    DEVVARLONGSTRINGARRAY(17, DevVarLongStringArray.class),
    DEVVARDOUBLESTRINGARRAY(18, DevVarDoubleStringArray.class);

    private static final Map<Class<?>, CommandTangoType> CLASS_TYPE_MAP;
    private int tangoIDLType;
    private final Class<?> clazz;
    private static final Map<Integer, CommandTangoType> TANGO_TYPE_MAP;

    private CommandTangoType(int tangoIDLType, Class<?> clazz) {
        this.tangoIDLType = tangoIDLType;
        this.clazz = clazz;
    }

    public int getTangoIDLType() {
        return this.tangoIDLType;
    }

    public static CommandTangoType getTypeFromClass(Class<?> clazz) throws DevFailed {
        CommandTangoType type = CLASS_TYPE_MAP.get(clazz);
        if (type == null) {
            DevFailedUtils.throwDevFailed("TYPE_ERROR", clazz.getCanonicalName() + " is not a command type");
        }
        return type;
    }

    public static CommandTangoType getTypeFromTango(int tangoType) throws DevFailed {
        CommandTangoType result = TANGO_TYPE_MAP.get(tangoType);
        if (result == null) {
            DevFailedUtils.throwDevFailed("TYPE_ERROR", tangoType + " is not an command type");
        }
        return result;
    }

    public Class<?> getCmdClass() {
        return this.clazz;
    }

    static {
        CLASS_TYPE_MAP = new HashMap();
        CLASS_TYPE_MAP.put(Void.class, VOID);
        CLASS_TYPE_MAP.put(Void.TYPE, VOID);
        CLASS_TYPE_MAP.put(Boolean.class, DEVBOOLEAN);
        CLASS_TYPE_MAP.put(Boolean.TYPE, DEVBOOLEAN);
        CLASS_TYPE_MAP.put(Boolean[].class, DEVVARBOOLEANARRAY);
        CLASS_TYPE_MAP.put(boolean[].class, DEVVARBOOLEANARRAY);
        CLASS_TYPE_MAP.put(Short.class, DEVSHORT);
        CLASS_TYPE_MAP.put(Short.TYPE, DEVSHORT);
        CLASS_TYPE_MAP.put(Short[].class, DEVVARSHORTARRAY);
        CLASS_TYPE_MAP.put(short[].class, DEVVARSHORTARRAY);
        CLASS_TYPE_MAP.put(Long.class, DEVLONG64);
        CLASS_TYPE_MAP.put(Long.TYPE, DEVLONG64);
        CLASS_TYPE_MAP.put(Long[].class, DEVVARLONG64ARRAY);
        CLASS_TYPE_MAP.put(long[].class, DEVVARLONG64ARRAY);
        CLASS_TYPE_MAP.put(Float.class, DEVFLOAT);
        CLASS_TYPE_MAP.put(Float.TYPE, DEVFLOAT);
        CLASS_TYPE_MAP.put(Float[].class, DEVVARFLOATARRAY);
        CLASS_TYPE_MAP.put(float[].class, DEVVARFLOATARRAY);
        CLASS_TYPE_MAP.put(Double.class, DEVDOUBLE);
        CLASS_TYPE_MAP.put(Double.TYPE, DEVDOUBLE);
        CLASS_TYPE_MAP.put(Double[].class, DEVVARDOUBLEARRAY);
        CLASS_TYPE_MAP.put(double[].class, DEVVARDOUBLEARRAY);
        CLASS_TYPE_MAP.put(String.class, DEVSTRING);
        CLASS_TYPE_MAP.put(String[].class, DEVVARSTRINGARRAY);
        CLASS_TYPE_MAP.put(Integer.class, DEVLONG);
        CLASS_TYPE_MAP.put(Integer.TYPE, DEVLONG);
        CLASS_TYPE_MAP.put(Integer[].class, DEVVARLONGARRAY);
        CLASS_TYPE_MAP.put(int[].class, DEVVARLONGARRAY);
        CLASS_TYPE_MAP.put(DevState.class, DEVSTATE);
        CLASS_TYPE_MAP.put(DevState[].class, DEVSTATE);
        CLASS_TYPE_MAP.put(DeviceState.class, DEVSTATE);
        CLASS_TYPE_MAP.put(DeviceState[].class, DEVSTATE);
        CLASS_TYPE_MAP.put(Byte.class, DEVUCHAR);
        CLASS_TYPE_MAP.put(Byte.TYPE, DEVUCHAR);
        CLASS_TYPE_MAP.put(Byte[].class, DEVVARCHARARRAY);
        CLASS_TYPE_MAP.put(byte[].class, DEVVARCHARARRAY);
        CLASS_TYPE_MAP.put(DevEncoded.class, DEVENCONDED);
        CLASS_TYPE_MAP.put(DevEncoded[].class, DEVENCONDED);
        CLASS_TYPE_MAP.put(DevVarLongStringArray.class, DEVVARLONGSTRINGARRAY);
        CLASS_TYPE_MAP.put(DevVarDoubleStringArray.class, DEVVARDOUBLESTRINGARRAY);
        TANGO_TYPE_MAP = new HashMap<Integer, CommandTangoType>();
        for (CommandTangoType s : EnumSet.allOf(CommandTangoType.class)) {
            TANGO_TYPE_MAP.put(s.getTangoIDLType(), s);
        }
    }
}

