/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database.cache;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.DeviceData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.client.database.cache.AttributeCache;
import org.tango.client.database.cache.ClassCache;
import org.tango.client.database.cache.DeviceCache;
import org.tango.utils.DevFailedUtils;

public final class ServerCache {
    private static final String NOT_FOUND = "Not found";
    private final Logger logger = LoggerFactory.getLogger(ServerCache.class);
    private final Connection database;
    private final List<String> adminInfos = new LinkedList<String>();
    private String adminDeviceName;
    private String adminClassName;
    private final Map<String, ClassCache> classCaches = new HashMap<String, ClassCache>();
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Map<String, DeviceCache> deviceCaches = new HashMap<String, DeviceCache>();

    public ServerCache(Connection database) throws DevFailed {
        this.database = database;
    }

    public void fillCache(String serverName, String hostName) throws DevFailed {
        if (!this.servers.containsKey(serverName)) {
            int j;
            int nbProperties;
            this.database.set_timeout_millis(13000);
            DeviceData in = new DeviceData();
            in.insert(new String[]{serverName, hostName});
            this.logger.debug("filling cache of server {} with host name {}", (Object)serverName, (Object)hostName);
            String[] out = this.database.command_inout("DbGetDataForServerCache", in).extractStringArray();
            if (out.length == 2) {
                DevFailedUtils.throwDevFailed("cache for " + serverName + " not found");
            }
            int i = 0;
            this.adminDeviceName = out[i++];
            this.adminInfos.add(this.adminDeviceName);
            ClassCache adminCache = null;
            if (!out[i].equalsIgnoreCase(NOT_FOUND)) {
                this.adminInfos.add(out[i++]);
                this.adminInfos.add(out[i++]);
                this.adminInfos.add(out[i++]);
                this.adminInfos.add(out[i++]);
                this.adminInfos.add(out[i++]);
                this.adminInfos.add(out[i++]);
                this.adminClassName = out[i++];
                this.adminInfos.add(this.adminClassName);
                adminCache = new ClassCache(this.adminClassName);
                this.classCaches.put(this.adminClassName, adminCache);
            }
            this.logger.debug("filling cache, adminInfos = {} ", (Object)this.adminInfos);
            i = out[++i].equalsIgnoreCase(NOT_FOUND) ? ++i : (i += 5);
            i = out[++i].equalsIgnoreCase(NOT_FOUND) ? ++i : (i += 5);
            if (out[i].equalsIgnoreCase(this.adminClassName)) {
                int n = ++i;
                ++i;
                nbProperties = Integer.parseInt(out[n]);
                for (j = 0; j < nbProperties; ++j) {
                    String propertyName = out[i++];
                    int propertySize = Integer.parseInt(out[i++]);
                    String[] propertyValue = new String[propertySize];
                    for (int k = 0; k < propertyValue.length; ++k) {
                        propertyValue[k] = out[i++];
                    }
                    adminCache.addProperty(propertyName, propertyValue);
                }
            }
            this.logger.debug("admin class properties cache is {}", (Object)adminCache);
            if (out[i].equalsIgnoreCase("Default")) {
                int n = ++i;
                ++i;
                nbProperties = Integer.parseInt(out[n]);
                for (j = 0; j < nbProperties; ++j) {
                    int n2 = ++i;
                    ++i;
                    int propertySize = Integer.parseInt(out[n2]);
                    String[] propertyValue = new String[propertySize];
                    for (int k = 0; k < propertyValue.length; ++k) {
                        propertyValue[k] = out[i++];
                    }
                }
            }
            DeviceCache adminDeviceCache = new DeviceCache(this.adminDeviceName);
            this.deviceCaches.put(this.adminDeviceName, adminDeviceCache);
            if (out[i].equalsIgnoreCase(this.adminDeviceName)) {
                int n = ++i;
                ++i;
                int nbProperties2 = Integer.parseInt(out[n]);
                for (int j2 = 0; j2 < nbProperties2; ++j2) {
                    String propertyName = out[i++];
                    int propertySize = Integer.parseInt(out[i++]);
                    String[] propertyValue = new String[propertySize];
                    for (int k = 0; k < propertyValue.length; ++k) {
                        propertyValue[k] = out[i++];
                    }
                    adminDeviceCache.addProperty(propertyName, propertyValue);
                    adminCache.addDeviceCache(adminDeviceCache);
                }
            }
            this.logger.debug("admin class properties cache is {}", (Object)adminDeviceCache);
            if (out[i].equalsIgnoreCase(serverName)) {
                Server s = new Server();
                int n = ++i;
                ++i;
                int classNr = Integer.parseInt(out[n]);
                String[] classeNames = new String[classNr];
                for (int j3 = 0; j3 < classNr; ++j3) {
                    int l;
                    String[] propertyValue;
                    int propertySize;
                    String className = out[i++];
                    ClassCache classCache = new ClassCache(className);
                    classeNames[j3] = className;
                    int classPropertiesNr = Integer.parseInt(out[i++]);
                    for (int k = 0; k < classPropertiesNr; ++k) {
                        String propertyName = out[i++];
                        propertySize = Integer.parseInt(out[i++]);
                        propertyValue = new String[propertySize];
                        for (l = 0; l < propertyValue.length; ++l) {
                            propertyValue[l] = out[i++];
                        }
                        classCache.addProperty(propertyName, propertyValue);
                    }
                    this.logger.debug("{} class cache is {}", (Object)className, (Object)classCache);
                    int n3 = ++i;
                    ++i;
                    int classAttrPropertiesNr = Integer.parseInt(out[n3]);
                    for (int k = 0; k < classAttrPropertiesNr; ++k) {
                        int n4 = ++i;
                        ++i;
                        propertySize = Integer.parseInt(out[n4]);
                        propertyValue = new String[propertySize];
                        for (l = 0; l < propertyValue.length; ++l) {
                            propertyValue[l] = out[i++];
                        }
                    }
                    int n5 = ++i;
                    ++i;
                    int deviceNr = Integer.parseInt(out[n5]);
                    i += deviceNr;
                    String[] deviceNames = new String[deviceNr];
                    for (int k = 0; k < deviceNr; ++k) {
                        String deviceName = out[i++];
                        DeviceCache deviceCache = new DeviceCache(deviceName);
                        this.deviceCaches.put(deviceName, deviceCache);
                        deviceNames[k] = deviceName;
                        int devicePropertiesNr = Integer.parseInt(out[i++]);
                        for (int l2 = 0; l2 < devicePropertiesNr; ++l2) {
                            String propertyName = out[i++];
                            int propertySize2 = Integer.parseInt(out[i++]);
                            String[] propertyValue2 = new String[propertySize2];
                            for (int m = 0; m < propertyValue2.length; ++m) {
                                propertyValue2[m] = out[i++];
                            }
                            deviceCache.addProperty(propertyName, propertyValue2);
                        }
                        this.logger.debug("{} device cache is {}", (Object)deviceName, (Object)deviceCache);
                        classCache.addDeviceCache(deviceCache);
                        int n6 = ++i;
                        ++i;
                        int attrPropertiesNr = Integer.parseInt(out[n6]);
                        for (int l3 = 0; l3 < attrPropertiesNr; ++l3) {
                            String attributeName = out[i++];
                            AttributeCache attributeCache = new AttributeCache(attributeName);
                            int propertyNr = Integer.parseInt(out[i++]);
                            for (int m = 0; m < propertyNr; ++m) {
                                String propertyName = out[i++];
                                int propertySize3 = Integer.parseInt(out[i++]);
                                String[] propertyValue3 = new String[propertySize3];
                                for (int n7 = 0; n7 < propertyValue3.length; ++n7) {
                                    propertyValue3[n7] = out[i++];
                                }
                                attributeCache.addProperty(propertyName, propertyValue3);
                            }
                            this.logger.debug("{} attribute cache is {}", (Object)attributeName, (Object)attributeCache);
                            deviceCache.addAttributeCache(attributeCache);
                        }
                    }
                    this.classCaches.put(className, classCache);
                    s.addClass(className, deviceNames);
                }
                this.servers.put(serverName, s);
                this.logger.debug("servers {}", (Object)this.servers);
            }
            this.database.set_timeout_millis(3000);
        }
    }

    public DeviceCache getDeviceCache(String name) {
        return this.deviceCaches.get(name);
    }

    public ClassCache getClassCache(String name) {
        return this.classCaches.get(name);
    }

    public String[] getDeviceList(String serverName, String className) {
        String[] devices;
        String[] result = new String[]{};
        Server server = this.servers.get(serverName);
        if (server != null && (devices = server.getDevices(className)) != null) {
            result = Arrays.copyOf(devices, devices.length);
        }
        return result;
    }

    private class Server {
        private final Map<String, String[]> devicesPerServer = new HashMap<String, String[]>();

        private Server() {
        }

        public void addClass(String className, String[] deviceNames) {
            this.devicesPerServer.put(className, deviceNames);
        }

        public String[] getDevices(String className) {
            return this.devicesPerServer.get(className);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

