/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database.cache;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.tango.TangoHostManager;
import org.tango.client.database.DeviceExportInfo;
import org.tango.client.database.DeviceImportInfo;
import org.tango.client.database.cache.ICachableDatabase;
import org.tango.utils.CaseInsensitiveMap;

public final class NoCacheDatabase
implements ICachableDatabase {
    private final Database database;

    public NoCacheDatabase(String host, String port) throws DevFailed {
        this.database = new Database(host, port);
        this.database.isCommandAllowed("database", "DbImportDevice");
    }

    @Override
    public void exportDevice(DeviceExportInfo info) throws DevFailed {
        String[] array = info.toStringArray();
        DeviceData argin = new DeviceData();
        argin.insert(array);
        this.database.command_inout("DbExportDevice", argin);
    }

    @Override
    public String[] getInstanceNameList(String dsExecName) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(dsExecName);
        DeviceData argout = this.database.command_inout("DbGetInstanceNameList", argin);
        return argout.extractStringArray();
    }

    @Override
    public DeviceImportInfo importDevice(String toBeImported) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(toBeImported);
        DeviceData argout = this.database.command_inout("DbImportDevice", argin);
        DevVarLongStringArray info = argout.extractLongStringArray();
        return new DeviceImportInfo(info);
    }

    @Override
    public void unexportServer(String serverName) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(serverName);
        this.database.command_inout("DbUnExportServer", argin);
    }

    @Override
    public String[] getDeviceList(String serverName, String className) throws DevFailed {
        DeviceData send = new DeviceData();
        send.insert(new String[]{serverName, className});
        DeviceData received = this.database.command_inout("DbGetDeviceList", send);
        return received.extractStringArray();
    }

    @Override
    public Map<String, String[]> getDeviceProperties(String name, String ... propertyNames) throws DevFailed {
        Map<String, String[]> map = propertyNames.length == 0 ? this.getProperties(PropertyType.Device, name) : this.getProperty(PropertyType.Device, name, propertyNames);
        return map;
    }

    @Override
    public void setDeviceProperties(String deviceName, Map<String, String[]> properties) throws DevFailed {
        List<String> args = this.getArray(properties, deviceName);
        DeviceData argin = new DeviceData();
        argin.insert(args.toArray(new String[args.size()]));
        this.database.command_inout("DbPutDeviceProperty", argin);
    }

    @Override
    public Map<String, String[]> getClassProperties(String name, String ... propertyNames) throws DevFailed {
        Map<String, String[]> map = propertyNames.length == 0 ? this.getProperties(PropertyType.Class, name) : this.getProperty(PropertyType.Class, name, propertyNames);
        return map;
    }

    @Override
    public void setClassProperties(String name, Map<String, String[]> properties) throws DevFailed {
        List<String> args = this.getArray(properties, name);
        DeviceData argin = new DeviceData();
        argin.insert(args.toArray(new String[args.size()]));
        this.database.command_inout("DbPutClassProperty", argin);
    }

    @Override
    public Map<String, String[]> getAttributeProperties(String deviceName, String attributeName) throws DevFailed {
        DeviceData argin = new DeviceData();
        ArrayList<String> args = new ArrayList<String>();
        args.add(deviceName);
        args.add(attributeName);
        argin.insert(args.toArray(new String[args.size()]));
        DeviceData argout = this.database.command_inout("DbGetDeviceAttributeProperty2", argin);
        String[] result = argout.extractStringArray();
        Map<String, String[]> map = this.extractArgout(result, 4);
        return map;
    }

    @Override
    public void setAttributeProperties(String deviceName, String attributeName, Map<String, String[]> properties) throws DevFailed {
        DeviceData argin = new DeviceData();
        ArrayList<String> args = new ArrayList<String>();
        args.add(deviceName);
        args.add(Integer.toString(1));
        args.add(attributeName);
        args.add(Integer.toString(properties.size()));
        for (Map.Entry<String, String[]> entry : properties.entrySet()) {
            args.add(entry.getKey());
            String[] propValues = entry.getValue();
            args.add(Integer.toString(propValues.length));
            for (String propValue : propValues) {
                args.add(propValue);
            }
        }
        argin.insert(args.toArray(new String[args.size()]));
        this.database.command_inout("DbPutDeviceAttributeProperty2", argin);
    }

    private Map<String, String[]> getProperties(PropertyType type, String devOrClass) throws DevFailed {
        DeviceData argin = new DeviceData();
        if (type.equals((Object)PropertyType.Class)) {
            argin.insert(devOrClass);
        } else {
            argin.insert(new String[]{devOrClass, "*"});
        }
        DeviceData argout = this.database.command_inout("DbGet" + (Object)((Object)type) + "PropertyList", argin);
        ArrayList<String> properties = new ArrayList<String>(Arrays.asList(argout.extractStringArray()));
        properties.remove("logging_level");
        properties.remove("logging_target");
        properties.remove("poll_old_factor");
        properties.remove("poll_ring_depth");
        properties.remove(devOrClass);
        Map<String, String[]> map = properties.size() > 0 ? this.getProperty(type, devOrClass, properties.toArray(new String[properties.size()])) : new HashMap<String, String[]>();
        return map;
    }

    private Map<String, String[]> getProperty(PropertyType type, String devOrClass, String ... propNames) throws DevFailed {
        String[] array = ArrayUtils.add(propNames, 0, devOrClass);
        DeviceData argin = new DeviceData();
        argin.insert(array);
        DeviceData argout = this.database.command_inout("DbGet" + (Object)((Object)type) + "Property", argin);
        String[] result = argout.extractStringArray();
        return this.extractArgout(result, 2);
    }

    private Map<String, String[]> extractArgout(String[] result, int startingPoint) {
        CaseInsensitiveMap<String[]> map = new CaseInsensitiveMap<String[]>();
        if (result.length > 4) {
            int i = startingPoint;
            int nextSize = Integer.valueOf(result[i + 1]);
            while (i < result.length) {
                int idxNextPropSize;
                if (nextSize > 0) {
                    String name = result[i].toLowerCase(Locale.ENGLISH);
                    String[] propValues = Arrays.copyOfRange(result, i + 2, nextSize + i + 2);
                    map.put(name, propValues);
                }
                if (nextSize == 0) {
                    idxNextPropSize = i + 4;
                    i += 3;
                } else {
                    idxNextPropSize = nextSize + i + 3;
                    i = nextSize + i + 2;
                }
                if (idxNextPropSize >= result.length) break;
                nextSize = Integer.valueOf(result[idxNextPropSize]);
            }
        }
        return map;
    }

    @Override
    public void deleteDeviceProperty(String deviceName, String propertyName) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{deviceName, propertyName});
        this.database.command_inout("DbDeleteDeviceProperty", argin);
    }

    @Override
    public void deleteAttributeProperties(String deviceName, String ... attributeNames) throws DevFailed {
        DeviceData argin = new DeviceData();
        if (attributeNames == null || attributeNames.length == 0) {
            argin.insert(new String[]{deviceName, "*"});
        } else {
            argin.insert(ArrayUtils.add(attributeNames, 0, deviceName));
        }
        this.database.command_inout("DbDeleteAllDeviceAttributeProperty", argin);
    }

    @Override
    public void deleteDevicePipeProperties(String deviceName, String ... pipeNames) throws DevFailed {
        DeviceData argin = new DeviceData();
        if (pipeNames == null || pipeNames.length == 0) {
            argin.insert(new String[]{deviceName, "*"});
        } else {
            argin.insert(ArrayUtils.add(pipeNames, 0, deviceName));
        }
        this.database.command_inout("DbDeleteAllDevicePipeProperty", argin);
    }

    @Override
    public void loadCache(String serverName, String hostName) throws DevFailed {
    }

    @Override
    public void clearCache() {
    }

    @Override
    public String getVersion() {
        return "no cache";
    }

    @Override
    public boolean isCacheAvailable() {
        return false;
    }

    @Override
    public String getAccessDeviceName() throws DevFailed {
        String[] r;
        String access = "";
        DbDatum prop = this.database.get_property("CtrlSystem", "Services");
        if (prop != null && (r = prop.extractStringArray()) != null) {
            for (String string : r) {
                if (!string.startsWith("AccessControl")) continue;
                access = string.substring(string.indexOf(58) + 1);
            }
        }
        return access;
    }

    @Override
    public String[] getPossibleTangoHosts() throws DevFailed {
        String[] tangoHosts = null;
        try {
            DeviceData deviceData = this.database.command_inout("DbGetCSDbServerList");
            tangoHosts = deviceData.extractStringArray();
        }
        catch (DevFailed e) {
            String desc = e.errors[0].desc.toLowerCase();
            if (desc.startsWith("command ") && desc.endsWith("not found")) {
                tangoHosts = new String[]{TangoHostManager.getFirstFullTangoHost()};
            }
            throw e;
        }
        return tangoHosts;
    }

    @Override
    public String getFreeProperty(String name, String propertyName) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{name, propertyName});
        DeviceData deviceData = this.database.command_inout("DbGetProperty", argin);
        String result = "";
        if (deviceData.extractStringArray().length > 4) {
            result = deviceData.extractStringArray()[4];
        }
        return result;
    }

    @Override
    public Map<String, String[]> getDevicePipeProperties(String deviceName, String pipeName) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{deviceName, pipeName});
        DeviceData argout = this.database.command_inout("DbGetDevicePipeProperty", argin);
        String[] result = argout.extractStringArray();
        return this.extractArgout(result, 4);
    }

    @Override
    public void setDevicePipeProperties(String deviceName, String pipeName, Map<String, String[]> properties) throws DevFailed {
        List<String> args = this.getArray(properties, deviceName, "1", pipeName);
        DeviceData argin = new DeviceData();
        String[] array = args.toArray(new String[args.size()]);
        argin.insert(array);
        this.database.command_inout("DbPutDevicePipeProperty", argin);
    }

    @Override
    public Map<String, String[]> getClassPipeProperties(String className, String pipeName) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(new String[]{className, pipeName});
        DeviceData argout = this.database.command_inout("DbGetClassPipeProperty", argin);
        String[] result = argout.extractStringArray();
        return this.extractArgout(result, 2);
    }

    @Override
    public void setClassPipeProperties(String className, String pipeName, Map<String, String[]> properties) throws DevFailed {
        List<String> args = this.getArray(properties, className);
        DeviceData argin = new DeviceData();
        argin.insert(args.toArray(new String[args.size()]));
        this.database.command_inout("DbPutClassPipeProperty", argin);
    }

    private List<String> getArray(Map<String, String[]> properties, String ... start) {
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < start.length; ++i) {
            args.add(start[i]);
        }
        args.add(Integer.toString(properties.size()));
        for (Map.Entry<String, String[]> entry : properties.entrySet()) {
            args.add(entry.getKey());
            String[] propValues = entry.getValue();
            args.add(Integer.toString(propValues.length));
            for (String propValue : propValues) {
                args.add(propValue);
            }
        }
        return args;
    }

    private static enum PropertyType {
        Class,
        Device;

    }
}

