/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database.cache;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.client.database.DeviceExportInfo;
import org.tango.client.database.DeviceImportInfo;
import org.tango.client.database.cache.AttributeCache;
import org.tango.client.database.cache.ClassCache;
import org.tango.client.database.cache.DeviceCache;
import org.tango.client.database.cache.ICachableDatabase;
import org.tango.client.database.cache.NoCacheDatabase;
import org.tango.client.database.cache.ServerCache;
import org.tango.utils.CaseInsensitiveMap;

public final class DatabaseCache
implements ICachableDatabase {
    private static final String RELEASE_1_X = "release 1\\.[7-9]";
    private final Logger logger = LoggerFactory.getLogger(ServerCache.class);
    private ServerCache serverCache;
    private boolean isCacheAvailable;
    private final NoCacheDatabase dbDevice;
    private final String version;
    private final Connection database;

    public DatabaseCache(Connection database, NoCacheDatabase dbDevice) throws DevFailed {
        this.dbDevice = dbDevice;
        AttributeProxy attr = new AttributeProxy(database.get_device().name() + "/StoredProcedureRelease");
        this.version = attr.read().extractString();
        this.logger.debug("current database cache version {}", (Object)this.version);
        this.isCacheAvailable = Pattern.matches(RELEASE_1_X, this.version);
        this.database = database;
    }

    @Override
    public void loadCache(String serverName, String hostName) throws DevFailed {
        if (this.isCacheAvailable) {
            try {
                this.serverCache = new ServerCache(this.database);
                this.serverCache.fillCache(serverName, hostName);
            }
            catch (DevFailed e) {
                this.serverCache = null;
                this.logger.error("Failed to load cache for server {} on host {}", (Object)serverName, (Object)hostName);
                this.logger.error("Failed to load cache, do not use it", e);
            }
            catch (Throwable e) {
                this.serverCache = null;
                this.logger.error("Failed to load cache, do not use it", e);
            }
        }
    }

    @Override
    public void clearCache() {
        this.serverCache = null;
    }

    @Override
    public void exportDevice(DeviceExportInfo info) throws DevFailed {
        this.dbDevice.exportDevice(info);
    }

    @Override
    public String[] getInstanceNameList(String dsExecName) throws DevFailed {
        return this.dbDevice.getInstanceNameList(dsExecName);
    }

    @Override
    public DeviceImportInfo importDevice(String toBeImported) throws DevFailed {
        return this.dbDevice.importDevice(toBeImported);
    }

    @Override
    public void unexportServer(String serverName) throws DevFailed {
        this.dbDevice.unexportServer(serverName);
    }

    @Override
    public String[] getDeviceList(String serverName, String className) throws DevFailed {
        return this.dbDevice.getDeviceList(serverName, className);
    }

    @Override
    public Map<String, String[]> getDeviceProperties(String name, String ... propertyNames) throws DevFailed {
        Map<Object, Object> result = new HashMap();
        if (this.serverCache == null) {
            result = this.dbDevice.getDeviceProperties(name, propertyNames);
        } else {
            DeviceCache deviceCache = this.serverCache.getDeviceCache(name);
            if (deviceCache != null) {
                Map<String, String[]> props = deviceCache.getPropertiesCache();
                if (propertyNames.length == 0 || props.size() == propertyNames.length) {
                    result = props;
                } else {
                    for (String propertyName : propertyNames) {
                        result.put(propertyName, props.get(propertyName));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void setDeviceProperties(String deviceName, Map<String, String[]> properties) throws DevFailed {
        if (this.serverCache != null) {
            DeviceCache deviceCache = this.serverCache.getDeviceCache(deviceName);
            if (deviceCache == null) {
                deviceCache = new DeviceCache(deviceName);
            }
            deviceCache.addProperties(properties);
        }
        this.dbDevice.setDeviceProperties(deviceName, properties);
    }

    @Override
    public Map<String, String[]> getClassProperties(String name, String ... propertyNames) throws DevFailed {
        Map<Object, Object> result = new HashMap();
        if (this.serverCache == null) {
            result = this.dbDevice.getClassProperties(name, propertyNames);
        } else {
            ClassCache classCache = this.serverCache.getClassCache(name);
            if (classCache != null) {
                Map<String, String[]> props = classCache.getPropertiesCache();
                if (propertyNames.length == 0 || props.size() == propertyNames.length) {
                    result = props;
                } else {
                    for (String propertyName : propertyNames) {
                        result.put(propertyName, props.get(propertyName));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void setClassProperties(String name, Map<String, String[]> properties) throws DevFailed {
        if (this.serverCache != null) {
            ClassCache classCache = this.serverCache.getClassCache(name);
            if (classCache == null) {
                classCache = new ClassCache(name);
            }
            classCache.addProperties(properties);
        }
        this.dbDevice.setClassProperties(name, properties);
    }

    @Override
    public Map<String, String[]> getAttributeProperties(String deviceName, String attributeName) throws DevFailed {
        Map<String, Object> result = new CaseInsensitiveMap();
        if (this.serverCache == null) {
            result = this.dbDevice.getAttributeProperties(deviceName, attributeName);
        } else {
            AttributeCache attributeCache;
            DeviceCache deviceCache = this.serverCache.getDeviceCache(deviceName);
            if (deviceCache != null && (attributeCache = deviceCache.getAttributeCache(attributeName)) != null) {
                Map<String, String[]> props = attributeCache.getPropertiesCache();
                result = props;
            }
        }
        return result;
    }

    @Override
    public void setAttributeProperties(String deviceName, String attributeName, Map<String, String[]> properties) throws DevFailed {
        if (this.serverCache != null) {
            AttributeCache attributeCache;
            DeviceCache deviceCache = this.serverCache.getDeviceCache(deviceName);
            if (deviceCache == null) {
                deviceCache = new DeviceCache(deviceName);
            }
            if ((attributeCache = deviceCache.getAttributeCache(attributeName)) == null) {
                attributeCache = new AttributeCache(attributeName);
            }
            attributeCache.addProperties(properties);
        }
        this.dbDevice.setAttributeProperties(deviceName, attributeName, properties);
    }

    @Override
    public void deleteDeviceProperty(String deviceName, String propertyName) throws DevFailed {
        DeviceCache deviceCache;
        if (this.serverCache != null && (deviceCache = this.serverCache.getDeviceCache(deviceName)) != null) {
            deviceCache.removeProperty(propertyName);
        }
        this.dbDevice.deleteDeviceProperty(deviceName, propertyName);
    }

    @Override
    public boolean isCacheAvailable() {
        return this.isCacheAvailable;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getAccessDeviceName() throws DevFailed {
        return this.dbDevice.getAccessDeviceName();
    }

    @Override
    public void deleteAttributeProperties(String deviceName, String ... attributeNames) throws DevFailed {
        DeviceCache deviceCache;
        if (this.serverCache != null && (deviceCache = this.serverCache.getDeviceCache(deviceName)) != null) {
            for (String attributeName : attributeNames) {
                AttributeCache attributeCache = deviceCache.getAttributeCache(attributeName);
                if (attributeCache == null) continue;
                attributeCache.removeAll();
            }
        }
        this.dbDevice.deleteAttributeProperties(deviceName, attributeNames);
    }

    @Override
    public String[] getPossibleTangoHosts() throws DevFailed {
        return this.dbDevice.getPossibleTangoHosts();
    }

    @Override
    public String getFreeProperty(String name, String propertyName) throws DevFailed {
        return this.dbDevice.getFreeProperty(name, propertyName);
    }

    @Override
    public Map<String, String[]> getDevicePipeProperties(String deviceName, String pipeName) throws DevFailed {
        return this.dbDevice.getDevicePipeProperties(deviceName, pipeName);
    }

    @Override
    public void setDevicePipeProperties(String deviceName, String pipeName, Map<String, String[]> properties) throws DevFailed {
        this.dbDevice.setDevicePipeProperties(deviceName, pipeName, properties);
    }

    @Override
    public Map<String, String[]> getClassPipeProperties(String className, String pipeName) throws DevFailed {
        return this.dbDevice.getClassPipeProperties(className, pipeName);
    }

    @Override
    public void setClassPipeProperties(String className, String pipeName, Map<String, String[]> properties) throws DevFailed {
        this.dbDevice.setClassPipeProperties(className, pipeName, properties);
    }

    @Override
    public void deleteDevicePipeProperties(String deviceName, String ... pipeNames) throws DevFailed {
        this.dbDevice.deleteDevicePipeProperties(deviceName, pipeNames);
    }
}

