/*
 * Decompiled with CFR 0.152.
 */
package org.tango.client.database.cache;

import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.utils.CaseInsensitiveMap;

public final class AttributeCache {
    private final String name;
    private final Map<String, String[]> propertiesCache = new CaseInsensitiveMap<String[]>();

    AttributeCache(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addProperty(String propertyName, String[] propertyValue) {
        this.propertiesCache.put(propertyName, propertyValue);
    }

    public Map<String, String[]> getPropertiesCache() {
        return new CaseInsensitiveMap<String[]>(this.propertiesCache);
    }

    public void addProperties(Map<String, String[]> properties) {
        this.propertiesCache.putAll(properties);
    }

    public void removeAll() {
        this.propertiesCache.clear();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

