/*
 * Decompiled with CFR 0.152.
 */
package org.tango.attribute;

import fr.esrf.Tango.AttributeDataType;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tango.DeviceState;
import org.tango.utils.DevFailedUtils;

public enum AttributeTangoType {
    DEVBOOLEAN(AttributeDataType.ATT_BOOL, 1, Boolean.TYPE),
    DEVLONG64(AttributeDataType.ATT_LONG64, 23, Long.TYPE),
    DEVULONG64(AttributeDataType.ATT_ULONG64, 24, Long.TYPE),
    DEVSHORT(AttributeDataType.ATT_SHORT, 2, Short.TYPE),
    DEVUSHORT(AttributeDataType.ATT_USHORT, 6, Short.TYPE),
    DEVLONG(AttributeDataType.ATT_LONG, 3, Integer.TYPE),
    DEVULONG(AttributeDataType.ATT_ULONG, 7, Integer.TYPE),
    DEVFLOAT(AttributeDataType.ATT_FLOAT, 4, Float.TYPE),
    DEVDOUBLE(AttributeDataType.ATT_DOUBLE, 5, Double.TYPE),
    DEVSTRING(AttributeDataType.ATT_STRING, 8, String.class),
    DEVSTATE(AttributeDataType.ATT_STATE, 19, DevState.class),
    DEVUCHAR(AttributeDataType.ATT_UCHAR, 22, Byte.TYPE),
    DEVENCODED(AttributeDataType.ATT_ENCODED, 28, DevEncoded.class),
    DEVENUM(AttributeDataType.ATT_SHORT, 29, Short.TYPE);

    private final AttributeDataType attributeDataType;
    private final Class<?> type;
    private final int tangoIDLType;
    private static final Map<Integer, AttributeTangoType> TANGO_TYPE_MAP;
    private static Class<?>[] OBJECTS;
    public static final List<Class<?>> ATTRIBUTE_CLASSES;
    private static final Map<Class<?>, Object> DEFAULT_VALUES;
    private static final Map<Class<?>, AttributeTangoType> CLASS_TYPE_MAP;

    private AttributeTangoType(AttributeDataType attributeDataType, int typeCode, Class<?> clazz) {
        this.attributeDataType = attributeDataType;
        this.tangoIDLType = typeCode;
        this.type = clazz;
    }

    public int getTangoIDLType() {
        return this.tangoIDLType;
    }

    public static AttributeTangoType getTypeFromClass(Class<?> clazz) throws DevFailed {
        AttributeTangoType result = CLASS_TYPE_MAP.get(clazz);
        if (Enum.class.isAssignableFrom(clazz) && !DeviceState.class.isAssignableFrom(clazz)) {
            result = DEVENUM;
        } else if (result == null) {
            DevFailedUtils.throwDevFailed("TYPE_ERROR", clazz + " is not an attribute type");
        }
        return result;
    }

    public static AttributeTangoType getTypeFromTango(int tangoType) throws DevFailed {
        AttributeTangoType result = TANGO_TYPE_MAP.get(tangoType);
        if (result == null) {
            DevFailedUtils.throwDevFailed("TYPE_ERROR", tangoType + " is not an attribute type");
        }
        return result;
    }

    public static Object getDefaultValue(Class<?> clazz) throws DevFailed {
        return DEFAULT_VALUES.get(clazz);
    }

    public Class<?> getType() {
        return this.type;
    }

    public AttributeDataType getAttributeDataType() {
        return this.attributeDataType;
    }

    static {
        TANGO_TYPE_MAP = new HashMap<Integer, AttributeTangoType>();
        for (AttributeTangoType s : EnumSet.allOf(AttributeTangoType.class)) {
            TANGO_TYPE_MAP.put(s.getTangoIDLType(), s);
        }
        OBJECTS = new Class[]{Void.class, Boolean.class, Byte.class, Short.class, Integer.class, Float.class, Double.class, Long.class, DeviceState.class};
        ATTRIBUTE_CLASSES = new ArrayList();
        for (AttributeTangoType s : EnumSet.allOf(AttributeTangoType.class)) {
            ATTRIBUTE_CLASSES.add(s.getType());
        }
        ATTRIBUTE_CLASSES.addAll(Arrays.asList(OBJECTS));
        DEFAULT_VALUES = new HashMap();
        DEFAULT_VALUES.put(Boolean.TYPE, false);
        DEFAULT_VALUES.put(Boolean.class, false);
        DEFAULT_VALUES.put(boolean[].class, new boolean[]{false});
        DEFAULT_VALUES.put(Boolean[].class, new Boolean[]{false});
        DEFAULT_VALUES.put(boolean[][].class, new boolean[0]);
        DEFAULT_VALUES.put(Boolean[][].class, new Boolean[0]);
        DEFAULT_VALUES.put(Short.TYPE, (short)0);
        DEFAULT_VALUES.put(Short.class, (short)0);
        DEFAULT_VALUES.put(short[].class, new short[]{0});
        DEFAULT_VALUES.put(Short[].class, new Short[]{(short)0});
        DEFAULT_VALUES.put(short[][].class, new short[0]);
        DEFAULT_VALUES.put(Short[][].class, new Short[0]);
        DEFAULT_VALUES.put(Long.TYPE, 0L);
        DEFAULT_VALUES.put(Long.class, 0L);
        DEFAULT_VALUES.put(long[].class, new long[]{0L});
        DEFAULT_VALUES.put(Long[].class, new Long[]{0L});
        DEFAULT_VALUES.put(long[][].class, new long[0]);
        DEFAULT_VALUES.put(Long[][].class, new Long[0]);
        DEFAULT_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_VALUES.put(Float.class, Float.valueOf(0.0f));
        DEFAULT_VALUES.put(float[].class, new float[]{0.0f});
        DEFAULT_VALUES.put(Float[].class, new Float[]{Float.valueOf(0.0f)});
        DEFAULT_VALUES.put(float[][].class, new float[0]);
        DEFAULT_VALUES.put(Float[][].class, new Float[0]);
        DEFAULT_VALUES.put(Double.TYPE, 0.0);
        DEFAULT_VALUES.put(Double.class, 0.0);
        DEFAULT_VALUES.put(double[].class, new double[]{0.0});
        DEFAULT_VALUES.put(Double[].class, new Double[]{0.0});
        DEFAULT_VALUES.put(double[][].class, new double[0]);
        DEFAULT_VALUES.put(Double[][].class, new Double[0]);
        DEFAULT_VALUES.put(String.class, "Not initialised");
        DEFAULT_VALUES.put(String[].class, new String[]{"Not initialised"});
        DEFAULT_VALUES.put(String[][].class, new String[0]);
        DEFAULT_VALUES.put(Integer.TYPE, 0);
        DEFAULT_VALUES.put(Integer.class, 0);
        DEFAULT_VALUES.put(int[].class, new int[]{0});
        DEFAULT_VALUES.put(Integer[].class, new Integer[]{0});
        DEFAULT_VALUES.put(int[][].class, new int[0]);
        DEFAULT_VALUES.put(Integer[][].class, new Integer[0]);
        DEFAULT_VALUES.put(DeviceState.class, (Object)DeviceState.UNKNOWN);
        DEFAULT_VALUES.put(DeviceState[].class, new DeviceState[]{DeviceState.UNKNOWN});
        DEFAULT_VALUES.put(DeviceState[][].class, new DeviceState[0]);
        DEFAULT_VALUES.put(DevState.class, DevState.UNKNOWN);
        DEFAULT_VALUES.put(DevState[].class, new DevState[]{DevState.UNKNOWN});
        DEFAULT_VALUES.put(DevState[][].class, new DevState[0]);
        DEFAULT_VALUES.put(Byte.TYPE, (byte)0);
        DEFAULT_VALUES.put(Byte.class, (byte)0);
        DEFAULT_VALUES.put(byte[].class, new byte[]{0});
        DEFAULT_VALUES.put(Byte[].class, new Byte[]{(byte)0});
        DEFAULT_VALUES.put(byte[][].class, new byte[0]);
        DEFAULT_VALUES.put(Byte[][].class, new Byte[0]);
        DEFAULT_VALUES.put(DevEncoded.class, new DevEncoded("", new byte[0]));
        DEFAULT_VALUES.put(DevEncoded[].class, new DevEncoded[]{new DevEncoded("", new byte[0])});
        DEFAULT_VALUES.put(DevEncoded[][].class, new DevEncoded[]{new DevEncoded("", new byte[0])});
        CLASS_TYPE_MAP = new HashMap();
        CLASS_TYPE_MAP.put(Boolean.class, DEVBOOLEAN);
        CLASS_TYPE_MAP.put(Boolean.TYPE, DEVBOOLEAN);
        CLASS_TYPE_MAP.put(Boolean[].class, DEVBOOLEAN);
        CLASS_TYPE_MAP.put(boolean[].class, DEVBOOLEAN);
        CLASS_TYPE_MAP.put(Boolean[][].class, DEVBOOLEAN);
        CLASS_TYPE_MAP.put(boolean[][].class, DEVBOOLEAN);
        CLASS_TYPE_MAP.put(Short.class, DEVSHORT);
        CLASS_TYPE_MAP.put(Short.TYPE, DEVSHORT);
        CLASS_TYPE_MAP.put(Short[].class, DEVSHORT);
        CLASS_TYPE_MAP.put(short[].class, DEVSHORT);
        CLASS_TYPE_MAP.put(Short[][].class, DEVSHORT);
        CLASS_TYPE_MAP.put(short[][].class, DEVSHORT);
        CLASS_TYPE_MAP.put(Long.class, DEVLONG64);
        CLASS_TYPE_MAP.put(Long.TYPE, DEVLONG64);
        CLASS_TYPE_MAP.put(Long[].class, DEVLONG64);
        CLASS_TYPE_MAP.put(long[].class, DEVLONG64);
        CLASS_TYPE_MAP.put(Long[][].class, DEVLONG64);
        CLASS_TYPE_MAP.put(long[][].class, DEVLONG64);
        CLASS_TYPE_MAP.put(Float.class, DEVFLOAT);
        CLASS_TYPE_MAP.put(Float.TYPE, DEVFLOAT);
        CLASS_TYPE_MAP.put(Float[].class, DEVFLOAT);
        CLASS_TYPE_MAP.put(float[].class, DEVFLOAT);
        CLASS_TYPE_MAP.put(Float[][].class, DEVFLOAT);
        CLASS_TYPE_MAP.put(float[][].class, DEVFLOAT);
        CLASS_TYPE_MAP.put(Double.class, DEVDOUBLE);
        CLASS_TYPE_MAP.put(Double.TYPE, DEVDOUBLE);
        CLASS_TYPE_MAP.put(Double[].class, DEVDOUBLE);
        CLASS_TYPE_MAP.put(double[].class, DEVDOUBLE);
        CLASS_TYPE_MAP.put(Double[][].class, DEVDOUBLE);
        CLASS_TYPE_MAP.put(double[][].class, DEVDOUBLE);
        CLASS_TYPE_MAP.put(String.class, DEVSTRING);
        CLASS_TYPE_MAP.put(String[].class, DEVSTRING);
        CLASS_TYPE_MAP.put(String[][].class, DEVSTRING);
        CLASS_TYPE_MAP.put(Integer.class, DEVLONG);
        CLASS_TYPE_MAP.put(Integer.TYPE, DEVLONG);
        CLASS_TYPE_MAP.put(Integer[].class, DEVLONG);
        CLASS_TYPE_MAP.put(int[].class, DEVLONG);
        CLASS_TYPE_MAP.put(Integer[][].class, DEVLONG);
        CLASS_TYPE_MAP.put(int[][].class, DEVLONG);
        CLASS_TYPE_MAP.put(DevState.class, DEVSTATE);
        CLASS_TYPE_MAP.put(DevState[].class, DEVSTATE);
        CLASS_TYPE_MAP.put(DevState[][].class, DEVSTATE);
        CLASS_TYPE_MAP.put(DeviceState.class, DEVSTATE);
        CLASS_TYPE_MAP.put(DeviceState[].class, DEVSTATE);
        CLASS_TYPE_MAP.put(DeviceState[][].class, DEVSTATE);
        CLASS_TYPE_MAP.put(Byte.class, DEVUCHAR);
        CLASS_TYPE_MAP.put(Byte.TYPE, DEVUCHAR);
        CLASS_TYPE_MAP.put(Byte[].class, DEVUCHAR);
        CLASS_TYPE_MAP.put(byte[].class, DEVUCHAR);
        CLASS_TYPE_MAP.put(Byte[][].class, DEVUCHAR);
        CLASS_TYPE_MAP.put(byte[][].class, DEVUCHAR);
        CLASS_TYPE_MAP.put(DevEncoded.class, DEVENCODED);
        CLASS_TYPE_MAP.put(DevEncoded[].class, DEVENCODED);
        CLASS_TYPE_MAP.put(DevEncoded[][].class, DEVENCODED);
    }
}

