/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import org.jmock.expectation.AbstractExpectation;
import org.jmock.expectation.AssertMo;

public class ExpectationDoubleValue
extends AbstractExpectation {
    private Double expectedValue = null;
    private double expectedError = 0.0;
    private boolean expectNothing = false;
    private Double actualValue = null;

    public ExpectationDoubleValue(String string) {
        super(string);
        this.clearActual();
    }

    public void clearActual() {
        this.actualValue = null;
    }

    public void setActual(double d) {
        this.actualValue = new Double(d);
        if (this.shouldCheckImmediately()) {
            this.verify();
        }
    }

    public void setExpected(double d, double d2) {
        this.expectedValue = new Double(d);
        this.expectedError = Math.abs(d2);
        this.setHasExpectations();
    }

    public void setExpectNothing() {
        this.expectNothing = true;
        this.clearActual();
        this.setHasExpectations();
    }

    public void verify() {
        if (this.expectNothing) {
            AssertMo.assertNull((String)(this.myName + " expected no value"), (Object)this.actualValue);
        } else if (this.expectedValue != null) {
            AssertMo.assertNotNull((String)(this.myName + " expected a value"), (Object)this.actualValue);
            double d = Math.abs(this.actualValue - this.expectedValue);
            AssertMo.assertTrue((String)(this.myName + " expected a value within " + this.expectedError + " of " + this.expectedValue + ", was " + this.actualValue), (d <= this.expectedError ? 1 : 0) != 0);
        }
    }
}

