/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CodeSet;
import org.jacorb.orb.IBufferManager;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.etf.StreamConnectionBase;
import org.jacorb.orb.giop.ConnectionListener;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.giop.StatisticsProviderAdapter;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.Time;
import org.jacorb.util.TimerQueue;
import org.jacorb.util.TimerQueueAction;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.TimeBase.UtcT;
import org.slf4j.Logger;

public abstract class GIOPConnection
extends OutputStream {
    protected final Profile profile;
    protected Connection transport = null;
    private Long write_monitor_timeout = null;
    private TimerQueue timer_queue = null;
    private RequestListener request_listener = null;
    private ReplyListener reply_listener = null;
    protected ConnectionListener connection_listener = null;
    protected Object connect_sync = new Object();
    private ReentrantLock writeLock = new ReentrantLock();
    protected Logger logger;
    private CodeSet tcs;
    private CodeSet tcsw;
    private boolean tcs_negotiated = false;
    protected final Map<Integer, ByteArrayOutputStream> fragments = new HashMap<Integer, ByteArrayOutputStream>();
    private IBufferManager buf_mg;
    private boolean dump_incoming = false;
    private long connectTimeout = 0L;
    private final BufferHolder msg_header = new BufferHolder(new byte[12]);
    private final BufferHolder inbuf = new BufferHolder();
    private static int cubby_count = 0;
    private Object[] cubbyholes = null;
    private int pending_messages = 0;
    private int pending_write = 0;
    protected boolean discard_messages = false;
    protected Object pendingUndecidedSync = new Object();
    protected boolean do_close = false;
    protected StatisticsProvider statistics_provider = null;
    protected StatisticsProviderAdapter statistics_provider_adapter = null;
    protected ORB orb;
    private UtcT sendDeadline = null;

    public GIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener, StatisticsProvider statistics_provider) {
        this.profile = profile;
        this.transport = transport;
        this.request_listener = request_listener;
        this.reply_listener = reply_listener;
        this.statistics_provider = statistics_provider;
        if (statistics_provider != null) {
            this.statistics_provider_adapter = new StatisticsProviderAdapter(statistics_provider);
        }
        this.cubbyholes = new Object[cubby_count];
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.orb = configuration.getORB();
        this.tcs = this.orb.getTCSDefault();
        this.tcsw = this.orb.getTCSWDefault();
        this.buf_mg = this.orb.getBufferManager();
        this.logger = configuration.getLogger("org.jacorb.giop.conn");
        this.dump_incoming = configuration.getAttributeAsBoolean("jacorb.debug.dump_incoming_messages", false);
        this.connectTimeout = configuration.getAttributeAsInteger("jacorb.connection.client.connect_timeout", 90000);
        List<String> statsProviderClassNames = configuration.getAttributeList("jacorb.connection.statistics_providers");
        for (String className : statsProviderClassNames) {
            try {
                Class<?> iclass = ObjectUtil.classForName(className);
                this.statistics_provider_adapter = new StatisticsProviderAdapter((StatisticsProvider)iclass.newInstance(), this.statistics_provider_adapter);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error("Unable to create class from property >jacorb.connection.statistics_provider_class<: " + e.toString());
            }
        }
    }

    protected void init_write_monitor(int timeout) {
        if (timeout <= 0) {
            return;
        }
        this.timer_queue = this.orb.getTimerQueue();
        this.write_monitor_timeout = new Long(timeout);
    }

    public final void setCodeSets(CodeSet TCS, CodeSet TCSW) {
        this.tcs = TCS;
        this.tcsw = TCSW;
    }

    public final void setCodeSets(int TCS, int TCSW) {
        this.tcs = CodeSet.getCodeSet(TCS);
        this.tcsw = CodeSet.getCodeSet(TCSW);
    }

    public final CodeSet getTCS() {
        return this.tcs;
    }

    public final CodeSet getTCSW() {
        return this.tcsw;
    }

    public final void markTCSNegotiated() {
        this.tcs_negotiated = true;
    }

    public final boolean isTCSNegotiated() {
        return this.tcs_negotiated;
    }

    protected final synchronized RequestListener getRequestListener() {
        return this.request_listener;
    }

    public final synchronized void setRequestListener(RequestListener listener) {
        this.request_listener = listener;
    }

    private final synchronized ReplyListener getReplyListener() {
        return this.reply_listener;
    }

    public final synchronized void setReplyListener(ReplyListener listener) {
        this.reply_listener = listener;
    }

    public final void setConnectionListener(ConnectionListener connection_listener) {
        this.connection_listener = connection_listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getTransport() {
        Object object = this.connect_sync;
        synchronized (object) {
            return this.transport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilConnected() {
        Object object = this.connect_sync;
        synchronized (object) {
            while (!this.transport.is_connected() && !this.do_close) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.toString() + ": will wait until connected");
                }
                try {
                    this.connect_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return !this.do_close;
        }
    }

    protected abstract void readTimedOut();

    protected abstract void streamClosed();

    private byte[] getMessage() {
        if (!this.waitUntilConnected()) {
            return null;
        }
        try {
            this.transport.read(this.msg_header, 0, 12, 12, 0L);
        }
        catch (TRANSIENT ex) {
            return null;
        }
        catch (COMM_FAILURE ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.toString() + ": getMessage() -- COMM_FAILURE");
            }
            this.streamClosed();
            return null;
        }
        catch (TIMEOUT ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.toString() + ": getMessage() -- TIMEOUT");
            }
            this.readTimedOut();
            return null;
        }
        byte[] header = this.msg_header.value;
        if (Messages.matchGIOPMagic(header)) {
            int msg_size = Messages.getMsgSize(header);
            if (msg_size < 0) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Negative GIOP message size (" + msg_size + ") in " + this.toString());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("GIOPConnection.getMessage() with header: \n" + new String(header) + "\nsize : " + 12 + ", in " + this.toString());
                }
                return null;
            }
            this.inbuf.value = this.buf_mg.getBuffer(msg_size + 12);
            System.arraycopy(header, 0, this.inbuf.value, 0, 12);
            try {
                this.transport.read(this.inbuf, 12, msg_size, msg_size, 0L);
            }
            catch (COMM_FAILURE ex) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Failed to read GIOP message in " + this.toString(), ex);
                }
                this.streamClosed();
                return null;
            }
            if (this.dump_incoming && this.logger.isInfoEnabled()) {
                this.logger.info(this.toString() + " BufferDump:\n" + ObjectUtil.bufToString(this.inbuf.value, 0, msg_size + 12));
            }
            if (this.getStatisticsProviderAdapter() != null) {
                this.getStatisticsProviderAdapter().messageReceived(msg_size + 12);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("read GIOP message of size {} from {}", (Object)(msg_size + 12), (Object)this.toString());
            }
            return this.inbuf.value;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + " getMessage(), invalid header read: " + ObjectUtil.bufToString(this.msg_header.value, 0, 4));
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Failed to read GIOP message in " + this.toString() + ", incorrect magic number --> connection closed");
        }
        this.streamClosed();
        return null;
    }

    public final void receiveMessages() throws IOException {
        while (!this.do_close) {
            try {
                this.receiveMessagesLoop();
            }
            catch (Exception e) {
                this.logger.error("Unexpected error during receiveMessages. Lost a message!", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessagesLoop() throws IOException {
        try {
            byte[] message = this.getMessage();
            if (message == null) {
                return;
            }
            Object object = this.pendingUndecidedSync;
            synchronized (object) {
                if (this.discard_messages) {
                    this.buf_mg.returnBuffer(message);
                    return;
                }
                if (Messages.getGIOPMajor(message) != 1) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Invalid GIOP major version encountered: " + Messages.getGIOPMajor(message) + ", in " + this.toString());
                    }
                    this.buf_mg.returnBuffer(message);
                    return;
                }
                int msg_type = Messages.getMsgType(message);
                if (msg_type == 7) {
                    if (Messages.getGIOPMinor(message) == 0) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.0 message of type Fragment in " + this.toString());
                        }
                        MessageOutputStream out = new MessageOutputStream(this.orb);
                        try {
                            out.writeGIOPMsgHeader(6, 0);
                            out.insertMsgSize();
                            this.sendMessage(out);
                            this.buf_mg.returnBuffer(message);
                        }
                        finally {
                            out.close();
                        }
                        return;
                    }
                    if (Messages.getGIOPMinor(message) == 1) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.1 Fragment message in " + this.toString());
                        }
                        this.buf_mg.returnBuffer(message);
                        return;
                    }
                    int request_id = Messages.getRequestId(message);
                    if (!this.fragments.containsKey(request_id)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("No previous Fragment to this one in " + this.toString());
                        }
                        this.buf_mg.returnBuffer(message);
                        return;
                    }
                    ByteArrayOutputStream b_out = this.fragments.get(request_id);
                    b_out.write(message, 16, Messages.getMsgSize(message) - 4);
                    if (Messages.moreFragmentsFollow(message)) {
                        this.buf_mg.returnBuffer(message);
                        return;
                    }
                    this.buf_mg.returnBuffer(message);
                    message = b_out.toByteArray();
                    msg_type = Messages.getMsgType(message);
                    this.fragments.remove(request_id);
                } else if (Messages.moreFragmentsFollow(message)) {
                    if (Messages.getGIOPMinor(message) == 0) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.0 message with the \"more fragments follow\"bits set in " + this.toString());
                        }
                        MessageOutputStream out = new MessageOutputStream(this.orb);
                        out.writeGIOPMsgHeader(6, 0);
                        out.insertMsgSize();
                        this.sendMessage(out);
                        this.buf_mg.returnBuffer(message);
                        return;
                    }
                    if (Messages.getGIOPMinor(message) == 1) {
                        if (msg_type != 0 && msg_type != 1) {
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn("Received a GIOP 1.1 message of type " + msg_type + " with the " + "" + "\"more fragments follow\" bits set" + " in " + this.toString());
                            }
                            MessageOutputStream out = new MessageOutputStream(this.orb);
                            out.writeGIOPMsgHeader(6, 1);
                            out.insertMsgSize();
                            this.sendMessage(out);
                            this.buf_mg.returnBuffer(message);
                            return;
                        }
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a fragmented GIOP 1.1 message in " + this.toString());
                        }
                        int giop_minor = Messages.getGIOPMinor(message);
                        ReplyOutputStream out = new ReplyOutputStream(this.orb, Messages.getRequestId(message), ReplyStatusType_1_2.SYSTEM_EXCEPTION, giop_minor, false, this.logger);
                        try {
                            SystemExceptionHelper.write(out, new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO));
                            this.sendMessage(out);
                            this.buf_mg.returnBuffer(message);
                            return;
                        }
                        finally {
                            out.close();
                        }
                    }
                    if (msg_type == 2 || msg_type == 5 || msg_type == 2) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP message of type " + msg_type + " with the \"more fragments follow\" bits set, " + "but this message type isn't allowed to be " + "fragmented, in " + this.toString());
                        }
                        MessageOutputStream out = new MessageOutputStream(this.orb);
                        out.writeGIOPMsgHeader(6, 1);
                        out.insertMsgSize();
                        this.sendMessage(out);
                        this.buf_mg.returnBuffer(message);
                        return;
                    }
                    Integer request_id = new Integer(Messages.getRequestId(message));
                    if (this.fragments.containsKey(request_id)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received a message of type " + msg_type + " with the more fragments follow bit set," + " but there is already an fragmented," + " incomplete message with the same request id (" + request_id + ", in " + this.toString());
                        }
                        this.buf_mg.returnBuffer(message);
                        return;
                    }
                    ByteArrayOutputStream b_out = new ByteArrayOutputStream();
                    this.fragments.put(request_id, b_out);
                    b_out.write(message, 0, 12 + Messages.getMsgSize(message));
                    this.buf_mg.returnBuffer(message);
                    return;
                }
                switch (msg_type) {
                    case 0: {
                        this.getRequestListener().requestReceived(message, this);
                        break;
                    }
                    case 1: {
                        this.getReplyListener().replyReceived(message, this);
                        break;
                    }
                    case 2: {
                        this.getRequestListener().cancelRequestReceived(message, this);
                        break;
                    }
                    case 3: {
                        this.getRequestListener().locateRequestReceived(message, this);
                        break;
                    }
                    case 4: {
                        this.getReplyListener().locateReplyReceived(message, this);
                        break;
                    }
                    case 5: {
                        this.getReplyListener().closeConnectionReceived(message, this);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received message with unknown message type " + msg_type + ", in " + this.toString());
                        }
                        this.buf_mg.returnBuffer(message);
                    }
                }
            }
        }
        catch (NO_MEMORY e) {
            this.logger.error("Caught NO_MEMORY error", e);
            this.streamClosed();
        }
        catch (OutOfMemoryError e) {
            this.logger.error("Caught OutOfMemory error", e);
            this.streamClosed();
        }
    }

    protected final boolean getWriteLock(long timeout) {
        long endTime;
        long l = endTime = timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
        while (endTime > System.currentTimeMillis()) {
            long remainingTime = endTime - System.currentTimeMillis();
            try {
                return this.writeLock.tryLock(remainingTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
            }
        }
        return false;
    }

    protected final void releaseWriteLock() {
        try {
            this.writeLock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    private final synchronized void incPendingWrite() {
        ++this.pending_write;
    }

    private final synchronized void decPendingWrite() {
        --this.pending_write;
    }

    public final synchronized void incPendingMessages() {
        ++this.pending_messages;
    }

    public final synchronized void decPendingMessages() {
        --this.pending_messages;
    }

    public final synchronized boolean hasPendingMessages() {
        return this.pending_messages != 0 || this.pending_write != 0;
    }

    @Override
    public final void write(byte[] fragment, int start, int size) {
        ConnectionReset write_monitor = null;
        if (this.write_monitor_timeout != null) {
            write_monitor = new ConnectionReset((long)this.write_monitor_timeout);
        }
        if (this.timer_queue != null) {
            this.timer_queue.add(write_monitor);
        }
        if (this.sendDeadline != null) {
            long time = Time.millisTo(this.sendDeadline);
            time = time == 0L ? -1L : time;
            this.transport.write(false, false, fragment, start, size, time);
        } else {
            this.transport.write(false, false, fragment, start, size, 0L);
        }
        if (this.timer_queue != null) {
            this.timer_queue.remove(write_monitor);
        }
        if (this.getStatisticsProviderAdapter() != null) {
            this.getStatisticsProviderAdapter().messageChunkSent(size);
        }
    }

    @Override
    public final void write(int value) throws IOException {
        throw new NO_IMPLEMENT();
    }

    @Override
    public final void write(byte[] value) throws IOException {
        throw new NO_IMPLEMENT();
    }

    @Override
    public final void flush() throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void sendRequest(MessageOutputStream out, boolean expect_reply) throws IOException {
        if (expect_reply) {
            this.incPendingMessages();
        }
        this.sendMessage(out, out instanceof RequestOutputStream ? ((RequestOutputStream)out).getReplyEndTime() : null);
    }

    public final void sendReply(MessageOutputStream out) throws IOException {
        this.decPendingMessages();
        this.sendMessage(out);
    }

    private final void sendMessage(MessageOutputStream out) throws IOException {
        this.sendMessage(out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMessage(MessageOutputStream out, UtcT sendDeadline) throws IOException {
        try {
            try {
                long timeout;
                this.incPendingWrite();
                long l = timeout = sendDeadline == null ? 0L : Time.millisTo(sendDeadline);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("GIOPConnection.sendMessage timeout (millis): " + timeout);
                }
                if (!this.getWriteLock(timeout)) {
                    throw new TIMEOUT("Failed to acquire transport lock in " + timeout + " ms");
                }
                this.sendDeadline = sendDeadline;
                if (!this.transport.is_connected()) {
                    this.tcs_negotiated = false;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.toString() + ": sendMessage() - opening transport " + this.transport);
                    }
                    Object object = this.connect_sync;
                    synchronized (object) {
                        try {
                            long myConnectTimeout = timeout != 0L && timeout < this.connectTimeout ? timeout : this.connectTimeout;
                            this.transport.connect(this.profile, myConnectTimeout);
                            this.connect_sync.notifyAll();
                        }
                        catch (RuntimeException ex) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(this.toString() + ": sendMessage() -- failed to open transport");
                            }
                            throw ex;
                        }
                    }
                }
                out.write_to(this);
                this.transport.flush();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("wrote GIOP message of size {} to {}", (Object)out.size(), (Object)this.toString());
                }
                if (this.getStatisticsProviderAdapter() != null) {
                    this.getStatisticsProviderAdapter().flushed();
                }
            }
            finally {
                sendDeadline = null;
                this.decPendingWrite();
                this.releaseWriteLock();
            }
        }
        catch (COMM_FAILURE e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Failed to write GIOP message due to COMM_FAILURE, in " + this.toString(), e);
            }
            if (!this.do_close) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Underlying transport connection closed due to errors during sendMessage(), in " + this.toString());
                }
                this.streamClosed();
            }
            throw e;
        }
    }

    public final boolean isSSL() {
        if (this.transport instanceof StreamConnectionBase) {
            return ((StreamConnectionBase)this.transport).isSSL();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": close()");
        }
        Object object = this.connect_sync;
        synchronized (object) {
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            this.do_close = true;
            this.transport.close();
            this.connect_sync.notifyAll();
        }
    }

    protected final StatisticsProviderAdapter getStatisticsProviderAdapter() {
        return this.statistics_provider_adapter;
    }

    public final StatisticsProvider getStatisticsProvider() {
        return this.statistics_provider;
    }

    public StatisticsProvider getStatisticsProvider(int no) {
        if (this.statistics_provider_adapter == null) {
            return null;
        }
        return this.statistics_provider_adapter.find(no);
    }

    public static int allocate_cubby_id() {
        return cubby_count++;
    }

    public Object get_cubby(int id) {
        if (id < 0 || id >= cubby_count) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Get bad cubby id " + id + " (max=" + cubby_count + "), in " + this.toString());
            }
            return null;
        }
        return this.cubbyholes[id];
    }

    public void set_cubby(int id, Object obj) {
        if (id < 0 || id >= cubby_count) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Set bad cubby id " + id + " (max=" + cubby_count + "), in " + this.toString());
            }
            return;
        }
        this.cubbyholes[id] = obj;
    }

    Profile getProfile() {
        return this.profile;
    }

    public class ConnectionReset
    extends TimerQueueAction {
        long relative;

        public ConnectionReset(long ms) {
            super(ms);
            this.relative = ms;
        }

        @Override
        public void expire() {
            if (GIOPConnection.this.logger.isErrorEnabled()) {
                GIOPConnection.this.logger.error("Write to connection exceeded time limit. Transport forced closed.");
            }
            GIOPConnection.this.do_close = true;
            GIOPConnection.this.transport.close();
        }
    }
}

