/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.container.CORBAObjectComponentAdapter;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.ConsumerAdminImplMBean;
import org.jacorb.notification.servant.ECProxyPullSupplierImpl;
import org.jacorb.notification.servant.ECProxyPushSupplierImpl;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.servant.IEventChannel;
import org.jacorb.notification.servant.ProxyPullSupplierImpl;
import org.jacorb.notification.servant.ProxyPushSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPullSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPushSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPullSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosEventChannelAdmin.ProxyPullSupplier;
import org.omg.CosEventChannelAdmin.ProxyPullSupplierHelper;
import org.omg.CosEventChannelAdmin.ProxyPushSupplier;
import org.omg.CosEventChannelAdmin.ProxyPushSupplierHelper;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminOperations;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.ProxySupplierHelper;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.CachingComponentAdapter;

public class ConsumerAdminImpl
extends AbstractAdmin
implements ConsumerAdminOperations,
Disposable,
ProxyEventListener,
ConsumerAdminImplMBean {
    private static final FilterstageWithMessageConsumerComparator FILTERSTAGE_COMPARATOR = new FilterstageWithMessageConsumerComparator();
    private final FilterStageListManager listManager_ = new FilterStageListManager(){

        @Override
        protected void fetchListData(FilterStageListManager.FilterStageList listProxy) {
            this.addAllValues(listProxy, ConsumerAdminImpl.this.pullServants_);
            this.addAllValues(listProxy, ConsumerAdminImpl.this.pushServants_);
        }

        @Override
        protected void doSortCheckedList(List list) {
            Collections.sort(list, FILTERSTAGE_COMPARATOR);
        }

        private void addAllValues(FilterStageListManager.FilterStageList listProxy, Map map) {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                listProxy.add((FilterStage)i.next().getValue());
            }
        }
    };
    private MappingFilter priorityFilter_;
    private MappingFilter lifetimeFilter_ = MappingFilterHelper.unchecked_narrow(this.getORB().string_to_object(this.getORB().object_to_string(null)));

    public ConsumerAdminImpl(IEventChannel channelServant, ORB orb, POA poa, Configuration config, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(channelServant, orb, poa, config, messageFactory, offerManager, subscriptionManager);
        this.priorityFilter_ = MappingFilterHelper.unchecked_narrow(this.getORB().string_to_object(this.getORB().object_to_string(null)));
        this.addProxyEventListener(this);
        ConsumerAdmin _thisRef = ConsumerAdminHelper.narrow(this.activate());
        this.container_.registerComponent(new CachingComponentAdapter(new CORBAObjectComponentAdapter(ConsumerAdmin.class, _thisRef)));
        this.registerDisposable(new Disposable(){

            @Override
            public void dispose() {
                ConsumerAdminImpl.this.container_.unregisterComponent(ConsumerAdmin.class);
            }
        });
    }

    @Override
    public Servant newServant() {
        return new ConsumerAdminPOATie(this);
    }

    @Override
    public void subscription_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        this.subscriptionManager_.subscription_change(added, removed);
    }

    @Override
    public ProxySupplier get_proxy_supplier(int key) throws ProxyNotFound {
        return ProxySupplierHelper.narrow(this.getProxy(key).activate());
    }

    @Override
    public void lifetime_filter(MappingFilter lifetimeFilter) {
        this.lifetimeFilter_ = lifetimeFilter;
    }

    @Override
    public MappingFilter lifetime_filter() {
        return this.lifetimeFilter_;
    }

    @Override
    public MappingFilter priority_filter() {
        return this.priorityFilter_;
    }

    @Override
    public void priority_filter(MappingFilter priorityFilter) {
        this.priorityFilter_ = priorityFilter;
    }

    @Override
    public ProxySupplier obtain_notification_pull_supplier(ClientType clientType, IntHolder intHolder) throws AdminLimitExceeded {
        this.fireCreateProxyRequestEvent();
        try {
            AbstractProxy _servant = this.obtain_notification_pull_supplier_servant(clientType);
            intHolder.value = _servant.getID();
            return ProxySupplierHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.error("obtain_notification_pull_supplier: unexpected error", e);
            throw new UNKNOWN(e.toString());
        }
    }

    protected void configureMappingFilters(AbstractProxySupplier servant) {
        if (this.lifetimeFilter_ != null) {
            servant.lifetime_filter(this.lifetimeFilter_);
        }
        if (this.priorityFilter_ != null) {
            servant.priority_filter(this.priorityFilter_);
        }
    }

    private AbstractProxy obtain_notification_pull_supplier_servant(ClientType clientType) throws UnsupportedQoS {
        AbstractProxySupplier _servant = this.newProxyPullSupplier(clientType);
        this.configureMappingFilters(_servant);
        this.configureQoS(_servant);
        this.configureInterFilterGroupOperator(_servant);
        this.addProxyToMap(_servant, this.pullServants_, this.modifyProxiesLock_);
        return _servant;
    }

    @Override
    public int[] pull_suppliers() {
        return this.get_all_notify_proxies(this.pullServants_, this.modifyProxiesLock_);
    }

    @Override
    public int[] push_suppliers() {
        return this.get_all_notify_proxies(this.pushServants_, this.modifyProxiesLock_);
    }

    @Override
    public ProxySupplier obtain_notification_push_supplier(ClientType clientType, IntHolder intHolder) throws AdminLimitExceeded {
        this.fireCreateProxyRequestEvent();
        try {
            AbstractProxy _servant = this.obtain_notification_push_supplier_servant(clientType);
            intHolder.value = _servant.getID();
            return ProxySupplierHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.error("obtain_notification_push_supplier: unexpected error", e);
            throw new UNKNOWN();
        }
    }

    private AbstractProxy obtain_notification_push_supplier_servant(ClientType clientType) throws UnsupportedQoS {
        AbstractProxySupplier _servant = this.newProxyPushSupplier(clientType);
        this.configureMappingFilters(_servant);
        this.configureQoS(_servant);
        this.configureInterFilterGroupOperator(_servant);
        this.addProxyToMap(_servant, this.pushServants_, this.modifyProxiesLock_);
        return _servant;
    }

    @Override
    public ProxyPullSupplier obtain_pull_supplier() {
        try {
            MutablePicoContainer _container = this.newContainerForEventStyleProxy();
            _container.registerComponentImplementation(AbstractProxy.class, ECProxyPullSupplierImpl.class);
            AbstractProxy _servant = (AbstractProxy)_container.getComponentInstanceOfType(AbstractProxy.class);
            this.configureQoS(_servant);
            this.addProxyToMap(_servant, this.pullServants_, this.modifyProxiesLock_);
            return ProxyPullSupplierHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.error("obtain_pull_supplier: exception", e);
            throw new UNKNOWN();
        }
    }

    @Override
    public ProxyPushSupplier obtain_push_supplier() {
        try {
            MutablePicoContainer _container = this.newContainerForEventStyleProxy();
            _container.registerComponentImplementation(AbstractProxy.class, ECProxyPushSupplierImpl.class);
            AbstractProxy _servant = (AbstractProxy)_container.getComponentInstanceOfType(AbstractProxy.class);
            this.configureQoS(_servant);
            this.addProxyToMap(_servant, this.pushServants_, this.modifyProxiesLock_);
            return ProxyPushSupplierHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.error("obtain_push_supplier: exception", e);
            throw new UNKNOWN(e.toString());
        }
    }

    @Override
    public List getSubsequentFilterStages() {
        return this.listManager_.getList();
    }

    @Override
    public MessageConsumer getMessageConsumer() {
        return null;
    }

    @Override
    public boolean hasMessageConsumer() {
        return false;
    }

    @Override
    public void actionProxyCreationRequest(ProxyEvent event) {
    }

    @Override
    public void actionProxyDisposed(ProxyEvent event) {
        this.listManager_.actionSourceModified();
        this.listManager_.refresh();
    }

    @Override
    public void actionProxyCreated(ProxyEvent event) {
        this.listManager_.actionSourceModified();
    }

    AbstractProxySupplier newProxyPullSupplier(ClientType clientType) {
        Class _proxyClass;
        MutablePicoContainer _containerForProxy = this.newContainerForNotifyStyleProxy();
        switch (clientType.value()) {
            case 0: {
                _proxyClass = ProxyPullSupplierImpl.class;
                break;
            }
            case 1: {
                _proxyClass = StructuredProxyPullSupplierImpl.class;
                break;
            }
            case 2: {
                _proxyClass = SequenceProxyPullSupplierImpl.class;
                break;
            }
            default: {
                throw new BAD_PARAM();
            }
        }
        _containerForProxy.registerComponentImplementation(AbstractProxySupplier.class, _proxyClass);
        AbstractProxySupplier _servant = (AbstractProxySupplier)_containerForProxy.getComponentInstanceOfType(AbstractProxySupplier.class);
        return _servant;
    }

    AbstractProxySupplier newProxyPushSupplier(ClientType clientType) {
        Class _proxyClass;
        switch (clientType.value()) {
            case 0: {
                _proxyClass = ProxyPushSupplierImpl.class;
                break;
            }
            case 1: {
                _proxyClass = StructuredProxyPushSupplierImpl.class;
                break;
            }
            case 2: {
                _proxyClass = SequenceProxyPushSupplierImpl.class;
                break;
            }
            default: {
                throw new BAD_PARAM("The ClientType: " + clientType.value() + " is unknown");
            }
        }
        MutablePicoContainer _containerForProxy = this.newContainerForNotifyStyleProxy();
        _containerForProxy.registerComponentImplementation(AbstractProxySupplier.class, _proxyClass);
        AbstractProxySupplier _servant = (AbstractProxySupplier)_containerForProxy.getComponentInstanceOfType(AbstractProxySupplier.class);
        return _servant;
    }

    @Override
    public String getMBeanType() {
        return "ConsumerAdmin";
    }

    private static final class FilterstageWithMessageConsumerComparator
    implements Comparator {
        private FilterstageWithMessageConsumerComparator() {
        }

        public int compare(Object l, Object r) {
            FilterStage left = (FilterStage)l;
            FilterStage right = (FilterStage)r;
            return left.getMessageConsumer().compareTo(right.getMessageConsumer());
        }
    }
}

