/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.ParseException;
import org.jacorb.notification.filter.PropertyDoesNotExistException;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.ETCLComponentName;
import org.jacorb.notification.filter.etcl.TCLCleanUp;
import org.jacorb.notification.filter.etcl.TCLParser;
import org.jacorb.notification.filter.etcl.VisitorException;
import org.jacorb.notification.interfaces.Message;

public class PropertyShorthandNode
extends AbstractTCLNode {
    private final String value_;
    private final ETCLComponentName shorthandVariableHeader_;
    private final ETCLComponentName shorthandFilterableData_;
    private final ETCLComponentName shorthandDefault_;
    private final ETCLComponentName shorthandDefaultAny_;

    public PropertyShorthandNode(String value) {
        try {
            this.value_ = value;
            this.shorthandVariableHeader_ = (ETCLComponentName)TCLParser.parse("$.header.variable_header(" + value + ")");
            TCLCleanUp etclCleanup = new TCLCleanUp();
            this.shorthandVariableHeader_.acceptInOrder(etclCleanup);
            this.shorthandFilterableData_ = (ETCLComponentName)TCLParser.parse("$.filterable_data(" + value + ")");
            this.shorthandFilterableData_.acceptInOrder(etclCleanup);
            this.shorthandDefault_ = (ETCLComponentName)TCLParser.parse("$." + value);
            this.shorthandDefault_.acceptInOrder(etclCleanup);
            this.shorthandDefaultAny_ = (ETCLComponentName)TCLParser.parse("$(" + value + ")");
            this.shorthandDefaultAny_.acceptInOrder(etclCleanup);
        }
        catch (ParseException e) {
            throw new RuntimeException();
        }
        catch (VisitorException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext context) throws PropertyDoesNotExistException {
        Message _event = context.getCurrentMessage();
        EvaluationResult _res = null;
        try {
            _res = _event.extractVariableHeader(context, this.shorthandVariableHeader_, this.value_);
        }
        catch (EvaluationException e) {
            // empty catch block
        }
        if (_res == null) {
            try {
                _res = _event.extractFilterableData(context, this.shorthandFilterableData_, this.value_);
            }
            catch (EvaluationException e) {
                // empty catch block
            }
            if (_res == null) {
                _res = this.extractDefaultValue(context);
            }
            if (_res == null) {
                _res = this.extractDefaultAnyValue(context);
            }
            if (_res == null) {
                throw new PropertyDoesNotExistException(this.value_);
            }
        }
        return _res;
    }

    public EvaluationResult extractDefaultValue(EvaluationContext context) {
        try {
            return context.getCurrentMessage().extractValue(context, this.shorthandDefault_);
        }
        catch (Exception e) {
            return null;
        }
    }

    public EvaluationResult extractDefaultAnyValue(EvaluationContext context) {
        try {
            return context.getCurrentMessage().extractValue(context, this.shorthandDefaultAny_);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return "PropertyShorthandNode: " + this.value_;
    }

    @Override
    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        if (this.getFirstChild() != null) {
            ((AbstractTCLNode)this.getFirstChild()).acceptPostOrder(visitor);
        }
    }

    @Override
    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        ((AbstractTCLNode)this.getFirstChild()).acceptPreOrder(visitor);
    }

    @Override
    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        ((AbstractTCLNode)this.getFirstChild()).acceptInOrder(visitor);
    }
}

