/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Date;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.filter.AbstractFilter;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.FilterConstraint;
import org.jacorb.notification.interfaces.EvaluationContextFactory;
import org.jacorb.notification.interfaces.Message;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.PortableServer.POA;

public class BSHFilter
extends AbstractFilter {
    public static final String CONSTRAINT_GRAMMAR = "BSH";

    public BSHFilter(Configuration config, EvaluationContextFactory evaluationContextFactory, MessageFactory messageFactory, POA poa) throws ConfigurationException {
        super(config, evaluationContextFactory, messageFactory, poa);
    }

    @Override
    public String constraint_grammar() {
        return CONSTRAINT_GRAMMAR;
    }

    @Override
    public FilterConstraint newFilterConstraint(ConstraintExp constraintExp) {
        return new BSHFilterConstraint(constraintExp);
    }

    private static class BSHFilterConstraint
    implements FilterConstraint {
        private final String constraint_;

        BSHFilterConstraint(ConstraintExp constraintExp) {
            this.constraint_ = constraintExp.constraint_expr;
        }

        @Override
        public EvaluationResult evaluate(EvaluationContext context, Message message) throws EvaluationException {
            try {
                Interpreter _interpreter = new Interpreter();
                _interpreter.eval("import org.omg.CORBA.*;");
                _interpreter.set("event", message.toAny());
                _interpreter.set("date", new Date());
                _interpreter.set("constraint", this.constraint_);
                Object _result = _interpreter.eval(this.constraint_);
                if (_result == null) {
                    return EvaluationResult.BOOL_FALSE;
                }
                if (_result instanceof Boolean) {
                    if (_result.equals(Boolean.TRUE)) {
                        return EvaluationResult.BOOL_TRUE;
                    }
                    return EvaluationResult.BOOL_FALSE;
                }
                if (_result instanceof String) {
                    if ("".equals(_result)) {
                        return EvaluationResult.BOOL_FALSE;
                    }
                    return EvaluationResult.BOOL_TRUE;
                }
                return EvaluationResult.BOOL_TRUE;
            }
            catch (EvalError e) {
                throw new EvaluationException(e);
            }
        }
    }
}

