/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.entropysoft.transmorph.utils.NumberUtils;

public class NumberInRange {
    public static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    public static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    public static final BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    public static final BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    public static final BigInteger INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigDecimal FLOAT_MAX = new BigDecimal(3.4028234663852886E38);
    public static final BigDecimal FLOAT_MIN = new BigDecimal(-3.4028234663852886E38);
    public static final BigDecimal DOUBLE_MAX = new BigDecimal(Double.MAX_VALUE);
    public static final BigDecimal DOUBLE_MIN = new BigDecimal(-1.7976931348623157E308);

    public static boolean isInByteRange(Number number) {
        return NumberInRange.isInRange(number, BYTE_MIN, BYTE_MAX);
    }

    public static boolean isInShortRange(Number number) {
        return NumberInRange.isInRange(number, SHORT_MIN, SHORT_MAX);
    }

    public static boolean isInIntegerRange(Number number) {
        return NumberInRange.isInRange(number, INTEGER_MIN, INTEGER_MAX);
    }

    public static boolean isInLongRange(Number number) {
        return NumberInRange.isInRange(number, LONG_MIN, LONG_MAX);
    }

    public static boolean isInRange(Number number, BigInteger min, BigInteger max) {
        try {
            BigInteger bigInteger = NumberUtils.getBigInteger(number);
            return max.compareTo(bigInteger) >= 0 && min.compareTo(bigInteger) <= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInRange(Number number, BigDecimal min, BigDecimal max) {
        try {
            BigDecimal bigDecimal = NumberUtils.getBigDecimal(number);
            return max.compareTo(bigDecimal) >= 0 && min.compareTo(bigDecimal) <= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInFloatRange(Number number) {
        return NumberInRange.isInRange(number, FLOAT_MIN, FLOAT_MAX);
    }

    public static boolean isInDoubleRange(Number number) {
        return NumberInRange.isInRange(number, DOUBLE_MIN, DOUBLE_MAX);
    }
}

