/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.signature.ArrayTypeSignature;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.PrimitiveTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;
import net.entropysoft.transmorph.signature.TypeSignature;
import net.entropysoft.transmorph.signature.formatter.ITypeSignatureFormatter;

public class JavaSyntaxTypeSignatureFormatter
implements ITypeSignatureFormatter {
    private static Map<Character, String> primitiveTypesMap = new HashMap<Character, String>();
    private boolean useSimpleNames = false;

    public boolean isUseSimpleNames() {
        return this.useSimpleNames;
    }

    public void setUseSimpleNames(boolean useSimpleNames) {
        this.useSimpleNames = useSimpleNames;
    }

    public String format(TypeSignature typeSignature) {
        if (typeSignature.isPrimitiveType()) {
            return this.formatPrimitiveTypeSignature((PrimitiveTypeSignature)typeSignature);
        }
        if (typeSignature.isArrayType()) {
            return this.formatArrayTypeSignature((ArrayTypeSignature)typeSignature);
        }
        if (typeSignature.isClassType()) {
            return this.formatClassTypeSignature((ClassTypeSignature)typeSignature);
        }
        if (typeSignature.isTypeArgument()) {
            return this.formatTypeArgSignature((TypeArgSignature)typeSignature);
        }
        return null;
    }

    private String formatArrayTypeSignature(ArrayTypeSignature typeSignature) {
        return this.format(typeSignature.getComponentTypeSignature()) + "[]";
    }

    private String formatPrimitiveTypeSignature(PrimitiveTypeSignature typeSignature) {
        return primitiveTypesMap.get(Character.valueOf(typeSignature.getPrimitiveTypeChar()));
    }

    private ClassTypeSignature[] getClassTypeSignatures(ClassTypeSignature classTypeSignature) {
        ArrayList<ClassTypeSignature> list = new ArrayList<ClassTypeSignature>();
        while (classTypeSignature != null) {
            list.add(0, classTypeSignature);
            classTypeSignature = classTypeSignature.getOwnerTypeSignature();
        }
        return list.toArray(new ClassTypeSignature[list.size()]);
    }

    private String formatClassTypeSignature(ClassTypeSignature typeSignature) {
        ClassTypeSignature[] classTypeSignatures = this.getClassTypeSignatures(typeSignature);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < classTypeSignatures.length; ++i) {
            ClassTypeSignature classTypeSignature = classTypeSignatures[i];
            if (i == 0) {
                if (this.useSimpleNames) {
                    sb.append(this.getSimpleName(classTypeSignature.getBinaryName()));
                } else {
                    sb.append(classTypeSignature.getBinaryName());
                }
            } else {
                sb.append('.');
                sb.append(classTypeSignature.getBinaryName());
            }
            if (classTypeSignature.getTypeArgSignatures().length <= 0) continue;
            sb.append('<');
            TypeArgSignature[] typeArgSignatures = classTypeSignature.getTypeArgSignatures();
            for (int j = 0; j < typeArgSignatures.length; ++j) {
                if (j != 0) {
                    sb.append(',');
                }
                sb.append(this.formatTypeArgSignature(typeArgSignatures[j]));
            }
            sb.append('>');
        }
        return sb.toString();
    }

    private String getSimpleName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(".") + 1);
    }

    private String formatTypeArgSignature(TypeArgSignature typeArgSignature) {
        StringBuilder sb = new StringBuilder();
        char wildcard = typeArgSignature.getWildcard();
        if (wildcard == TypeArgSignature.LOWERBOUND_WILDCARD) {
            sb.append("? super ");
        } else if (wildcard == TypeArgSignature.UPPERBOUND_WILDCARD) {
            sb.append("? extends ");
        } else if (wildcard == TypeArgSignature.UNBOUNDED_WILDCARD) {
            sb.append("?");
        }
        if (typeArgSignature.getFieldTypeSignature() != null) {
            sb.append(this.format(typeArgSignature.getFieldTypeSignature()));
        }
        return sb.toString();
    }

    static {
        primitiveTypesMap.put(Character.valueOf('Z'), Boolean.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('B'), Byte.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('C'), Character.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('D'), Double.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('F'), Float.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('I'), Integer.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('J'), Long.TYPE.getName());
        primitiveTypesMap.put(Character.valueOf('S'), Short.TYPE.getName());
    }
}

