/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.FieldTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.JavaTypeToTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;
import net.entropysoft.transmorph.signature.TypeSignature;
import net.entropysoft.transmorph.signature.parser.ClassFileTypeSignatureParser;
import net.entropysoft.transmorph.type.TypeReference;
import net.entropysoft.transmorph.utils.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSignatureFactory {
    private static JavaTypeToTypeSignature javaTypeToTypeSignature = new JavaTypeToTypeSignature();
    private static Map<String, FullTypeSignature> typeSignatureCache = Collections.synchronizedMap(new LRUMap(100));

    public static FullTypeSignature getTypeSignature(String typeSignatureString) {
        return TypeSignatureFactory.getTypeSignature(typeSignatureString, true);
    }

    public static FullTypeSignature getTypeSignature(String typeSignatureString, boolean useInternalFormFullyQualifiedName) {
        String key = !useInternalFormFullyQualifiedName ? typeSignatureString.replace('.', '/').replace('$', '.') : typeSignatureString;
        FullTypeSignature typeSignature = typeSignatureCache.get(key);
        if (typeSignature == null) {
            ClassFileTypeSignatureParser typeSignatureParser = new ClassFileTypeSignatureParser(typeSignatureString);
            typeSignatureParser.setUseInternalFormFullyQualifiedName(useInternalFormFullyQualifiedName);
            typeSignature = typeSignatureParser.parseTypeSignature();
            typeSignatureCache.put(typeSignatureString, typeSignature);
        }
        return typeSignature;
    }

    public static TypeSignature getTypeSignature(Type type) {
        return javaTypeToTypeSignature.getTypeSignature(type);
    }

    public static TypeSignature getTypeSignature(TypeReference<?> type) {
        return javaTypeToTypeSignature.getTypeSignature(type);
    }

    public static FullTypeSignature getTypeSignature(Class<?> type) {
        return (FullTypeSignature)javaTypeToTypeSignature.getTypeSignature((Type)type);
    }

    public static FullTypeSignature getTypeSignature(Class<?> clazz, Class<?>[] typeArgs) {
        ClassTypeSignature rawClassTypeSignature = (ClassTypeSignature)javaTypeToTypeSignature.getTypeSignature((Type)clazz);
        TypeArgSignature[] typeArgSignatures = new TypeArgSignature[typeArgs.length];
        for (int i = 0; i < typeArgs.length; ++i) {
            typeArgSignatures[i] = new TypeArgSignature(TypeArgSignature.NO_WILDCARD, (FieldTypeSignature)javaTypeToTypeSignature.getTypeSignature((Type)typeArgs[i]));
        }
        ClassTypeSignature classTypeSignature = new ClassTypeSignature(rawClassTypeSignature.getBinaryName(), typeArgSignatures, rawClassTypeSignature.getOwnerTypeSignature());
        return classTypeSignature;
    }
}

