/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature;

import net.entropysoft.transmorph.signature.FieldTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.TypeSignature;
import net.entropysoft.transmorph.signature.TypeSignatureFactory;
import net.entropysoft.transmorph.signature.formatter.ClassFileTypeSignatureFormatter;

public class TypeArgSignature
extends TypeSignature {
    public static char NO_WILDCARD = (char)32;
    public static char UNBOUNDED_WILDCARD = (char)42;
    public static char UPPERBOUND_WILDCARD = (char)43;
    public static char LOWERBOUND_WILDCARD = (char)45;
    private final char wildcard;
    private final FieldTypeSignature fieldTypeSignature;
    private volatile String signature;

    public TypeArgSignature(char wildcard, FieldTypeSignature fieldTypeSignature) {
        this.wildcard = wildcard;
        this.fieldTypeSignature = fieldTypeSignature;
    }

    public char getWildcard() {
        return this.wildcard;
    }

    public FieldTypeSignature getFieldTypeSignature() {
        return this.fieldTypeSignature;
    }

    public String getSignature() {
        if (this.signature == null) {
            ClassFileTypeSignatureFormatter typeSignatureFormatter = new ClassFileTypeSignatureFormatter();
            this.signature = typeSignatureFormatter.formatTypeArgSignature(this);
        }
        return this.signature;
    }

    public String toString() {
        return this.getSignature();
    }

    public boolean isTypeArgument() {
        return true;
    }

    public FullTypeSignature getTypeErasureSignature() {
        if (this.wildcard == NO_WILDCARD) {
            return this.getFieldTypeSignature().getTypeErasureSignature();
        }
        if (this.wildcard == UNBOUNDED_WILDCARD) {
            return TypeSignatureFactory.getTypeSignature(Object.class);
        }
        if (this.wildcard == UPPERBOUND_WILDCARD) {
            return this.getFieldTypeSignature().getTypeErasureSignature();
        }
        if (this.wildcard == LOWERBOUND_WILDCARD) {
            return TypeSignatureFactory.getTypeSignature(Object.class);
        }
        return null;
    }
}

