/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.injectors;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.IdentityConverter;
import net.entropysoft.transmorph.converters.MultiConverter;
import net.entropysoft.transmorph.converters.WrapperToPrimitive;
import net.entropysoft.transmorph.converters.beans.BeanToBeanMapping;
import net.entropysoft.transmorph.converters.beans.IBeanPropertyTypeProvider;
import net.entropysoft.transmorph.converters.beans.utils.ClassPair;
import net.entropysoft.transmorph.injectors.AbstractBeanInjector;
import net.entropysoft.transmorph.type.TypeReference;
import net.entropysoft.transmorph.utils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanToBeanInjector
extends AbstractBeanInjector {
    private IBeanPropertyTypeProvider beanDestinationPropertyTypeProvider;
    private Map<ClassPair<?, ?>, BeanToBeanMapping> beanToBeanMappings = new HashMap();
    private boolean handleTargetClassSameAsSourceClass = true;
    private boolean handleTargetClassIsSuperClassOfSourceClass = true;

    public BeanToBeanInjector() {
        this.propertyValueConverter = new MultiConverter(new IdentityConverter(), new WrapperToPrimitive());
    }

    public IBeanPropertyTypeProvider getBeanDestinationPropertyTypeProvider() {
        return this.beanDestinationPropertyTypeProvider;
    }

    public void setBeanDestinationPropertyTypeProvider(IBeanPropertyTypeProvider beanDestinationPropertyTypeProvider) {
        this.beanDestinationPropertyTypeProvider = beanDestinationPropertyTypeProvider;
    }

    public void addBeanToBeanMapping(BeanToBeanMapping beanToBeanMapping) {
        this.beanToBeanMappings.put(ClassPair.get(beanToBeanMapping.getSourceClass(), beanToBeanMapping.getDestinationClass()), beanToBeanMapping);
    }

    public boolean isHandleTargetClassSameAsSourceClass() {
        return this.handleTargetClassSameAsSourceClass;
    }

    public boolean isHandleTargetClassIsSuperClassOfSourceClass() {
        return this.handleTargetClassIsSuperClassOfSourceClass;
    }

    public void setHandleTargetClassSameAsSourceClass(boolean useIfTargetClassSameAsSourceClass) {
        this.handleTargetClassSameAsSourceClass = useIfTargetClassSameAsSourceClass;
    }

    @Override
    public boolean canHandle(Object sourceObject, TypeReference<?> targetType) {
        return this.canHandle(sourceObject.getClass(), targetType.getRawType());
    }

    @Override
    public void inject(ConversionContext context, Object sourceObject, Object targetBean, TypeReference<?> targetType) throws ConverterException {
        Class<?> destinationClass = targetType.getRawType();
        if (!this.canHandle(sourceObject.getClass(), destinationClass)) {
            throw new ConverterException(MessageFormat.format("Could not get bean to bean mapping for ''{0}''=>''{1}''", sourceObject.getClass().getName(), destinationClass.getName()));
        }
        Map<String, Method> destinationSetters = BeanUtils.getSetters(destinationClass);
        for (Map.Entry<String, Method> entry : destinationSetters.entrySet()) {
            Object sourcePropertyValue;
            String destinationPropertyName = entry.getKey();
            Method destinationMethod = entry.getValue();
            Method sourceMethod = this.getPropertySourceMethod(sourceObject, targetBean, destinationPropertyName);
            if (sourceMethod == null) continue;
            try {
                sourcePropertyValue = sourceMethod.invoke(sourceObject, new Object[0]);
            }
            catch (Exception e) {
                throw new ConverterException("Could not get property for bean", e);
            }
            Type parameterType = destinationMethod.getGenericParameterTypes()[0];
            TypeReference<?> originalType = TypeReference.get(parameterType);
            TypeReference<?> propertyDestinationType = this.getBeanPropertyType(destinationClass, destinationPropertyName, originalType);
            Object destinationPropertyValue = this.propertyValueConverter.convert(context, sourcePropertyValue, propertyDestinationType);
            try {
                destinationMethod.invoke(targetBean, destinationPropertyValue);
            }
            catch (Exception e) {
                throw new ConverterException("Could not set property for bean", e);
            }
        }
    }

    private Method getPropertySourceMethod(Object sourceObject, Object destinationObject, String destinationProperty) {
        BeanToBeanMapping beanToBeanMapping = this.beanToBeanMappings.get(ClassPair.get(sourceObject.getClass(), destinationObject.getClass()));
        String sourceProperty = null;
        if (beanToBeanMapping != null) {
            sourceProperty = beanToBeanMapping.getSourceProperty(destinationProperty);
        }
        if (sourceProperty == null) {
            sourceProperty = destinationProperty;
        }
        return BeanUtils.getGetterPropertyMethod(sourceObject.getClass(), sourceProperty);
    }

    protected TypeReference<?> getBeanPropertyType(Class<?> clazz, String propertyName, TypeReference<?> originalType) {
        TypeReference<?> propertyDestinationType = null;
        if (this.beanDestinationPropertyTypeProvider != null) {
            propertyDestinationType = this.beanDestinationPropertyTypeProvider.getPropertyType(clazz, propertyName, originalType);
        }
        if (propertyDestinationType == null) {
            propertyDestinationType = originalType;
        }
        return propertyDestinationType;
    }

    private boolean canHandle(Class<?> sourceObjectClass, Class<?> destinationClass) {
        if (this.handleTargetClassSameAsSourceClass && sourceObjectClass.equals(destinationClass)) {
            return true;
        }
        if (this.handleTargetClassIsSuperClassOfSourceClass && destinationClass.isAssignableFrom(sourceObjectClass)) {
            return true;
        }
        BeanToBeanMapping beanToBeanMapping = this.beanToBeanMappings.get(ClassPair.get(sourceObjectClass, destinationClass));
        return beanToBeanMapping != null;
    }
}

