/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.collections;

import java.lang.reflect.Type;
import java.util.Map;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.converters.collections.DefaultStringMapFormatter;
import net.entropysoft.transmorph.converters.collections.IStringMapFormatter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToString
extends AbstractContainerConverter {
    private IStringMapFormatter stringMapFormatter = new DefaultStringMapFormatter();
    private IConverter keyConverter;
    private IConverter valueConverter;

    public MapToString() {
        this.useObjectPool = false;
    }

    public IConverter getKeyConverter() {
        return this.keyConverter;
    }

    public void setKeyConverter(IConverter keyConverter) {
        this.keyConverter = keyConverter;
    }

    public IConverter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(IConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    public IStringMapFormatter getStringMapFormatter() {
        return this.stringMapFormatter;
    }

    public void setStringMapFormatter(IStringMapFormatter stringMapFormatter) {
        this.stringMapFormatter = stringMapFormatter;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        Map sourceMap = (Map)sourceObject;
        String[] keyStrings = new String[sourceMap.size()];
        String[] valueStrings = new String[sourceMap.size()];
        int i = 0;
        for (Map.Entry mapEntry : sourceMap.entrySet()) {
            IConverter converter = this.keyConverter;
            if (converter == null) {
                converter = this.elementConverter;
            }
            String key = (String)converter.convert(context, mapEntry.getKey(), destinationType);
            converter = this.valueConverter;
            if (converter == null) {
                converter = this.elementConverter;
            }
            String value = (String)converter.convert(context, mapEntry.getValue(), destinationType);
            keyStrings[i] = key;
            valueStrings[i] = value;
            ++i;
        }
        return this.stringMapFormatter.format(keyStrings, valueStrings);
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isType((Type)((Object)String.class));
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof Map;
    }
}

