/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.collections;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToMap
extends AbstractContainerConverter {
    private Class<? extends Map> defaultMapClass = HashMap.class;
    private IConverter keyConverter;
    private IConverter valueConverter;

    public MapToMap() {
        this.useObjectPool = true;
    }

    public IConverter getKeyConverter() {
        return this.keyConverter;
    }

    public void setKeyConverter(IConverter keyConverter) {
        this.keyConverter = keyConverter;
    }

    public IConverter getValueConverter() {
        return this.valueConverter;
    }

    public void setValueConverter(IConverter valueConverter) {
        this.valueConverter = valueConverter;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        Map<Object, Object> destinationMap;
        if (sourceObject == null) {
            return null;
        }
        Map sourceMap = (Map)sourceObject;
        try {
            destinationMap = this.createDestinationMap(sourceMap, destinationType);
        }
        catch (Exception e) {
            throw new ConverterException("Could not create destination map", e);
        }
        if (destinationMap == null) {
            throw new ConverterException("Could not create destination map");
        }
        if (this.useObjectPool) {
            context.getConvertedObjectPool().add(this, sourceObject, destinationType, destinationMap);
        }
        TypeReference<?>[] destinationTypeArguments = this.getDestinationTypeArguments(destinationType);
        for (Map.Entry mapEntry : sourceMap.entrySet()) {
            IConverter converter = this.keyConverter;
            if (converter == null) {
                converter = this.elementConverter;
            }
            Object key = converter.convert(context, mapEntry.getKey(), destinationTypeArguments[0]);
            converter = this.valueConverter;
            if (converter == null) {
                converter = this.elementConverter;
            }
            Object value = converter.convert(context, mapEntry.getValue(), destinationTypeArguments[1]);
            destinationMap.put(key, value);
        }
        return destinationMap;
    }

    protected TypeReference<?>[] getDestinationTypeArguments(TypeReference<?> mapDestinationType) {
        if (mapDestinationType.isRawTypeSubOf(Properties.class)) {
            return new TypeReference[]{TypeReference.get(String.class), TypeReference.get(String.class)};
        }
        TypeReference<?>[] destinationTypeArguments = mapDestinationType.getTypeArguments();
        if (destinationTypeArguments.length == 0) {
            destinationTypeArguments = new TypeReference[]{TypeReference.get(Object.class), TypeReference.get(Object.class)};
        }
        return destinationTypeArguments;
    }

    private Map<Object, Object> createDestinationMap(Map sourceObject, TypeReference<?> destinationType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class<? extends Map> clazz = this.getConcreteMapDestinationClass(sourceObject, destinationType);
        if (clazz == null) {
            return null;
        }
        return clazz.newInstance();
    }

    protected Class<? extends Map> getConcreteMapDestinationClass(Map sourceObject, TypeReference<?> destinationType) throws ClassNotFoundException {
        if (destinationType.hasRawType(Map.class)) {
            return this.defaultMapClass;
        }
        Class<?> destinationClass = destinationType.getRawType();
        if (destinationClass.isInterface() || Modifier.isAbstract(destinationClass.getModifiers())) {
            return null;
        }
        try {
            destinationClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
        return destinationClass;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isRawTypeSubOf(Map.class);
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof Map;
    }
}

