/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph;

import java.text.MessageFormat;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IBeanInjector;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransmorphBeanInjector
implements IBeanInjector {
    private final IBeanInjector beanInjector;

    public TransmorphBeanInjector(IBeanInjector beanInjector) {
        this.beanInjector = beanInjector;
    }

    public void inject(Object source, Object targetBean) throws ConverterException {
        this.inject(source, targetBean, targetBean.getClass());
    }

    public void inject(Object source, Object targetBean, Class<?> targetClass) throws ConverterException {
        this.inject(new ConversionContext(), source, targetBean, targetClass);
    }

    public void inject(ConversionContext context, Object source, Object targetBean, Class<?> targetClass) throws ConverterException {
        this.inject(context, source, targetBean, TypeReference.get(targetClass));
    }

    @Override
    public void inject(ConversionContext context, Object source, Object targetBean, TypeReference<?> targetType) throws ConverterException {
        try {
            this.beanInjector.inject(context, source, targetBean, targetType);
        }
        catch (ConverterException e) {
            throw new ConverterException(MessageFormat.format("Could not inject into bean ''{0}'' from object ''{1}''", targetBean.getClass().getName(), source.getClass().getName()), e);
        }
    }

    @Override
    public boolean canHandle(Object sourceObject, TypeReference<?> targetType) {
        return this.beanInjector.canHandle(sourceObject, targetType);
    }

    @Override
    public IConverter getPropertyValueConverter() {
        return this.beanInjector.getPropertyValueConverter();
    }

    @Override
    public void setPropertyValueConverter(IConverter converter) {
        this.beanInjector.setPropertyValueConverter(converter);
    }
}

