/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph;

import java.sql.Date;
import java.text.DateFormat;
import java.text.NumberFormat;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.converters.CharacterArrayToString;
import net.entropysoft.transmorph.converters.ClassToString;
import net.entropysoft.transmorph.converters.MultiConverter;
import net.entropysoft.transmorph.converters.ObjectToFormattedString;
import net.entropysoft.transmorph.converters.ObjectToString;
import net.entropysoft.transmorph.converters.collections.CollectionToString;
import net.entropysoft.transmorph.converters.collections.MapToString;
import net.entropysoft.transmorph.converters.propertyeditors.ToStringUsingPropertyEditor;

public class DefaultToStringConverters
extends MultiConverter {
    private CollectionToString collectionToString = new CollectionToString();
    private MapToString mapToString = new MapToString();
    private ToStringUsingPropertyEditor toStringUsingPropertyEditor = new ToStringUsingPropertyEditor();
    private CharacterArrayToString characterArrayToString = new CharacterArrayToString();
    private ClassToString classToString = new ClassToString();
    private ObjectToString objectToString = new ObjectToString();
    private ObjectToFormattedString dateToFormattedString = new ObjectToFormattedString(Date.class, DateFormat.getInstance());
    private ObjectToFormattedString numberToFormattedString = new ObjectToFormattedString(Number.class, NumberFormat.getInstance());
    private MultiConverter multiConverter = new MultiConverter(false, new IConverter[0]);

    public DefaultToStringConverters() {
        this(false, false);
    }

    public DefaultToStringConverters(boolean formatNumber, boolean formatDate) {
        super(false, new IConverter[0]);
        super.addConverter(this.multiConverter);
        super.addConverter(this.objectToString);
        this.addConverter(this.toStringUsingPropertyEditor);
        this.addConverter(this.characterArrayToString);
        this.addConverter(this.classToString);
        this.addConverter(this.collectionToString);
        this.addConverter(this.mapToString);
        if (formatNumber) {
            this.addConverter(this.numberToFormattedString);
        }
        if (formatDate) {
            this.addConverter(this.dateToFormattedString);
        }
        this.addConverter(this.objectToString);
    }

    public void addConverter(IConverter converter) {
        this.multiConverter.addConverter(converter);
    }

    public void removeConverter(IConverter converter) {
        if (converter == this.objectToString) {
            super.removeConverter(converter);
        } else {
            this.multiConverter.removeConverter(converter);
        }
    }

    public CollectionToString getCollectionToString() {
        return this.collectionToString;
    }

    public MapToString getMapToString() {
        return this.mapToString;
    }

    public ToStringUsingPropertyEditor getToStringUsingPropertyEditor() {
        return this.toStringUsingPropertyEditor;
    }

    public CharacterArrayToString getCharacterArrayToString() {
        return this.characterArrayToString;
    }

    public ClassToString getClassToString() {
        return this.classToString;
    }

    public ObjectToString getObjectToString() {
        return this.objectToString;
    }

    public ObjectToFormattedString getDateToFormattedString() {
        return this.dateToFormattedString;
    }

    public ObjectToFormattedString getNumberToFormattedString() {
        return this.numberToFormattedString;
    }
}

