/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.soleil.tango.clientapi.attribute.ITangoAttribute;
import fr.soleil.tango.clientapi.util.TypeConversionUtil;
import java.lang.reflect.Array;
import org.tango.attribute.AttributeTangoType;
import org.tango.utils.ArrayUtils;

public final class MockAttribute
implements ITangoAttribute {
    private final String attributeName;
    private Object mockValue;
    private final Class<?> mockType;
    private long timeStamp;

    public MockAttribute(String attributeName, Object mockValue) {
        this.mockValue = mockValue;
        this.mockType = mockValue.getClass();
        this.attributeName = attributeName;
        this.timeStamp = System.currentTimeMillis();
    }

    @Override
    public Object extract() throws DevFailed {
        return this.mockValue;
    }

    @Override
    public Object extractArray() throws DevFailed {
        return this.mockValue;
    }

    @Override
    public <T> T extract(Class<T> type) throws DevFailed {
        return TypeConversionUtil.castToType(type, this.mockValue);
    }

    @Override
    public void insert(Object value) throws DevFailed {
        this.mockValue = TypeConversionUtil.castToType(this.mockType, value);
    }

    @Override
    public void write() throws DevFailed {
    }

    @Override
    public void update() throws DevFailed {
        this.timeStamp = System.currentTimeMillis();
    }

    @Override
    public void insertSpectrum(Object ... values) throws DevFailed {
        this.mockValue = TypeConversionUtil.castToType(this.mockType, values);
    }

    @Override
    public void insertImage(int dimX, int dimY, Object ... values) throws DevFailed {
        this.mockValue = TypeConversionUtil.castToType(this.mockType, values);
    }

    @Override
    public <T> Object extractArray(Class<T> type) throws DevFailed {
        return TypeConversionUtil.castToArray(type, this.mockValue);
    }

    @Override
    public <T> Object extractWrittenArray(Class<T> type) throws DevFailed {
        return TypeConversionUtil.castToArray(type, this.mockValue);
    }

    @Override
    public Object extractWritten() throws DevFailed {
        return this.mockValue;
    }

    @Override
    public Object extractWrittenArray() throws DevFailed {
        return this.mockValue;
    }

    @Override
    public <T> T extractWritten(Class<T> type) throws DevFailed {
        return TypeConversionUtil.castToType(type, this.mockValue);
    }

    @Override
    public <T> T[] extractSpecOrImage(Class<T> type) throws DevFailed {
        return (Object[])TypeConversionUtil.castToArray(type, this.mockValue);
    }

    @Override
    public <T> T[] extractWrittenSpecOrImage(Class<T> type) throws DevFailed {
        return (Object[])TypeConversionUtil.castToArray(type, this.mockValue);
    }

    @Override
    public String extractToString(String separator, String endSeparator) throws DevFailed {
        String str = "";
        if (this.isScalar()) {
            str = TypeConversionUtil.castToType(String.class, this.mockValue);
        } else if (this.isSpectrum()) {
            String[] s = TypeConversionUtil.castToType(String[].class, this.mockValue);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < s.length; ++i) {
                buff.append(s[i]);
                if (i == s.length - 1) continue;
                buff.append(separator);
            }
            str = buff.toString();
        } else if (this.isImage()) {
            int dimx = this.getDimX();
            int dimy = this.getDimY();
            String[] s = TypeConversionUtil.castToType(String[].class, this.mockValue);
            StringBuffer buff = new StringBuffer(s.length);
            for (int i = 0; i < dimy; ++i) {
                for (int j = 0; j < dimx; ++j) {
                    buff.append(s[i * dimx + j]);
                    if (j == dimx - 1) continue;
                    buff.append(separator);
                }
                if (i == dimy - 1) continue;
                buff.append(endSeparator);
            }
            str = buff.toString();
        }
        return str;
    }

    @Override
    public boolean isNumber() {
        boolean isNumber = false;
        Class<?> mockClass = this.mockType;
        while (mockClass.isArray()) {
            mockClass = mockClass.getComponentType();
        }
        if (Number.class.isAssignableFrom(mockClass)) {
            isNumber = true;
        }
        return isNumber;
    }

    @Override
    public boolean isBoolean() {
        boolean isBoolean = false;
        Class<?> mockClass = this.mockType;
        while (mockClass.isArray()) {
            mockClass = mockClass.getComponentType();
        }
        if (Boolean.class.isAssignableFrom(mockClass)) {
            isBoolean = true;
        }
        return isBoolean;
    }

    @Override
    public boolean isString() {
        boolean isString = false;
        Class<?> mockClass = this.mockType;
        while (mockClass.isArray()) {
            mockClass = mockClass.getComponentType();
        }
        if (String.class.isAssignableFrom(mockClass)) {
            isString = true;
        }
        return isString;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isScalar() {
        return !this.mockValue.getClass().isArray();
    }

    @Override
    public boolean isSpectrum() {
        boolean isSpectrum = false;
        if (this.mockType.isArray() && !this.mockType.getComponentType().isArray()) {
            isSpectrum = true;
        }
        return isSpectrum;
    }

    @Override
    public boolean isImage() {
        boolean isImage = false;
        if (this.mockType.isArray() && this.mockType.getComponentType().isArray()) {
            isImage = true;
        }
        return isImage;
    }

    @Override
    public AttributeProxy getAttributeProxy() {
        return null;
    }

    @Override
    public DeviceAttribute getDeviceAttribute() {
        return new DeviceAttribute(this.attributeName);
    }

    @Override
    public int getDimX() throws DevFailed {
        int dimX = 1;
        if (this.isSpectrum()) {
            dimX = Array.getLength(this.mockValue);
        } else if (this.isImage()) {
            dimX = ArrayUtils.get2DArrayXDim(this.mockValue);
        }
        return dimX;
    }

    @Override
    public int getDimY() throws DevFailed {
        int dimY = 0;
        if (this.isImage()) {
            dimY = Array.getLength(this.mockValue);
        }
        return dimY;
    }

    @Override
    public int getWrittenDimX() throws DevFailed {
        return this.getDimX();
    }

    @Override
    public int getWrittenDimY() throws DevFailed {
        return this.getDimY();
    }

    @Override
    public int getDataType() throws DevFailed {
        return AttributeTangoType.getTypeFromClass(this.mockType).getTangoIDLType();
    }

    @Override
    public AttrWriteType getWriteType() {
        return AttrWriteType.READ_WRITE;
    }

    @Override
    public String getDeviceName() throws DevFailed {
        return this.attributeName;
    }

    @Override
    public long getTimestamp() throws DevFailed {
        return this.timeStamp;
    }

    @Override
    public AttrDataFormat getDataFormat() {
        AttrDataFormat format = AttrDataFormat.SCALAR;
        if (this.isSpectrum()) {
            format = AttrDataFormat.SPECTRUM;
        } else if (this.isImage()) {
            format = AttrDataFormat.IMAGE;
        }
        return format;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public AttrQuality getQuality() {
        return AttrQuality.ATTR_VALID;
    }

    @Override
    public void setTimeout(int timeout) throws DevFailed {
    }
}

