/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.Group.Group;
import fr.esrf.TangoApi.Group.GroupCmdReply;
import fr.esrf.TangoApi.Group.GroupCmdReplyList;
import fr.soleil.tango.clientapi.InsertExtractUtils;
import fr.soleil.tango.clientapi.factory.ProxyFactory;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public final class TangoGroupCommand {
    private static final String ALL_INPUT_TYPES_MUST_BE_THE_SAME = "all input types must be the same";
    private static final String TANGO_WRONG_DATA_ERROR = "TANGO_WRONG_DATA_ERROR";
    private final Group group;
    private final String commandName;
    private final DeviceData[] inData;

    public TangoGroupCommand(String groupName, String commandName, String ... deviceNames) throws DevFailed {
        int i;
        this.group = ProxyFactory.getInstance().createGroup(groupName, deviceNames);
        for (i = 0; i < this.group.get_size(true); ++i) {
            DeviceProxy dev = this.group.get_device(i + 1);
            if (dev == null) {
                DevFailedUtils.throwDevFailed("impossible to create " + commandName);
            }
            dev.command_query(commandName);
        }
        this.commandName = commandName;
        this.inData = new DeviceData[deviceNames.length];
        for (i = 0; i < deviceNames.length; ++i) {
            this.inData[i] = new DeviceData();
        }
    }

    public void execute() throws DevFailed {
        GroupCmdReplyList replies = this.isArginVoid() ? this.group.command_inout(this.commandName, true) : this.group.command_inout(this.commandName, this.inData, true);
        if (replies.has_failed()) {
            for (Object obj : replies) {
                ((GroupCmdReply)obj).get_data();
            }
        }
    }

    public void insert(Object value) throws DevFailed {
        for (int i = 0; i < this.group.get_size(true); ++i) {
            int arginType = this.group.get_device((int)(i + 1)).command_query((String)this.commandName).in_type;
            InsertExtractUtils.insert(this.inData[i], arginType, value);
        }
    }

    public void insert(Object ... value) throws DevFailed {
        if (value.length == 1) {
            for (int i = 0; i < this.group.get_size(true); ++i) {
                int arginType = this.group.get_device((int)(i + 1)).command_query((String)this.commandName).in_type;
                InsertExtractUtils.insert(this.inData[i], arginType, value);
            }
        } else {
            if (value.length != this.group.get_size(true)) {
                DevFailedUtils.throwDevFailed(TANGO_WRONG_DATA_ERROR, this.group.get_size(true) + " values must be provided");
            }
            for (int i = 0; i < this.group.get_size(true); ++i) {
                int arginType = this.group.get_device((int)(i + 1)).command_query((String)this.commandName).in_type;
                InsertExtractUtils.insert(this.inData[i], arginType, value[i]);
            }
        }
    }

    public void insertMixArgin(double[] numberArgin, String[] stringArgin) throws DevFailed {
        int arginType = 0;
        int previousType = 0;
        for (int i = 0; i < this.group.get_size(true); ++i) {
            previousType = arginType;
            DeviceProxy dev = this.group.get_device(i + 1);
            arginType = dev.command_query((String)this.commandName).in_type;
            if (i <= 0 || arginType == previousType) continue;
            DevFailedUtils.throwDevFailed(TANGO_WRONG_DATA_ERROR, ALL_INPUT_TYPES_MUST_BE_THE_SAME);
        }
        if (arginType == 18) {
            DevVarDoubleStringArray dvdsa = new DevVarDoubleStringArray(numberArgin, stringArgin);
            for (int i = 0; i < this.group.get_size(true); ++i) {
                this.inData[i].insert(dvdsa);
            }
        } else if (arginType == 17) {
            int[] in = new int[numberArgin.length];
            for (int i = 0; i < numberArgin.length; ++i) {
                in[i] = (int)numberArgin[i];
            }
            DevVarLongStringArray dvlsa = new DevVarLongStringArray(in, stringArgin);
            for (int i = 0; i < this.group.get_size(true); ++i) {
                this.inData[i].insert(dvlsa);
            }
        } else {
            DevFailedUtils.throwDevFailed(TANGO_WRONG_DATA_ERROR, "input type  not supported");
        }
    }

    public void insertMixArgin(String[] numberArgin, String[] stringArgin) throws DevFailed {
        int arginType = 0;
        int previousType = 0;
        for (int i = 0; i < this.group.get_size(true); ++i) {
            previousType = arginType;
            DeviceProxy dev = this.group.get_device(i + 1);
            arginType = dev.command_query((String)this.commandName).in_type;
            if (i <= 0 || arginType == previousType) continue;
            DevFailedUtils.throwDevFailed(TANGO_WRONG_DATA_ERROR, ALL_INPUT_TYPES_MUST_BE_THE_SAME);
        }
        if (arginType == 18) {
            double[] d = new double[numberArgin.length];
            for (int i = 0; i < numberArgin.length; ++i) {
                d[i] = Double.parseDouble(numberArgin[i]);
            }
            DevVarDoubleStringArray dvdsa = new DevVarDoubleStringArray(d, stringArgin);
            for (int i = 0; i < this.group.get_size(true); ++i) {
                this.inData[i].insert(dvdsa);
            }
        } else if (arginType == 17) {
            int[] in = new int[numberArgin.length];
            for (int i = 0; i < numberArgin.length; ++i) {
                in[i] = Integer.parseInt(numberArgin[i]);
            }
            DevVarLongStringArray dvlsa = new DevVarLongStringArray(in, stringArgin);
            for (int i = 0; i < this.group.get_size(true); ++i) {
                this.inData[i].insert(dvlsa);
            }
        } else {
            DevFailedUtils.throwDevFailed(TANGO_WRONG_DATA_ERROR, "input type  not supported");
        }
    }

    public boolean isArginVoid() throws DevFailed {
        boolean isArginVoid = true;
        for (int i = 0; i < this.group.get_size(true); ++i) {
            DeviceProxy dev = this.group.get_device(i + 1);
            int arginType = dev.command_query((String)this.commandName).in_type;
            if (arginType == 0) continue;
            isArginVoid = false;
            break;
        }
        return isArginVoid;
    }

    public boolean isArginScalar() throws DevFailed {
        boolean isArginScalar = true;
        for (int i = 0; i < this.group.get_size(true); ++i) {
            DeviceProxy dev = this.group.get_device(i + 1);
            int arginType = dev.command_query((String)this.commandName).in_type;
            isArginScalar = TangoUtil.SCALARS.contains(arginType);
            if (!isArginScalar) break;
        }
        return isArginScalar;
    }

    public boolean isArginSpectrum() throws DevFailed {
        boolean isArginSpectrum = true;
        for (int i = 0; i < this.group.get_size(true); ++i) {
            DeviceProxy dev = this.group.get_device(i + 1);
            int arginType = dev.command_query((String)this.commandName).in_type;
            isArginSpectrum = TangoUtil.SPECTRUMS.contains(arginType);
            if (!isArginSpectrum) break;
        }
        return isArginSpectrum;
    }

    public boolean isArginMixFormat() throws DevFailed {
        boolean isArginMixFormat = false;
        for (int i = 0; i < this.group.get_size(true); ++i) {
            DeviceProxy dev = this.group.get_device(i + 1);
            int arginType = dev.command_query((String)this.commandName).in_type;
            if (arginType != 18 && arginType != 17) continue;
            isArginMixFormat = true;
            break;
        }
        return isArginMixFormat;
    }

    public String toString() {
        ToStringBuilder str = new ToStringBuilder(this);
        str.append("name", this.commandName);
        return str.toString();
    }
}

