/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.soleil.tango.clientapi.factory.InsertExtractFactory;
import fr.soleil.tango.clientapi.util.TypeConversionUtil;
import org.tango.utils.DevFailedUtils;

public final class InsertExtractUtils {
    private static final String ERROR_MSG_DA = "cannot insert/extract a null DeviceAttribute";
    private static final String ERROR_MSG_DD = "cannot insert/extract a null DeviceData";

    private InsertExtractUtils() {
    }

    public static Object extract(DeviceAttribute da) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return InsertExtractFactory.getAttributeExtractor(da.getType()).extract(da);
    }

    public static Object extractRead(DeviceAttribute da, AttrDataFormat format) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return InsertExtractFactory.getAttributeExtractor(da.getType()).extractRead(da, format);
    }

    public static Object extractReadArray(DeviceAttribute da, AttrDataFormat format) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return InsertExtractFactory.getAttributeExtractor(da.getType()).extractReadArray(da, format);
    }

    public static Object extractWrite(DeviceAttribute da, AttrWriteType writeType, AttrDataFormat format) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return InsertExtractFactory.getAttributeExtractor(da.getType()).extractWrite(da, writeType, format);
    }

    public static Object extractWriteArray(DeviceAttribute da, AttrWriteType writeType, AttrDataFormat format) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return InsertExtractFactory.getAttributeExtractor(da.getType()).extractWriteArray(da, writeType, format);
    }

    public static <T> T extract(DeviceAttribute da, Class<T> type) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return TypeConversionUtil.castToType(type, InsertExtractUtils.extract(da));
    }

    public static <T> T extractRead(DeviceAttribute da, AttrDataFormat format, Class<T> type) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return TypeConversionUtil.castToType(type, InsertExtractUtils.extractRead(da, format));
    }

    public static <T> T extractReadArray(DeviceAttribute da, AttrDataFormat format, Class<T> type) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return TypeConversionUtil.castToType(type, InsertExtractUtils.extractReadArray(da, format));
    }

    public static <T> T extractWrite(DeviceAttribute da, AttrDataFormat format, AttrWriteType writeType, Class<T> type) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return TypeConversionUtil.castToType(type, InsertExtractUtils.extractWrite(da, writeType, format));
    }

    public static <T> T extractWriteArray(DeviceAttribute da, AttrWriteType writeType, AttrDataFormat format, Class<T> type) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        return TypeConversionUtil.castToType(type, InsertExtractUtils.extractWriteArray(da, writeType, format));
    }

    public static Object extract(DeviceData dd) throws DevFailed {
        if (dd == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DD);
        }
        return InsertExtractFactory.getCommandExtractor(dd.getType()).extract(dd);
    }

    public static <T> T extract(DeviceData dd, Class<T> type) throws DevFailed {
        if (dd == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DD);
        }
        Object r = InsertExtractUtils.extract(dd);
        return TypeConversionUtil.castToType(type, r);
    }

    public static void insert(DeviceAttribute da, Object value) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        InsertExtractFactory.getAttributeInserter(da.getType()).insert(da, value);
    }

    public static void insert(DeviceAttribute da, Object value, int dimX, int dimY) throws DevFailed {
        if (da == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DA);
        }
        InsertExtractFactory.getAttributeInserter(da.getType()).insert(da, value, dimX, dimY);
    }

    public static void insert(DeviceData dd, int dataType, Object value) throws DevFailed {
        if (dd == null) {
            DevFailedUtils.throwDevFailed(ERROR_MSG_DD);
        }
        InsertExtractFactory.getCommandInserter(dataType).insert(dd, value);
    }
}

