/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.attributecomposer;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.QualityUtilities;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PriorityQualityManager {
    private final Map<AttrQuality, Integer> qualityPriorityMap = new HashMap<AttrQuality, Integer>();
    private final Map<AttrQuality, DevState> qualityStateMap = new HashMap<AttrQuality, DevState>();
    private final Map<String, AttrQuality> attributeQualityMap = new LinkedHashMap<String, AttrQuality>();

    public PriorityQualityManager() {
        this.qualityStateMap.put(AttrQuality.ATTR_CHANGING, DevState.MOVING);
        this.qualityStateMap.put(AttrQuality.ATTR_ALARM, DevState.ALARM);
        this.qualityStateMap.put(AttrQuality.ATTR_WARNING, DevState.ALARM);
        this.qualityStateMap.put(AttrQuality.ATTR_INVALID, DevState.FAULT);
        this.qualityStateMap.put(AttrQuality.ATTR_VALID, DevState.ON);
        this.qualityPriorityMap.put(AttrQuality.ATTR_VALID, 0);
        this.qualityPriorityMap.put(AttrQuality.ATTR_CHANGING, 0);
        this.qualityPriorityMap.put(AttrQuality.ATTR_WARNING, 0);
        this.qualityPriorityMap.put(AttrQuality.ATTR_ALARM, 0);
        this.qualityPriorityMap.put(AttrQuality.ATTR_INVALID, 0);
    }

    public void putQualityPriority(AttrQuality quality, int priority) {
        this.qualityPriorityMap.put(quality, priority);
    }

    public void putAttributeQuality(String attributeName, AttrQuality quality) {
        this.attributeQualityMap.put(attributeName, quality);
    }

    public AttrQuality getHighestPriorityQuality() {
        AttrQuality highestPriorityQuality = null;
        for (Map.Entry<String, AttrQuality> entry : this.attributeQualityMap.entrySet()) {
            int currentPriority = this.qualityPriorityMap.get(entry.getValue());
            if (highestPriorityQuality != null) {
                int highestPriority = this.qualityPriorityMap.get(highestPriorityQuality);
                if (highestPriority >= currentPriority) continue;
                highestPriorityQuality = entry.getValue();
                continue;
            }
            highestPriorityQuality = entry.getValue();
        }
        return highestPriorityQuality;
    }

    public String getHighestPriorityQualityAsString() {
        return QualityUtilities.getNameForQuality(this.getHighestPriorityQuality());
    }

    public DevState getHighestPriorityState() {
        return this.qualityStateMap.get(this.getHighestPriorityQuality());
    }

    public AttrQuality getQualityForAttribute(String attributeName) {
        return this.attributeQualityMap.get(attributeName);
    }

    public int getPriorityForQuality(AttrQuality quality) {
        return this.qualityPriorityMap.get(quality);
    }

    public int getPriorityForQuality(String quality) {
        AttrQuality attrQuality = QualityUtilities.getQualityForName(quality);
        return this.qualityPriorityMap.get(attrQuality);
    }

    public String[] getQualityArray() {
        String[] array = new String[this.attributeQualityMap.size()];
        int i = 0;
        for (Map.Entry<String, AttrQuality> entry : this.attributeQualityMap.entrySet()) {
            String attrName = entry.getKey();
            AttrQuality quality = entry.getValue();
            array[i++] = attrName + " - " + QualityUtilities.getNameForQuality(quality);
        }
        return array;
    }

    public short[] getQualityNumberArray() {
        short[] array = new short[this.attributeQualityMap.size()];
        int i = 0;
        for (Map.Entry<String, AttrQuality> entry : this.attributeQualityMap.entrySet()) {
            AttrQuality quality = entry.getValue();
            array[i++] = (short)this.getPriorityForQuality(quality);
        }
        return array;
    }
}

