/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.utils;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class ArrayUtils {
    public static final Map<Class<?>, Class<?>> OBJ_TO_PRIMITIVE = new HashMap();

    private ArrayUtils() {
    }

    public static Object toPrimitiveArray(Object array, Class<?> source) {
        if (!array.getClass().isArray()) {
            return array;
        }
        Class<?> clazz = OBJ_TO_PRIMITIVE.get(source);
        return ArrayUtils.setArray(clazz, array);
    }

    private static final Object setArray(Class<?> clazz, Object array) {
        Object result = array;
        if (clazz != null) {
            int length = Array.getLength(array);
            result = Array.newInstance(clazz, length);
            for (int i = 0; i < length; ++i) {
                Array.set(result, i, Array.get(array, i));
            }
        }
        return result;
    }

    static {
        OBJ_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        OBJ_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        OBJ_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        OBJ_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        OBJ_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        OBJ_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        OBJ_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        OBJ_TO_PRIMITIVE.put(Double.class, Double.TYPE);
    }
}

