/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;

public class EventQueue {
    private int max_size = 1000000;
    private ArrayList<EventData> events = new ArrayList();

    public EventQueue() {
    }

    public EventQueue(int max_size) {
        this.max_size = max_size;
    }

    public synchronized boolean is_empty() {
        return this.events.size() == 0;
    }

    public synchronized int size(int event_type) {
        int cnt = 0;
        for (EventData event : this.events) {
            if (event.event_type != event_type) continue;
            ++cnt;
        }
        return cnt;
    }

    public synchronized int size() {
        return this.events.size();
    }

    public synchronized void insert_event(EventData event) {
        this.events.add(event);
        while (this.events.size() > this.max_size) {
            this.events.remove(0);
        }
    }

    public synchronized EventData getNextEvent() throws DevFailed {
        if (this.events.size() == 0) {
            Except.throw_exception("BUFFER_EMPTY", "Event queue is empty.", "EventQueue.getNextEvent()");
        }
        EventData ev_data = this.events.get(0);
        this.events.remove(0);
        return ev_data;
    }

    public synchronized EventData getNextEvent(int event_type) throws DevFailed {
        EventData ev_data = null;
        for (EventData event : this.events) {
            if (event.event_type != event_type) continue;
            ev_data = event;
        }
        if (ev_data == null) {
            Except.throw_exception("BUFFER_EMPTY", "No " + TangoConst.eventNames[event_type] + " in event queue.", "EventQueue.getNextEvent()");
        }
        this.events.remove(ev_data);
        return ev_data;
    }

    public synchronized EventData[] getEvents() {
        EventData[] ev_data = new EventData[this.events.size()];
        for (int i = 0; i < this.events.size(); ++i) {
            ev_data[i] = this.events.get(i);
        }
        this.events.clear();
        return ev_data;
    }

    public synchronized EventData[] getEvents(int event_type) {
        ArrayList<EventData> v = new ArrayList<EventData>();
        for (EventData event : this.events) {
            if (event.event_type != event_type) continue;
            v.add(event);
        }
        EventData[] periodic = new EventData[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            periodic[i] = (EventData)v.get(i);
            this.events.remove(v.get(i));
        }
        return periodic;
    }

    public synchronized long getLastEventDate() throws DevFailed {
        if (this.events.size() == 0) {
            Except.throw_exception("BUFFER_EMPTY", "Event queue is empty.", "EventQueu.getNextEvent()");
        }
        EventData event = this.events.get(this.events.size() - 1);
        return event.date;
    }
}

