/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.TacoApi.TacoCommand;
import fr.esrf.TacoApi.TacoConst;
import fr.esrf.TacoApi.TacoData;
import fr.esrf.TacoApi.TacoDevice;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.ITacoTangoDeviceDAO;
import fr.esrf.TangoApi.TacoTangoDevice;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.StringTokenizer;
import java.util.Vector;

public class TacoTangoDeviceDAODefaultImpl
implements ITacoTangoDeviceDAO,
TangoConst,
TacoConst {
    @Override
    public void init(TacoTangoDevice tacoTangoDevice, String string, String string2) throws DevFailed {
        if (string2 != null && string2.length() > 0) {
            string = "//" + string2 + "/" + string;
        }
        try {
            tacoTangoDevice.setTacoProxy(new TacoDevice(string));
            tacoTangoDevice.setDevName(string);
            this.set_source(tacoTangoDevice, DevSource.CACHE_DEV);
            this.set_rpc_protocol(tacoTangoDevice, 1);
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDeviceDAODefaultImpl.TacoTangoDeviceDAODefaultImpl(" + string + ")");
        }
    }

    @Override
    public DeviceData command_inout(TacoTangoDevice tacoTangoDevice, String string, DeviceData deviceData) throws DevFailed {
        DeviceData deviceData2 = null;
        TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
        try {
            TacoData tacoData = this.dataToTaco(deviceData);
            TacoData tacoData2 = tacoDevice.putGet(tacoDevice.getCommandCode(string), tacoData);
            deviceData2 = this.dataToTango(tacoData2);
        }
        catch (TacoException tacoException) {
            String string2 = tacoException.getErrorString();
            if (string2.startsWith("Device command") && string2.indexOf("not found for this device") > 0) {
                Except.throw_exception("TACO_CMD_UNAVAILABLE", string2, "TacoTangoDeviceDAODefaultImpl.command_inout() for " + tacoTangoDevice.getDevName());
            }
            Except.throw_exception("Api_TacoFailed", string2, "TacoTangoDeviceDAODefaultImpl.command_inout() for " + tacoTangoDevice.getDevName());
        }
        return deviceData2;
    }

    @Override
    public CommandInfo[] commandListQuery(TacoTangoDevice tacoTangoDevice) throws DevFailed {
        CommandInfo[] commandInfoArray = null;
        try {
            TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
            TacoCommand[] tacoCommandArray = tacoDevice.commandQuery();
            commandInfoArray = this.dataToTango(tacoCommandArray);
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDeviceDAODefaultImpl.commandListQuery() for " + tacoTangoDevice.getDevName());
        }
        return commandInfoArray;
    }

    @Override
    public CommandInfo commandQuery(TacoTangoDevice tacoTangoDevice, String string) throws DevFailed {
        CommandInfo commandInfo = null;
        CommandInfo[] commandInfoArray = this.commandListQuery(tacoTangoDevice);
        for (int i = 0; i < commandInfoArray.length && commandInfo == null; ++i) {
            if (!commandInfoArray[i].cmd_name.equals(string)) continue;
            commandInfo = commandInfoArray[i];
        }
        if (commandInfo == null) {
            Except.throw_exception("Api_TacoFailed", "Command '" + string + "' Not Found", "TacoTangoDeviceDAODefaultImpl.commandQuery() for " + tacoTangoDevice.getDevName());
        }
        return commandInfo;
    }

    @Override
    public void set_rpc_protocol(TacoTangoDevice tacoTangoDevice, int n) throws DevFailed {
        if (n != 0 && n != 1) {
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Bad parameter for dev_rpc_protocol command", "TacoTangoDeviceDAODefaultImpl.dev_rpc_protocol()");
        }
        try {
            TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
            tacoDevice.setProtocol(n);
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDeviceDAODefaultImpl.commandListQuery() for " + tacoTangoDevice.getDevName());
        }
    }

    @Override
    public int get_rpc_protocol(TacoTangoDevice tacoTangoDevice) throws DevFailed {
        TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
        return tacoDevice.getProtocol();
    }

    @Override
    public int get_rpc_timeout(TacoTangoDevice tacoTangoDevice) throws DevFailed {
        TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
        return tacoDevice.getTimeout();
    }

    @Override
    public void set_rpc_timeout(TacoTangoDevice tacoTangoDevice, int n) throws DevFailed {
        TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
        tacoDevice.setTimeout(n);
    }

    @Override
    public String[] dev_inform(TacoTangoDevice tacoTangoDevice) throws DevFailed {
        TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
        return this.infoToTango(tacoTangoDevice, tacoDevice.getInfo());
    }

    @Override
    public DbDatum[] get_property(TacoTangoDevice tacoTangoDevice, String[] stringArray) throws DevFailed {
        DbDatum[] dbDatumArray = new DbDatum[stringArray.length];
        try {
            TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
            for (int i = 0; i < stringArray.length; ++i) {
                dbDatumArray[i] = new DbDatum(stringArray[i]);
                String[] stringArray2 = tacoDevice.getResource(stringArray[i]);
                if (stringArray2.length <= 0) continue;
                dbDatumArray[i].insert(stringArray2);
            }
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDeviceDAODefaultImpl.get_property() for " + tacoTangoDevice.getDevName());
        }
        return dbDatumArray;
    }

    @Override
    public void set_source(TacoTangoDevice tacoTangoDevice, DevSource devSource) throws DevFailed {
        try {
            TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
            if (devSource == DevSource.DEV) {
                tacoDevice.setSource(0);
            } else if (devSource == DevSource.CACHE_DEV) {
                tacoDevice.setSource(2);
            } else if (devSource == DevSource.CACHE) {
                tacoDevice.setSource(1);
            }
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDeviceDAODefaultImpl.set_source() for " + tacoTangoDevice.getDevName());
        }
    }

    @Override
    public DevSource get_source(TacoTangoDevice tacoTangoDevice) {
        DevSource devSource = DevSource.DEV;
        TacoDevice tacoDevice = (TacoDevice)tacoTangoDevice.getTacoProxy();
        switch (tacoDevice.getSource()) {
            case 0: {
                devSource = DevSource.DEV;
                break;
            }
            case 2: {
                devSource = DevSource.CACHE_DEV;
                break;
            }
            case 1: {
                devSource = DevSource.CACHE;
            }
        }
        return devSource;
    }

    private String onlyAttName(String string) throws DevFailed {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if ((n = string.indexOf(47, n)) < 0) {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute name not found in " + string, "TacoTangoDeviceDAODefaultImpl.onlyAttName()");
            }
            ++n2;
            ++n;
        }
        return string.substring(n).trim();
    }

    private String fullName(String string, String string2) {
        String string3 = string + "/" + string2;
        if (string3.startsWith("//")) {
            return string3.substring(string3.indexOf(47, 2) + 1);
        }
        return string3;
    }

    @Override
    public String[] get_attribute_list(TacoTangoDevice tacoTangoDevice) throws DevFailed {
        if (tacoTangoDevice.getAttrConfig() == null) {
            this.initializeAttributeConfig(tacoTangoDevice);
        }
        AttributeConfig[] attributeConfigArray = tacoTangoDevice.getAttrConfig();
        String[] stringArray = new String[attributeConfigArray.length];
        for (int i = 0; i < attributeConfigArray.length; ++i) {
            stringArray[i] = attributeConfigArray[i].name;
        }
        return stringArray;
    }

    @Override
    public AttributeConfig[] get_attribute_config(TacoTangoDevice tacoTangoDevice, String[] stringArray) throws DevFailed {
        if (tacoTangoDevice.getAttrConfig() == null) {
            this.initializeAttributeConfig(tacoTangoDevice);
        }
        if (stringArray[0].equals("All attributes")) {
            return tacoTangoDevice.getAttrConfig();
        }
        AttributeConfig[] attributeConfigArray = new AttributeConfig[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (AttributeConfig attributeConfig : tacoTangoDevice.getAttrConfig()) {
                if (!attributeConfig.name.equalsIgnoreCase(stringArray[i])) continue;
                attributeConfigArray[i] = attributeConfig;
            }
        }
        if (attributeConfigArray[0] == null) {
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute " + stringArray[0] + " not found !", "TacoTangoDeviceDAODefaultImpl.get_attribute_config() for " + tacoTangoDevice.getDevName());
        }
        return attributeConfigArray;
    }

    @Override
    public DeviceAttribute[] read_attribute(TacoTangoDevice tacoTangoDevice, String[] stringArray) throws DevFailed {
        if (tacoTangoDevice.getAttrConfig() == null) {
            this.initializeAttributeConfig(tacoTangoDevice);
        }
        DeviceData deviceData = this.command_inout(tacoTangoDevice, "DevReadSigValues", null);
        CommandInfo commandInfo = this.commandQuery(tacoTangoDevice, "DevReadSigValues");
        int n = commandInfo.out_type;
        int[] nArray = null;
        float[] fArray = null;
        double[] dArray = null;
        switch (n) {
            case 11: {
                nArray = deviceData.extractLongArray();
                break;
            }
            case 12: {
                fArray = deviceData.extractFloatArray();
                break;
            }
            case 13: {
                dArray = deviceData.extractDoubleArray();
            }
        }
        DeviceAttribute[] deviceAttributeArray = new DeviceAttribute[stringArray.length];
        block10: for (int i = 0; i < stringArray.length; ++i) {
            int n2 = -1;
            AttributeConfig[] attributeConfigArray = tacoTangoDevice.getAttrConfig();
            for (int j = 0; j < attributeConfigArray.length; ++j) {
                if (!attributeConfigArray[j].name.equalsIgnoreCase(stringArray[i])) continue;
                n2 = j;
            }
            if (n2 == -1) {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute " + stringArray[i] + " not found for this device", "TacoTangoDeviceDAODefaultImpl.read_attribute()  for " + tacoTangoDevice.getDevName());
            }
            switch (n) {
                case 11: {
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], nArray[n2]);
                    continue block10;
                }
                case 12: {
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], fArray[n2]);
                    continue block10;
                }
                case 13: {
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], dArray[n2]);
                }
            }
        }
        return deviceAttributeArray;
    }

    private void initializeAttributeConfig(TacoTangoDevice tacoTangoDevice) throws DevFailed {
        int n;
        int n2;
        String[] stringArray;
        String[] stringArray2;
        int n3 = 1;
        int n4 = 0;
        try {
            DeviceData deviceData = this.command_inout(tacoTangoDevice, "DevGetSigConfig", null);
            stringArray2 = deviceData.extractStringArray();
            stringArray = this.commandQuery(tacoTangoDevice, "DevReadSigValues");
            n2 = this.getAttrDataType(stringArray.out_type);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("TACO_CMD_UNAVAILABLE")) {
                tacoTangoDevice.setAttrConfig(new AttributeConfig[0]);
                return;
            }
            throw devFailed;
        }
        int n5 = Integer.parseInt(stringArray2[0]);
        tacoTangoDevice.setAttrConfig(new AttributeConfig[stringArray2.length / n5]);
        stringArray = new String[stringArray2.length / n5];
        int n6 = 0;
        for (n = 1; n < stringArray2.length; n += n5) {
            stringArray[n6++] = this.onlyAttName(stringArray2[n]);
        }
        tacoTangoDevice.setAttrConfig(new AttributeConfig[stringArray.length]);
        AttributeConfig[] attributeConfigArray = tacoTangoDevice.getAttrConfig();
        for (n = 0; n < stringArray.length; ++n) {
            String string = this.fullName(tacoTangoDevice.getDevName(), stringArray[n]);
            boolean bl = false;
            for (int i = 1; i < stringArray2.length; i += n5) {
                if (!stringArray2[i].equalsIgnoreCase(string)) continue;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                String string11 = "";
                String string12 = "";
                String[] stringArray3 = null;
                bl = true;
                String string13 = "No Description";
                if (!stringArray2[i + 4].equals(string13)) {
                    string2 = stringArray2[i + 4];
                }
                if (!stringArray2[i + 1].equals(string13 = "Not specified")) {
                    string3 = stringArray2[i + 1];
                }
                if (!stringArray2[i + 2].equals(string13)) {
                    string4 = stringArray2[i + 2];
                    string6 = stringArray2[i + 2];
                }
                if (!stringArray2[i + 3].equals(string13)) {
                    string7 = stringArray2[i + 3];
                }
                if (!stringArray2[i + 5].equals(string13)) {
                    string9 = stringArray2[i + 5];
                }
                if (!stringArray2[i + 6].equals(string13)) {
                    string8 = stringArray2[i + 6];
                }
                if (!stringArray2[i + 7].equals(string13)) {
                    string11 = stringArray2[i + 7];
                }
                if (!stringArray2[i + 8].equals(string13)) {
                    string10 = stringArray2[i + 8];
                }
                attributeConfigArray[n] = new AttributeConfig(stringArray[n], AttrWriteType.READ, AttrDataFormat.SCALAR, n2, n3, n4, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, stringArray3);
            }
            if (bl) continue;
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute name not found for this device", "TacoTangoDeviceDAODefaultImpl.initializeAttributeConfig()");
        }
    }

    private int getAttrDataType(int n) throws DevFailed {
        int n2 = 0;
        switch (n) {
            case 11: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 4;
                break;
            }
            case 13: {
                n2 = 5;
                break;
            }
            default: {
                try {
                    Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Output parameter not supported.", "TacoTangoDeviceDAODefaultImpl.getAttrDataType()");
                    break;
                }
                catch (DevFailed devFailed) {
                    devFailed.printStackTrace();
                    throw devFailed;
                }
            }
        }
        return n2;
    }

    @Override
    public int tangoType(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 70: {
                n2 = 6;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 71: {
                n2 = 7;
                break;
            }
            case 6: {
                n2 = 8;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 10: {
                n2 = 10;
                break;
            }
            case 72: {
                n2 = 14;
                break;
            }
            case 11: {
                n2 = 11;
                break;
            }
            case 69: {
                n2 = 15;
                break;
            }
            case 12: {
                n2 = 12;
                break;
            }
            case 68: {
                n2 = 13;
                break;
            }
            case 24: {
                n2 = 16;
                break;
            }
            case 8: {
                n2 = 12;
            }
        }
        return n2;
    }

    private TacoData dataToTaco(DeviceData deviceData) throws DevFailed {
        TacoData tacoData = new TacoData();
        if (deviceData == null) {
            return tacoData;
        }
        int n = deviceData.getType();
        switch (n) {
            case -1: 
            case 0: {
                break;
            }
            case 2: {
                tacoData.insert(deviceData.extractShort());
                break;
            }
            case 10: {
                tacoData.insert(deviceData.extractShortArray());
                break;
            }
            case 6: {
                tacoData.insertUShort(deviceData.extractUShort());
                break;
            }
            case 14: {
                tacoData.insertUShortArray(deviceData.extractUShortArray());
                break;
            }
            case 3: {
                tacoData.insert(deviceData.extractLong());
                break;
            }
            case 11: {
                tacoData.insert(deviceData.extractLongArray());
                break;
            }
            case 7: {
                tacoData.insertULong((long)deviceData.extractLong());
                break;
            }
            case 15: {
                break;
            }
            case 4: {
                tacoData.insert(deviceData.extractFloat());
                break;
            }
            case 12: {
                tacoData.insert(deviceData.extractFloatArray());
                break;
            }
            case 13: {
                tacoData.insert(deviceData.extractDouble());
                break;
            }
            case 5: {
                tacoData.insert(deviceData.extractDoubleArray());
                break;
            }
            case 8: {
                tacoData.insert(deviceData.extractString());
                break;
            }
            case 16: {
                tacoData.insert(deviceData.extractStringArray());
                break;
            }
            default: {
                Except.throw_exception("Api_TacoFailed", "Argument type " + Tango_CmdArgTypeName[n] + "Not supported for TACO interface", "TacoTangoDeviceDAODefaultImpl.dataToTaco()");
            }
        }
        return tacoData;
    }

    private DeviceData dataToTango(TacoData tacoData) throws DevFailed {
        int n = tacoData.getType();
        DeviceData deviceData = new DeviceData();
        try {
            switch (n) {
                case -1: 
                case 0: {
                    break;
                }
                case 2: {
                    deviceData.insert(tacoData.extractShort());
                    break;
                }
                case 70: {
                    deviceData.insert_us(tacoData.extractUShort());
                    break;
                }
                case 3: {
                    deviceData.insert(tacoData.extractLong());
                    break;
                }
                case 71: {
                    deviceData.insert_ul(tacoData.extractULong());
                    break;
                }
                case 6: {
                    deviceData.insert(tacoData.extractString());
                    break;
                }
                case 4: {
                    deviceData.insert(tacoData.extractFloat());
                    break;
                }
                case 5: {
                    deviceData.insert(tacoData.extractDouble());
                    break;
                }
                case 10: {
                    deviceData.insert(tacoData.extractShortArray());
                    break;
                }
                case 72: {
                    deviceData.insert_us(tacoData.extractUShortArray());
                    break;
                }
                case 11: {
                    deviceData.insert(tacoData.extractLongArray());
                    break;
                }
                case 69: {
                    deviceData.insert_ul(tacoData.extractULongArray());
                    break;
                }
                case 12: {
                    deviceData.insert(tacoData.extractFloatArray());
                    break;
                }
                case 68: {
                    deviceData.insert(tacoData.extractDoubleArray());
                    break;
                }
                case 24: {
                    deviceData.insert(tacoData.extractStringArray());
                    break;
                }
                case 8: {
                    float[] fArray = new float[3];
                    float[] fArray2 = tacoData.extractStateFloatReadPoint();
                    fArray[0] = tacoData.extractStateofSFR();
                    fArray[1] = fArray2[0];
                    fArray[2] = fArray2[1];
                    deviceData.insert(fArray);
                }
            }
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDeviceDAODefaultImpl.dataToTango()");
        }
        return deviceData;
    }

    private CommandInfo[] dataToTango(TacoCommand[] tacoCommandArray) {
        CommandInfo[] commandInfoArray = new CommandInfo[tacoCommandArray.length];
        for (int i = 0; i < tacoCommandArray.length; ++i) {
            commandInfoArray[i] = new CommandInfo(tacoCommandArray[i].cmdName, 0, this.tangoType(tacoCommandArray[i].inType), this.tangoType(tacoCommandArray[i].outType), tacoCommandArray[i].inName, tacoCommandArray[i].outName);
        }
        return commandInfoArray;
    }

    @Override
    public String[] infoToTango(TacoTangoDevice tacoTangoDevice, String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        if (vector.size() == 1) {
            stringArray[0] = (String)vector.elementAt(0);
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)vector.get(i);
                int n = string2.indexOf(":");
                stringArray[i] = n > 0 ? string2.substring(n + 1).trim() : string2;
            }
        }
        return stringArray;
    }
}

