/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class HostInfo {
    private static String name = null;
    private static String address = null;
    private static Vector<String> addresses = new Vector();

    private HostInfo() throws DevFailed {
        String env = System.getenv("TraceAddresses");
        boolean trace = env != null && env.equals("true");
        try {
            Enumeration<NetworkInterface> enet = NetworkInterface.getNetworkInterfaces();
            while (enet.hasMoreElements()) {
                NetworkInterface net = enet.nextElement();
                if (net.isLoopback()) continue;
                Enumeration<InetAddress> eaddr = net.getInetAddresses();
                if (trace) {
                    System.out.println("----------------- " + net.getName() + " --------------------");
                }
                while (eaddr.hasMoreElements()) {
                    InetAddress inetAddress = eaddr.nextElement();
                    if (trace) {
                        System.out.println("getCanonicalHostName(): " + inetAddress.getCanonicalHostName());
                        System.out.println("getHostName():          " + inetAddress.getHostName());
                        System.out.println("getHostAddress():       " + inetAddress.getHostAddress());
                    }
                    this.checkInetAddress(inetAddress);
                }
            }
        }
        catch (SocketException e) {
            System.err.println(e.toString());
            Except.throw_exception("TangoApi_SockectException", e.toString(), "HostInfo.HostInfo()");
        }
        if (name == null || address == null) {
            System.err.println("Host name/address cannot be determined !");
            Except.throw_exception("TangoApi_NetworkSystemException", "Host name/address cannot be determined !", "HostInfo.HostInfo()");
        }
    }

    private boolean checkInetAddress(InetAddress inetAddress) {
        if (!inetAddress.getCanonicalHostName().startsWith("local") && !inetAddress.getCanonicalHostName().equalsIgnoreCase(inetAddress.getHostAddress())) {
            addresses.add(inetAddress.getHostAddress());
            if (this.isIPV4adress(inetAddress.getHostAddress())) {
                name = inetAddress.getCanonicalHostName();
                address = inetAddress.getHostAddress();
                return true;
            }
        }
        return false;
    }

    private boolean isIPV4adress(String address) {
        StringTokenizer st = new StringTokenizer(address, ".");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.size() == 4;
    }

    static String getName() throws DevFailed {
        if (name == null) {
            new HostInfo();
        }
        return name;
    }

    static String getAddress() throws DevFailed {
        if (address == null) {
            new HostInfo();
        }
        return address;
    }

    static Vector<String> getAddresses() throws DevFailed {
        if (address == null) {
            new HostInfo();
        }
        return addresses;
    }

    private static String toStaticString() {
        String str = "";
        try {
            if (name == null) {
                new HostInfo();
            }
            str = str + "name:          " + name + "\n";
            str = str + "address:       " + address + "\n";
        }
        catch (DevFailed e) {
            str = e.errors[0].desc;
        }
        return str;
    }

    public static void main(String[] args) {
        System.out.println(HostInfo.toStaticString());
    }
}

