/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceProxy;

public class DeviceInterface {
    public AttributeInfoEx[] attributeInfoList;
    public CommandInfo[] commandInfoList;
    public boolean deviceStarted;

    public DeviceInterface(String deviceName) throws DevFailed {
        this(new DeviceProxy(deviceName));
    }

    public DeviceInterface(DeviceProxy deviceProxy) throws DevFailed {
        this.attributeInfoList = deviceProxy.get_attribute_info_ex();
        this.commandInfoList = deviceProxy.command_list_query();
        this.deviceStarted = false;
    }

    public DeviceInterface(boolean deviceStarted, CommandInfo[] commandInfoList, AttributeInfoEx[] attributeInfoList) {
        this.deviceStarted = deviceStarted;
        this.commandInfoList = commandInfoList;
        this.attributeInfoList = attributeInfoList;
    }

    public DeviceInterface(DevIntrChange interfaceChange) {
        int i;
        this.deviceStarted = interfaceChange.dev_started;
        this.commandInfoList = new CommandInfo[interfaceChange.cmds.length];
        for (i = 0; i < interfaceChange.cmds.length; ++i) {
            this.commandInfoList[i] = new CommandInfo(interfaceChange.cmds[i]);
        }
        this.attributeInfoList = new AttributeInfoEx[interfaceChange.atts.length];
        for (i = 0; i < interfaceChange.atts.length; ++i) {
            this.attributeInfoList[i] = new AttributeInfoEx(interfaceChange.atts[i]);
        }
    }

    public int getAttributeNumber() {
        return this.attributeInfoList.length;
    }

    public int getCommandNumber() {
        return this.commandInfoList.length;
    }

    public AttributeInfoEx[] getAttributeInfoList() {
        return this.attributeInfoList;
    }

    public AttributeInfoEx getAttributeInfo(int index) {
        return this.attributeInfoList[index];
    }

    public AttributeInfoEx getAttributeInfo(String attributeName) {
        for (AttributeInfoEx attributeInfoEx : this.attributeInfoList) {
            if (!attributeInfoEx.name.toLowerCase().equals(attributeName.toLowerCase())) continue;
            return attributeInfoEx;
        }
        return null;
    }

    public CommandInfo[] getCommandInfoList() {
        return this.commandInfoList;
    }

    public CommandInfo getCommandInfo(int index) {
        return this.commandInfoList[index];
    }

    public CommandInfo getCommandInfo(String commandName) {
        for (CommandInfo commandInfo : this.commandInfoList) {
            if (!commandInfo.cmd_name.toLowerCase().equals(commandName.toLowerCase())) continue;
            return commandInfo;
        }
        return null;
    }

    public boolean changeIsSure() {
        return this.deviceStarted;
    }
}

