/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;

public class DeviceInfo
extends DbDevImportInfo
implements Serializable {
    public String last_exported;
    public String last_unexported;

    public DeviceInfo(DevVarLongStringArray info) {
        this.name = info.svalue[0];
        this.ior = info.svalue[1];
        this.version = info.svalue[2];
        boolean bl = this.exported = info.lvalue[0] == 1;
        if (info.lvalue.length > 1) {
            this.pid = info.lvalue[1];
        }
        if (info.svalue.length > 3) {
            this.server = info.svalue[3];
        }
        if (info.svalue.length > 4) {
            this.hostname = info.svalue[4];
        }
        if (info.svalue.length > 5) {
            this.last_exported = info.svalue[5];
            this.last_unexported = info.svalue[6];
        }
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result + "\nlast_exported:   " + this.last_exported;
        result = result + "\nlast_unexported: " + this.last_unexported;
        return result;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Device name ?");
            System.exit(0);
        }
        try {
            String devname = args[0];
            Database db = ApiUtil.get_db_obj();
            DeviceInfo info = db.get_device_info(devname);
            System.out.println(info);
        }
        catch (DevFailed e) {
            if (args.length < 2 || !args[1].equals("-no_exception")) {
                Except.print_exception(e);
            }
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

