/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrValUnion;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceAttribute_3;
import fr.esrf.TangoApi.DeviceAttribute_3DAODefaultImpl;
import fr.esrf.TangoApi.IDeviceAttributeDAO;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.BAD_PARAM;

public class DeviceAttributeDAODefaultImpl
implements IDeviceAttributeDAO {
    private AttributeValue_5 attributeValue_5 = new AttributeValue_5();
    private DeviceAttribute_3 deviceAttribute_3 = null;
    private boolean use_union = true;

    private void buildAttributeValueObject(String name) {
        this.attributeValue_5.name = name;
        this.attributeValue_5.quality = AttrQuality.ATTR_VALID;
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.time = new TimeVal();
        this.attributeValue_5.r_dim = new AttributeDim();
        this.attributeValue_5.w_dim = new AttributeDim();
        this.attributeValue_5.r_dim.dim_x = 1;
        this.attributeValue_5.r_dim.dim_y = 0;
        this.attributeValue_5.w_dim.dim_x = 0;
        this.attributeValue_5.w_dim.dim_y = 0;
        this.attributeValue_5.value = new AttrValUnion();
        long now = System.currentTimeMillis();
        this.attributeValue_5.time.tv_sec = (int)(now / 1000L);
        this.attributeValue_5.time.tv_usec = (int)(now - (long)(this.attributeValue_5.time.tv_sec * 1000)) * 1000;
        this.attributeValue_5.time.tv_nsec = 0;
        this.attributeValue_5.err_list = new DevError[0];
    }

    @Override
    public void init(AttributeValue_5 attributeValue_5) {
        this.attributeValue_5 = attributeValue_5;
    }

    @Override
    public void init(AttributeValue_4 attributeValue_4) {
        this.setAttributeValue(attributeValue_4);
    }

    @Override
    public void init(AttributeValue_3 attributeValue_3) {
        this.setAttributeValue(attributeValue_3);
    }

    @Override
    public void init(AttributeValue attributeValue) {
        this.setAttributeValue(attributeValue);
    }

    @Override
    public void init(String name) {
        this.buildAttributeValueObject(name);
    }

    @Override
    public void init(String name, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.attributeValue_5.r_dim.dim_x = dim_x;
        this.attributeValue_5.r_dim.dim_y = dim_y;
    }

    @Override
    public void init(String name, boolean value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    @Override
    public void init(String name, DevState value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    @Override
    public void init(String name, boolean[] value, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(value, dim_x, dim_y);
    }

    @Override
    public void init(String name, byte value) {
        this.buildAttributeValueObject(name);
        this.insert_uc(value);
    }

    @Override
    public void init(String name, byte[] value, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert_uc(value, dim_x, dim_y);
    }

    @Override
    public void init(String name, short value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    @Override
    public void init(String name, short[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    @Override
    public void init(String name, int value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    @Override
    public void init(String name, int[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    @Override
    public void init(String name, long value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    @Override
    public void init(String name, long[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    @Override
    public void init(String name, float value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    @Override
    public void init(String name, float[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    @Override
    public void init(String name, double value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    @Override
    public void init(String name, double[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    @Override
    public void init(String name, String value) {
        this.buildAttributeValueObject(name);
        this.insert(value);
    }

    @Override
    public void init(String name, String[] values, int dim_x, int dim_y) {
        this.buildAttributeValueObject(name);
        this.insert(values, dim_x, dim_y);
    }

    @Override
    public boolean hasFailed() {
        return this.attributeValue_5.err_list != null && this.attributeValue_5.err_list.length > 0;
    }

    @Override
    public DevError[] getErrStack() {
        return this.attributeValue_5.err_list;
    }

    public void setAttributeValue(AttributeValue_4 attributeValue_4) {
        this.use_union = true;
        this.attributeValue_5.name = attributeValue_4.name;
        this.attributeValue_5.value = attributeValue_4.value;
        this.attributeValue_5.quality = attributeValue_4.quality;
        this.attributeValue_5.time = attributeValue_4.time;
        this.attributeValue_5.r_dim = attributeValue_4.r_dim;
        this.attributeValue_5.w_dim = attributeValue_4.w_dim;
        this.attributeValue_5.err_list = attributeValue_4.err_list;
        this.attributeValue_5.data_format = attributeValue_4.data_format;
    }

    @Override
    public void setAttributeValue(AttributeValue_3 attributeValue_3) {
        this.deviceAttribute_3 = new DeviceAttribute_3(attributeValue_3);
        this.use_union = false;
        this.attributeValue_5.name = attributeValue_3.name;
        this.attributeValue_5.quality = attributeValue_3.quality;
        this.attributeValue_5.time = attributeValue_3.time;
        this.attributeValue_5.r_dim = attributeValue_3.r_dim;
        this.attributeValue_5.w_dim = attributeValue_3.w_dim;
        this.attributeValue_5.err_list = attributeValue_3.err_list;
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
    }

    @Override
    public void setAttributeValue(AttributeValue attributeValue) {
        this.deviceAttribute_3 = new DeviceAttribute_3(attributeValue);
        this.use_union = false;
        this.attributeValue_5.name = attributeValue.name;
        this.attributeValue_5.quality = attributeValue.quality;
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.time = attributeValue.time;
        this.attributeValue_5.r_dim = new AttributeDim();
        this.attributeValue_5.w_dim = new AttributeDim();
        this.attributeValue_5.r_dim.dim_x = attributeValue.dim_x;
        this.attributeValue_5.r_dim.dim_y = attributeValue.dim_y;
        this.attributeValue_5.w_dim.dim_x = 0;
        this.attributeValue_5.w_dim.dim_y = 0;
        this.attributeValue_5.err_list = null;
    }

    @Override
    public AttributeDim getReadAttributeDim() {
        return this.attributeValue_5.r_dim;
    }

    @Override
    public AttributeDim getWriteAttributeDim() {
        return this.attributeValue_5.w_dim;
    }

    @Override
    public void insert(DevState argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        DevState[] values = new DevState[]{argIn};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.state_att_value(values);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(DevState[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.state_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(DevState[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.state_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(boolean argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        boolean[] values = new boolean[]{argIn};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.bool_att_value(values);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(boolean[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.bool_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(boolean[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.bool_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert_uc(byte argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] values = new byte[]{argIn};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.uchar_att_value(values);
        } else {
            this.deviceAttribute_3.insert_uc(argIn);
        }
    }

    @Override
    public void insert_uc(byte[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.uchar_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert_uc(argIn);
        }
    }

    @Override
    public void insert_uc(short argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] values = new byte[]{(byte)(argIn & 0xFF)};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.uchar_att_value(values);
        } else {
            this.deviceAttribute_3.insert_uc(argIn);
        }
    }

    @Override
    public void insert_uc(short[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] values = new byte[argIn.length];
        for (int i = 0; i < argIn.length; ++i) {
            values[i] = (byte)(argIn[i] & 0xFF);
        }
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.uchar_att_value(values);
        } else {
            this.deviceAttribute_3.insert_uc(argIn);
        }
    }

    @Override
    public void insert_uc(short[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        byte[] values = new byte[argIn.length];
        for (int i = 0; i < argIn.length; ++i) {
            values[i] = (byte)(argIn[i] & 0xFF);
        }
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.uchar_att_value(values);
        } else {
            this.deviceAttribute_3.insert_uc(argIn);
        }
    }

    @Override
    public void insert_uc(byte[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.uchar_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert_uc(argIn);
        }
    }

    @Override
    public void insert(short argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        this.insert(new short[]{argIn});
    }

    @Override
    public void insert(short[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.short_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(short[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.short_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert_us(short argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] values = new short[]{argIn};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ushort_att_value(values);
        } else {
            this.deviceAttribute_3.insert_us(argIn);
        }
    }

    @Override
    public void insert_us(int argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] values = new short[]{(short)(argIn & 0xFFFF)};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ushort_att_value(values);
        } else {
            this.deviceAttribute_3.insert_us(argIn);
        }
    }

    @Override
    public void insert_us(short[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ushort_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert_us(argIn);
        }
    }

    @Override
    public void insert_us(int[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] values = new short[argIn.length];
        for (int i = 0; i < argIn.length; ++i) {
            values[i] = (short)(argIn[i] & 0xFFFF);
        }
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ushort_att_value(values);
        } else {
            this.deviceAttribute_3.insert_us(argIn);
        }
    }

    @Override
    public void insert_us(short[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.ushort_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert_us(argIn);
        }
    }

    @Override
    public void insert_us(int[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        short[] values = new short[argIn.length];
        for (int i = 0; i < argIn.length; ++i) {
            values[i] = (short)(argIn[i] & 0xFFFF);
        }
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.ushort_att_value(values);
        } else {
            this.deviceAttribute_3.insert_us(argIn);
        }
    }

    @Override
    public void insert(int argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        this.insert(new int[]{argIn});
    }

    @Override
    public void insert(int[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.long_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(int[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.long_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(long argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        this.insert(new long[]{argIn});
    }

    @Override
    public void insert(long[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.long64_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(long[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.long64_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert_ul(int argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] values = new int[]{argIn};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ulong_att_value(values);
        } else {
            this.deviceAttribute_3.insert_ul(argIn);
        }
    }

    @Override
    public void insert_ul(long argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] values = new int[]{(int)argIn};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ulong_att_value(values);
        } else {
            this.deviceAttribute_3.insert_ul(argIn);
        }
    }

    @Override
    public void insert_ul(int[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ulong_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert_ul(argIn);
        }
    }

    @Override
    public void insert_ul(long[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] values = new int[argIn.length];
        for (int i = 0; i < argIn.length; ++i) {
            values[i] = (int)argIn[i];
        }
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ulong_att_value(values);
        } else {
            this.deviceAttribute_3.insert_ul(argIn);
        }
    }

    @Override
    public void insert_ul(int[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.ulong_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert_ul(argIn);
        }
    }

    @Override
    public void insert_ul(long[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        int[] values = new int[argIn.length];
        for (int i = 0; i < argIn.length; ++i) {
            values[i] = (int)argIn[i];
        }
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.ulong_att_value(values);
        } else {
            this.deviceAttribute_3.insert_ul(argIn);
        }
    }

    @Override
    public void insert_u64(long argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        long[] values = new long[]{argIn};
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ulong64_att_value(values);
        } else {
            this.deviceAttribute_3.insert_u64(argIn);
        }
    }

    @Override
    public void insert_u64(long[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.ulong64_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert_u64(argIn);
        }
    }

    @Override
    public void insert_u64(long[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.ulong64_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert_u64(argIn);
        }
    }

    @Override
    public void insert(float argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.float_att_value(new float[]{argIn});
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(float[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.float_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(float[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.float_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(double argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        this.insert(new double[]{argIn});
    }

    @Override
    public void insert(double[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.double_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(double[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.double_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(String argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        this.insert(new String[]{argIn});
    }

    @Override
    public void insert(String[] argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = argIn.length;
        this.attributeValue_5.w_dim.dim_y = 0;
        if (this.use_union) {
            this.attributeValue_5.value.string_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(String[] argIn, int dim_x, int dim_y) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.w_dim.dim_x = dim_x;
        this.attributeValue_5.w_dim.dim_y = dim_y;
        if (this.use_union) {
            this.attributeValue_5.value.string_att_value(argIn);
        } else {
            this.deviceAttribute_3.insert(argIn);
        }
    }

    @Override
    public void insert(DevEncoded argIn) {
        this.attributeValue_5.data_format = AttrDataFormat.FMT_UNKNOWN;
        this.attributeValue_5.err_list = new DevError[0];
        this.attributeValue_5.w_dim.dim_x = 1;
        this.attributeValue_5.w_dim.dim_y = 0;
        this.attributeValue_5.value.encoded_att_value(new DevEncoded[]{argIn});
    }

    private void manageExceptions(String method_name, boolean onQuality) throws DevFailed {
        if (this.attributeValue_5.err_list != null && this.attributeValue_5.err_list.length > 0) {
            throw new WrongData(this.attributeValue_5.err_list);
        }
        if (onQuality && this.attributeValue_5.quality == AttrQuality.ATTR_INVALID) {
            Except.throw_wrong_data_exception("AttrQuality_ATTR_INVALID", "Attribute quality factor is INVALID", "DeviceAttribute." + method_name + "()");
        }
    }

    private void manageExceptions(String method_name) throws DevFailed {
        this.manageExceptions(method_name, true);
    }

    @Override
    public DevState[] extractDevStateArray() throws DevFailed {
        this.manageExceptions("extractDevStateArray()");
        try {
            if (this.use_union) {
                if (this.attributeValue_5.value.discriminator().value() == 12) {
                    return new DevState[]{this.attributeValue_5.value.dev_state_att()};
                }
                return this.attributeValue_5.value.state_att_value();
            }
            return this.deviceAttribute_3.extractDevStateArray();
        }
        catch (BAD_PARAM e) {
            Except.throw_wrong_data_exception(e.toString(), "Exception catched : " + e.toString() + "\n" + "Maybe the attribute value has not been initialized", "DeviceAttribute.extractDevStateArray()");
            return new DevState[0];
        }
    }

    @Override
    public DevState extractDevState() throws DevFailed {
        this.manageExceptions("extractDevState");
        if (this.use_union) {
            if (this.attributeValue_5.value.discriminator().value() == 12) {
                return this.attributeValue_5.value.dev_state_att();
            }
            return this.attributeValue_5.value.state_att_value()[0];
        }
        return this.deviceAttribute_3.extractDevState();
    }

    @Override
    public boolean extractBoolean() throws DevFailed {
        this.manageExceptions("extractBoolean()");
        if (this.use_union) {
            return this.attributeValue_5.value.bool_att_value()[0];
        }
        return this.deviceAttribute_3.extractBoolean();
    }

    @Override
    public boolean[] extractBooleanArray() throws DevFailed {
        this.manageExceptions("extractBooleanArray()");
        if (this.use_union) {
            return this.attributeValue_5.value.bool_att_value();
        }
        return this.deviceAttribute_3.extractBooleanArray();
    }

    @Override
    public short extractUChar() throws DevFailed {
        this.manageExceptions("extractUChar");
        if (this.use_union) {
            return this.attributeValue_5.value.uchar_att_value()[0];
        }
        return this.deviceAttribute_3.extractUChar();
    }

    @Override
    public short[] extractUCharArray() throws DevFailed {
        this.manageExceptions("extractUCharArray()");
        if (this.use_union) {
            byte[] argOut = this.attributeValue_5.value.uchar_att_value();
            short[] val = new short[argOut.length];
            int mask = 255;
            for (int i = 0; i < argOut.length; ++i) {
                val[i] = (short)(0xFF & argOut[i]);
            }
            return val;
        }
        return this.deviceAttribute_3.extractUCharArray();
    }

    @Override
    public byte[] extractCharArray() throws DevFailed {
        this.manageExceptions("extractCharArray()");
        if (this.use_union) {
            return this.attributeValue_5.value.uchar_att_value();
        }
        return this.deviceAttribute_3.extractCharArray();
    }

    @Override
    public short extractShort() throws DevFailed {
        this.manageExceptions("extractShort()");
        if (this.use_union) {
            return this.attributeValue_5.value.short_att_value()[0];
        }
        return this.deviceAttribute_3.extractShort();
    }

    @Override
    public short[] extractShortArray() throws DevFailed {
        this.manageExceptions("extractShortArray");
        if (this.use_union) {
            return this.attributeValue_5.value.short_att_value();
        }
        return this.deviceAttribute_3.extractShortArray();
    }

    @Override
    public int extractUShort() throws DevFailed {
        this.manageExceptions("extractUShort");
        if (this.use_union) {
            return this.attributeValue_5.value.ushort_att_value()[0];
        }
        return this.deviceAttribute_3.extractUShort();
    }

    @Override
    public int[] extractUShortArray() throws DevFailed {
        this.manageExceptions("extractUShortArray");
        if (this.use_union) {
            short[] argOut = this.attributeValue_5.value.ushort_att_value();
            int[] val = new int[argOut.length];
            for (int i = 0; i < argOut.length; ++i) {
                val[i] = 0xFFFF & argOut[i];
            }
            return val;
        }
        return this.deviceAttribute_3.extractUShortArray();
    }

    @Override
    public int extractLong() throws DevFailed {
        this.manageExceptions("extractLong");
        if (this.use_union) {
            return this.attributeValue_5.value.long_att_value()[0];
        }
        return this.deviceAttribute_3.extractLong();
    }

    @Override
    public int[] extractLongArray() throws DevFailed {
        this.manageExceptions("extractLongArray");
        if (this.use_union) {
            return this.attributeValue_5.value.long_att_value();
        }
        return this.deviceAttribute_3.extractLongArray();
    }

    @Override
    public long extractULong() throws DevFailed {
        this.manageExceptions("extractULong");
        if (this.use_union) {
            int[] argOut = this.attributeValue_5.value.ulong_att_value();
            long mask = Integer.MAX_VALUE;
            return (mask += 0x80000000L) & (long)argOut[0];
        }
        return this.deviceAttribute_3.extractULong();
    }

    @Override
    public long[] extractULongArray() throws DevFailed {
        this.manageExceptions("extractULong");
        if (this.use_union) {
            int[] array = this.attributeValue_5.value.ulong_att_value();
            long mask = Integer.MAX_VALUE;
            mask += 0x80000000L;
            long[] result = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = mask & (long)array[i];
            }
            return result;
        }
        return this.deviceAttribute_3.extractULongArray();
    }

    @Override
    public long extractLong64() throws DevFailed {
        this.manageExceptions("extractLong64");
        if (this.use_union) {
            return this.extractLong64Array()[0];
        }
        return this.deviceAttribute_3.extractLong64();
    }

    @Override
    public long[] extractLong64Array() throws DevFailed {
        this.manageExceptions("extractLong64Array");
        if (this.use_union) {
            return this.attributeValue_5.value.long64_att_value();
        }
        return this.deviceAttribute_3.extractLong64Array();
    }

    @Override
    public long extractULong64() throws DevFailed {
        this.manageExceptions("extractULong64");
        return this.extractULong64Array()[0];
    }

    @Override
    public long[] extractULong64Array() throws DevFailed {
        this.manageExceptions("extractULong64Array");
        if (this.use_union) {
            return this.attributeValue_5.value.ulong64_att_value();
        }
        return this.deviceAttribute_3.extractULong64Array();
    }

    @Override
    public float extractFloat() throws DevFailed {
        this.manageExceptions("extractFloat");
        return this.extractFloatArray()[0];
    }

    @Override
    public float[] extractFloatArray() throws DevFailed {
        this.manageExceptions("extractFloatArray");
        if (this.use_union) {
            return this.attributeValue_5.value.float_att_value();
        }
        return this.deviceAttribute_3.extractFloatArray();
    }

    @Override
    public double extractDouble() throws DevFailed {
        this.manageExceptions("extractDouble");
        return this.extractDoubleArray()[0];
    }

    @Override
    public double[] extractDoubleArray() throws DevFailed {
        this.manageExceptions("extractDoubleArray");
        if (this.use_union) {
            return this.attributeValue_5.value.double_att_value();
        }
        return this.deviceAttribute_3.extractDoubleArray();
    }

    @Override
    public DevState extractState() throws DevFailed {
        this.manageExceptions("extractState");
        return this.extractDevState();
    }

    @Override
    public String extractString() throws DevFailed {
        this.manageExceptions("extractString");
        return this.extractStringArray()[0];
    }

    @Override
    public String[] extractStringArray() throws DevFailed {
        this.manageExceptions("extractStringArray");
        if (this.use_union) {
            return this.attributeValue_5.value.string_att_value();
        }
        return this.deviceAttribute_3.extractStringArray();
    }

    @Override
    public DevEncoded extractDevEncoded() throws DevFailed {
        this.manageExceptions("extractDevEncoded");
        if (this.attributeValue_5.value.encoded_att_value() == null) {
            Except.throw_exception("BAD_PARAM", "DevEncoded object is null");
        }
        return this.attributeValue_5.value.encoded_att_value()[0];
    }

    @Override
    public DevEncoded[] extractDevEncodedArray() throws DevFailed {
        this.manageExceptions("extractDevEncoded");
        if (this.attributeValue_5.value.encoded_att_value() == null) {
            Except.throw_exception("BAD_PARAM", "DevEncoded object is null");
        }
        return this.attributeValue_5.value.encoded_att_value();
    }

    @Override
    public AttrQuality getQuality() throws DevFailed {
        this.manageExceptions("getQuality", false);
        return this.attributeValue_5.quality;
    }

    @Override
    public AttrDataFormat getDataFormat() throws DevFailed {
        return this.attributeValue_5.data_format;
    }

    @Override
    public TimeVal getTimeVal() throws DevFailed {
        this.manageExceptions("getTimeVal", false);
        return this.attributeValue_5.time;
    }

    @Override
    public long getTimeValSec() throws DevFailed {
        this.manageExceptions("getTimeValSec", false);
        return this.attributeValue_5.time.tv_sec;
    }

    @Override
    public long getTimeValMillisSec() throws DevFailed {
        this.manageExceptions("getTimeValMillisSec", false);
        return (long)this.attributeValue_5.time.tv_sec * 1000L + (long)this.attributeValue_5.time.tv_usec / 1000L;
    }

    @Override
    public String getName() throws DevFailed {
        return this.attributeValue_5.name;
    }

    private static int DIM_MINI(int y) {
        return y == 0 ? 1 : y;
    }

    @Override
    public int getNbRead() throws DevFailed {
        this.manageExceptions("getNbRead");
        int ySize = this.attributeValue_5.r_dim.dim_y;
        return this.attributeValue_5.r_dim.dim_x * DeviceAttributeDAODefaultImpl.DIM_MINI(ySize);
    }

    @Override
    public int getNbWritten() throws DevFailed {
        this.manageExceptions("getNbWritten");
        int ySize = this.attributeValue_5.w_dim.dim_y;
        return this.attributeValue_5.w_dim.dim_x * DeviceAttributeDAODefaultImpl.DIM_MINI(ySize);
    }

    @Override
    public int getDimX() throws DevFailed {
        this.manageExceptions("getDimX");
        return this.attributeValue_5.r_dim.dim_x;
    }

    @Override
    public int getDimY() throws DevFailed {
        this.manageExceptions("getDimY");
        return this.attributeValue_5.r_dim.dim_y;
    }

    @Override
    public int getWrittenDimX() throws DevFailed {
        this.manageExceptions("getWrittenDimX");
        return this.attributeValue_5.w_dim.dim_x;
    }

    @Override
    public int getWrittenDimY() throws DevFailed {
        this.manageExceptions("getWrittenDimY");
        return this.attributeValue_5.w_dim.dim_y;
    }

    @Override
    public AttributeValue getAttributeValueObject_2() throws DevFailed {
        DeviceAttribute_3DAODefaultImpl att = new DeviceAttribute_3DAODefaultImpl();
        att.setAttributeValue(this);
        return att.getAttributeValueObject_2();
    }

    @Override
    public AttributeValue_3 getAttributeValueObject_3() throws DevFailed {
        DeviceAttribute_3 att = new DeviceAttribute_3();
        att.setAttributeValue(this);
        return att.getAttributeValueObject_3();
    }

    @Override
    public AttributeValue_4 getAttributeValueObject_4() {
        return new AttributeValue_4(this.attributeValue_5.value, this.attributeValue_5.quality, this.attributeValue_5.data_format, this.attributeValue_5.time, this.attributeValue_5.name, this.attributeValue_5.r_dim, this.attributeValue_5.w_dim, this.attributeValue_5.err_list);
    }

    @Override
    public AttributeValue_5 getAttributeValueObject_5() {
        return this.attributeValue_5;
    }

    @Override
    public long getTime() throws DevFailed {
        this.manageExceptions("getTime", false);
        return (long)this.attributeValue_5.time.tv_sec * 1000L + (long)(this.attributeValue_5.time.tv_usec / 1000);
    }

    @Override
    public int getType() throws DevFailed {
        if (!this.use_union) {
            return this.deviceAttribute_3.getType();
        }
        if (this.attributeValue_5.data_type != 0) {
            return this.attributeValue_5.data_type;
        }
        if (this.attributeValue_5.value == null || this.attributeValue_5.value.discriminator() == null) {
            Except.throw_exception("AttributeTypeNotSet", "Attribute " + this.attributeValue_5.name + " Value Has Not Been Set");
        }
        int type = -1;
        try {
            switch (this.attributeValue_5.value.discriminator().value()) {
                case 0: {
                    type = 1;
                    break;
                }
                case 1: {
                    type = 2;
                    break;
                }
                case 2: {
                    type = 3;
                    break;
                }
                case 3: {
                    type = 23;
                    break;
                }
                case 4: {
                    type = 4;
                    break;
                }
                case 5: {
                    type = 5;
                    break;
                }
                case 6: {
                    type = 22;
                    break;
                }
                case 7: {
                    type = 6;
                    break;
                }
                case 8: {
                    type = 7;
                    break;
                }
                case 9: {
                    type = 24;
                    break;
                }
                case 10: {
                    type = 8;
                    break;
                }
                case 11: 
                case 12: {
                    type = 19;
                    break;
                }
                case 13: {
                    type = 28;
                    break;
                }
                case 14: {
                    type = 0;
                    break;
                }
                default: {
                    Except.throw_exception("AttributeTypeNotSupported", "Attribute Type (" + this.attributeValue_5.value.discriminator().value() + ") Not Supported");
                    break;
                }
            }
        }
        catch (BAD_PARAM e) {
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ");
        }
        return type;
    }

    void setValueAsAny(DeviceAttribute_3DAODefaultImpl att_3) throws DevFailed {
        switch (this.getType()) {
            case 1: {
                att_3.insert(this.extractBooleanArray());
                break;
            }
            case 2: {
                att_3.insert(this.extractShortArray());
                break;
            }
            case 3: {
                att_3.insert(this.extractLongArray());
                break;
            }
            case 23: {
                att_3.insert(this.extractLong64Array());
                break;
            }
            case 4: {
                att_3.insert(this.extractFloatArray());
                break;
            }
            case 5: {
                att_3.insert(this.extractDoubleArray());
                break;
            }
            case 22: {
                att_3.insert_uc(this.extractUCharArray());
                break;
            }
            case 6: {
                att_3.insert_us(this.extractUShortArray());
                break;
            }
            case 7: {
                att_3.insert_ul(this.extractULongArray());
                break;
            }
            case 24: {
                att_3.insert_u64(this.extractULong64Array());
                break;
            }
            case 8: {
                att_3.insert(this.extractStringArray());
                break;
            }
            case 19: {
                att_3.insert(this.extractDevStateArray());
            }
        }
    }
}

