/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevAttrHistory_4;
import fr.esrf.Tango.DevAttrHistory_5;
import fr.esrf.Tango.DevCmdHistory_4;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarDoubleStringArrayHelper;
import fr.esrf.Tango.DevVarEncodedArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLong64ArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarLongStringArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStateArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULong64ArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

class ConversionUtil {
    ConversionUtil() {
    }

    static DeviceDataHistory[] commandHistoryToDeviceDataHistoryArray(String commandName, DevCmdHistory_4 cmdHistory4) throws DevFailed {
        int k;
        int start;
        int nb_elt;
        int i;
        if (cmdHistory4.dims.length != cmdHistory4.dims_array.length || cmdHistory4.errors.length != cmdHistory4.errors_array.length) {
            Except.throw_exception("API_WrongHistoryDataBuffer", "Data buffer received from server is not valid !");
        }
        int nb_records = cmdHistory4.dates.length;
        DeviceDataHistory[] ddh = new DeviceDataHistory[nb_records];
        for (i = 0; i < nb_records; ++i) {
            ddh[i] = new DeviceDataHistory(commandName, 0, cmdHistory4.dates[i]);
        }
        for (i = 0; i < cmdHistory4.dims.length; ++i) {
            nb_elt = cmdHistory4.dims_array[i].nb_elt;
            start = cmdHistory4.dims_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                ddh[start - k].setDimX(cmdHistory4.dims[i].dim_x);
                ddh[start - k].setDimY(cmdHistory4.dims[i].dim_y);
            }
        }
        for (i = 0; i < cmdHistory4.errors.length; ++i) {
            nb_elt = cmdHistory4.errors_array[i].nb_elt;
            start = cmdHistory4.errors_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                ddh[start - k].setErrStack(cmdHistory4.errors[i]);
            }
        }
        ConversionUtil.insertValues(ddh, cmdHistory4.value, nb_records, cmdHistory4.cmd_type);
        return ddh;
    }

    static DeviceDataHistory[] attributeHistoryToDeviceDataHistoryArray(DevAttrHistory_4 attrHistory4) throws DevFailed {
        int k;
        int start;
        int nb_elt;
        int i;
        if (attrHistory4.quals.length != attrHistory4.quals_array.length || attrHistory4.r_dims.length != attrHistory4.r_dims_array.length || attrHistory4.w_dims.length != attrHistory4.w_dims_array.length || attrHistory4.errors.length != attrHistory4.errors_array.length) {
            Except.throw_exception("API_WrongHistoryDataBuffer", "Data buffer received from server is not valid !", "DeviceProxy::from_hist4_2_AttHistory");
        }
        int nb_records = attrHistory4.dates.length;
        String name = attrHistory4.name;
        DeviceDataHistory[] ddh = new DeviceDataHistory[nb_records];
        for (i = 0; i < nb_records; ++i) {
            ddh[i] = new DeviceDataHistory(name, 1, attrHistory4.dates[i]);
        }
        for (i = 0; i < attrHistory4.quals.length; ++i) {
            nb_elt = attrHistory4.quals_array[i].nb_elt;
            start = attrHistory4.quals_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                ddh[start - k].setAttrQuality(attrHistory4.quals[i]);
            }
        }
        for (i = 0; i < attrHistory4.r_dims.length; ++i) {
            nb_elt = attrHistory4.r_dims_array[i].nb_elt;
            start = attrHistory4.r_dims_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                ddh[start - k].setDimX(attrHistory4.r_dims[i].dim_x);
                ddh[start - k].setDimY(attrHistory4.r_dims[i].dim_y);
            }
        }
        for (i = 0; i < attrHistory4.w_dims.length; ++i) {
            nb_elt = attrHistory4.w_dims_array[i].nb_elt;
            start = attrHistory4.w_dims_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                ddh[start - k].setWrittenDimX(attrHistory4.w_dims[i].dim_x);
                ddh[start - k].setWrittenDimY(attrHistory4.w_dims[i].dim_y);
            }
        }
        for (i = 0; i < attrHistory4.errors.length; ++i) {
            nb_elt = attrHistory4.errors_array[i].nb_elt;
            start = attrHistory4.errors_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                ddh[start - k].setErrStack(attrHistory4.errors[i]);
            }
        }
        ConversionUtil.insertValues(ddh, attrHistory4.value, nb_records, ConversionUtil.getType(attrHistory4.value));
        return ddh;
    }

    static DeviceDataHistory[] attributeHistoryToDeviceDataHistoryArray(DevAttrHistory_5 attrHistory5) throws DevFailed {
        int k;
        int start;
        int nb_elt;
        int i;
        if (attrHistory5.quals.length != attrHistory5.quals_array.length || attrHistory5.r_dims.length != attrHistory5.r_dims_array.length || attrHistory5.w_dims.length != attrHistory5.w_dims_array.length || attrHistory5.errors.length != attrHistory5.errors_array.length) {
            Except.throw_exception("API_WrongHistoryDataBuffer", "Data buffer received from server is not valid !", "DeviceProxy::from_hist4_2_AttHistory");
        }
        int nb_records = attrHistory5.dates.length;
        String name = attrHistory5.name;
        DeviceDataHistory[] dataHistories = new DeviceDataHistory[nb_records];
        for (i = 0; i < nb_records; ++i) {
            dataHistories[i] = new DeviceDataHistory(name, 1, attrHistory5.dates[i]);
            dataHistories[i].dataFormat = attrHistory5.data_format;
            dataHistories[i].dataType = attrHistory5.data_type;
        }
        for (i = 0; i < attrHistory5.quals.length; ++i) {
            nb_elt = attrHistory5.quals_array[i].nb_elt;
            start = attrHistory5.quals_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                dataHistories[start - k].setAttrQuality(attrHistory5.quals[i]);
            }
        }
        for (i = 0; i < attrHistory5.r_dims.length; ++i) {
            nb_elt = attrHistory5.r_dims_array[i].nb_elt;
            start = attrHistory5.r_dims_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                dataHistories[start - k].setDimX(attrHistory5.r_dims[i].dim_x);
                dataHistories[start - k].setDimY(attrHistory5.r_dims[i].dim_y);
            }
        }
        for (i = 0; i < attrHistory5.w_dims.length; ++i) {
            nb_elt = attrHistory5.w_dims_array[i].nb_elt;
            start = attrHistory5.w_dims_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                dataHistories[start - k].setWrittenDimX(attrHistory5.w_dims[i].dim_x);
                dataHistories[start - k].setWrittenDimY(attrHistory5.w_dims[i].dim_y);
            }
        }
        for (i = 0; i < attrHistory5.errors.length; ++i) {
            nb_elt = attrHistory5.errors_array[i].nb_elt;
            start = attrHistory5.errors_array[i].start;
            for (k = 0; k < nb_elt; ++k) {
                dataHistories[start - k].setErrStack(attrHistory5.errors[i]);
            }
        }
        ConversionUtil.insertValues(dataHistories, attrHistory5.value, nb_records, attrHistory5.data_type);
        return dataHistories;
    }

    private static void insertValues(DeviceDataHistory[] dataHistories, Any value, int nb_records, int type) throws DevFailed {
        switch (type) {
            case 1: {
                boolean[] values = DevVarBooleanArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 22: {
                byte[] argout = DevVarCharArrayHelper.extract(value);
                short[] values = new short[argout.length];
                int mask = 255;
                for (int i = 0; i < argout.length; ++i) {
                    values[i] = (short)(mask & argout[i]);
                }
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 2: 
            case 10: {
                short[] values = DevVarShortArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 6: 
            case 14: {
                short[] values = DevVarUShortArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 3: 
            case 11: {
                int[] values = DevVarLongArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 7: 
            case 15: {
                int[] values = DevVarULongArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 23: 
            case 25: {
                long[] values = DevVarLong64ArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 24: 
            case 26: {
                long[] values = DevVarULong64ArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 4: 
            case 12: {
                float[] values = DevVarFloatArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 5: 
            case 13: {
                double[] values = DevVarDoubleArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 8: 
            case 16: {
                String[] values = DevVarStringArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 17: {
                DevVarLongStringArray values = DevVarLongStringArrayHelper.extract(value);
                int s_base = values.svalue.length;
                int l_base = values.lvalue.length;
                int[] bases = new int[]{s_base, l_base};
                for (int i = 0; i < nb_records; ++i) {
                    bases = dataHistories[i].insert(values, bases);
                }
                break;
            }
            case 18: {
                DevVarDoubleStringArray values = DevVarDoubleStringArrayHelper.extract(value);
                int s_base = values.svalue.length;
                int d_base = values.dvalue.length;
                int[] bases = new int[]{s_base, d_base};
                for (int i = 0; i < nb_records; ++i) {
                    bases = dataHistories[i].insert(values, bases);
                }
                break;
            }
            case 19: {
                DevState[] values = ConversionUtil.isArray(value) ? DevVarStateArrayHelper.extract(value) : new DevState[]{DevStateHelper.extract(value)};
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            case 28: {
                DevEncoded[] values = DevVarEncodedArrayHelper.extract(value);
                int base = values.length;
                for (int i = 0; i < nb_records; ++i) {
                    base = dataHistories[i].insert(values, base);
                }
                break;
            }
            default: {
                Except.throw_wrong_data_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type (" + type + ")", "ConversionUtil.insertValue()");
            }
        }
    }

    private static boolean isArray(Any any) {
        boolean retval = true;
        try {
            TypeCode tc = any.type();
            TypeCode tc_alias = tc.content_type();
            tc_alias.content_type();
        }
        catch (BadKind e) {
            retval = false;
        }
        return retval;
    }

    public static int getType(Any any) throws DevFailed {
        int type = -1;
        try {
            TypeCode tc = any.type();
            if (tc.kind().value() == 0) {
                return 0;
            }
            if (tc.kind().value() == 17) {
                return 19;
            }
            TypeCode tc_alias = tc.content_type();
            TypeCode tc_seq = tc_alias.content_type();
            TCKind kind = tc_seq.kind();
            switch (kind.value()) {
                case 1: {
                    type = 0;
                    break;
                }
                case 8: {
                    type = 1;
                    break;
                }
                case 9: {
                    type = 21;
                    break;
                }
                case 10: {
                    type = 22;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 6;
                    break;
                }
                case 3: {
                    type = 3;
                    break;
                }
                case 5: {
                    type = 7;
                    break;
                }
                case 23: {
                    type = 23;
                    break;
                }
                case 24: {
                    type = 24;
                    break;
                }
                case 6: {
                    type = 4;
                    break;
                }
                case 7: {
                    type = 5;
                    break;
                }
                case 18: {
                    type = 8;
                    break;
                }
                case 17: {
                    type = 19;
                    break;
                }
                case 15: {
                    type = 28;
                }
            }
        }
        catch (BadKind e) {
            e.printStackTrace();
            Except.throw_exception("Api_TypeCodePackage.BadKind", "Bad or unknown type ", "ConversionUtil.getType()");
        }
        return type;
    }
}

