/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.Tango.factory;

import fr.esrf.Tango.factory.ITangoFactory;
import fr.esrf.TangoApi.IApiUtilDAO;
import fr.esrf.TangoApi.IConnectionDAO;
import fr.esrf.TangoApi.IDatabaseDAO;
import fr.esrf.TangoApi.IDeviceAttributeDAO;
import fr.esrf.TangoApi.IDeviceAttribute_3DAO;
import fr.esrf.TangoApi.IDeviceDataDAO;
import fr.esrf.TangoApi.IDeviceDataHistoryDAO;
import fr.esrf.TangoApi.IDeviceProxyDAO;
import fr.esrf.TangoApi.IIORDumpDAO;
import fr.esrf.TangoApi.ITacoTangoDeviceDAO;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class TangoFactory {
    public static final String FACTORY_PROPERTIES = "tango_factory.properties";
    public static final String TANGO_FACTORY = "TANGO_FACTORY";
    private static TangoFactory singleton = new TangoFactory();
    private ITangoFactory tangoFactory;
    private boolean isDefaultFactory = true;

    private TangoFactory() {
        this.initTangoFactory();
    }

    private void initTangoFactory() {
        Properties properties = TangoFactory.getPropertiesFile();
        String factoryClassName = properties.getProperty(TANGO_FACTORY);
        if (factoryClassName == null) {
            factoryClassName = "fr.esrf.TangoApi.factory.DefaultTangoFactoryImpl";
        }
        this.tangoFactory = (ITangoFactory)TangoFactory.getObject(factoryClassName);
        this.isDefaultFactory = false;
    }

    public static TangoFactory getSingleton() {
        return singleton;
    }

    public IConnectionDAO getConnectionDAO() {
        return this.tangoFactory.getConnectionDAO();
    }

    public IDeviceProxyDAO getDeviceProxyDAO() {
        return this.tangoFactory.getDeviceProxyDAO();
    }

    public ITacoTangoDeviceDAO getTacoTangoDeviceDAO() {
        return this.tangoFactory.getTacoTangoDeviceDAO();
    }

    public IDatabaseDAO getDatabaseDAO() {
        return this.tangoFactory.getDatabaseDAO();
    }

    public IDeviceAttributeDAO getDeviceAttributeDAO() {
        return this.tangoFactory.getDeviceAttributeDAO();
    }

    public IDeviceAttribute_3DAO getDeviceAttribute_3DAO() {
        return this.tangoFactory.getDeviceAttribute_3DAO();
    }

    public IDeviceDataDAO getDeviceDataDAO() {
        return this.tangoFactory.getDeviceDataDAO();
    }

    public IDeviceDataHistoryDAO getDeviceDataHistoryDAO() {
        return this.tangoFactory.getDeviceDataHistoryDAO();
    }

    public IApiUtilDAO getApiUtilDAO() {
        return this.tangoFactory.getApiUtilDAO();
    }

    public IIORDumpDAO getIORDumpDAO() {
        return this.tangoFactory.getIORDumpDAO();
    }

    private static Properties getPropertiesFile() {
        try {
            InputStream stream = TangoFactory.class.getClassLoader().getResourceAsStream(FACTORY_PROPERTIES);
            Properties properties = new Properties();
            if (stream != null) {
                BufferedInputStream bufStream = new BufferedInputStream(stream);
                properties.clear();
                properties.load(bufStream);
            }
            return properties;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getObject(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> contructor = clazz.getConstructor(new Class[0]);
            return contructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDefaultFactory() {
        return this.isDefaultFactory;
    }

    public void setDefaultFactory(boolean isDefaultFactory) {
        this.isDefaultFactory = isDefaultFactory;
    }
}

