/*
 * Decompiled with CFR 0.152.
 */
package atkpanel;

import atkpanel.BooleanSpectrumPanel;
import atkpanel.DevStateSpectrumPanel;
import atkpanel.ImagePanel;
import atkpanel.RawImagePanel;
import atkpanel.RefresherUtil;
import atkpanel.SpectrumPanel;
import atkpanel.StringImagePanel;
import atkpanel.StringSpectrumPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanSpectrum;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.IEnumScalar;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.widget.attribute.BooleanTrend;
import fr.esrf.tangoatk.widget.attribute.ScalarListViewer;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.command.CommandComboViewer;
import fr.esrf.tangoatk.widget.device.StatusViewer;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainPanel
extends JFrame {
    private final Splash splash = new Splash();
    private final int MIN_WIDTH = 220;
    private final int MAX_WIDTH = 570;
    private final int MIN_HEIGHT = 220;
    private final int MAX_HEIGHT = 570;
    private boolean standAlone = false;
    private boolean keepStateRefresher = true;
    private boolean operatorView = true;
    private boolean modifPropButton = true;
    private boolean roMode = false;
    private String startupTabName = null;
    private int startupTabIndex = -1;
    private AttributeList all_scalar_atts;
    private AttributeList op_scalar_atts;
    private AttributeList exp_scalar_atts;
    private AttributeList state_status_atts;
    private AttributePolledList numberAndState_scalar_atts;
    private AttributePolledList boolean_scalar_atts;
    private AttributeList all_spectrum_atts;
    private AttributeList op_spectrum_atts;
    private List<JComponent> all_spectrum_panels = null;
    private AttributeList all_number_image_atts;
    private AttributeList op_number_image_atts;
    private List<ImagePanel> all_image_panels = null;
    private AttributeList all_string_image_atts;
    private AttributeList op_string_image_atts;
    private List<StringImagePanel> all_string_image_panels = null;
    private AttributeList all_raw_image_atts;
    private AttributeList op_raw_image_atts;
    private List<RawImagePanel> all_raw_image_panels = null;
    private CommandList all_cmdl;
    private CommandList op_cmdl;
    private Device panelDev;
    private ErrorHistory errorHistory;
    private ErrorPopup errorPopup;
    private JFrame trendFrame;
    private JFrame booleanTrendFrame;
    private ScalarListViewer allScalarListViewer;
    private ScalarListViewer operatorScalarListViewer;
    private IDevStateScalar stateAtt = null;
    private IStringScalar statusAtt = null;
    private Trend globalTrend = null;
    private BooleanTrend booleanTrend = null;
    private RefresherUtil refUtil = new RefresherUtil();
    private int iTabbedPaneIndex = 0;
    private boolean refresherActivated = true;
    private static final String REVISION = "Revision: 5.4 ";
    private JDialog tgDevtestDlg = null;
    private static int[] wpos = null;
    private static int globalRefPeriod = 1000;
    private JMenuBar jMenuBar1;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenu jMenu3;
    private JMenuItem jMenuItem5;
    private JMenuItem boolTrendJMenuItem;
    private JMenuItem tgDevTestJMenuItem;
    private JMenuItem jMenuItem3;
    private JMenuItem diagJMenuItem;
    private JMenu jMenu2;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem setRefPeriodJMenuItem;
    private JMenuItem timeoutJMenuItem;
    private JCheckBoxMenuItem expertCheckBoxMenuItem;
    private JCheckBoxMenuItem operatorCheckBoxMenuItem;
    private JMenu jMenu4;
    private JMenuItem jMenuItem4;
    private JPanel stateAndCmdJPanel;
    private JSplitPane mainJSplitPane;
    private JPanel topJPanel;
    private CommandComboViewer commandComboViewer1;
    private fr.esrf.tangoatk.widget.device.StateViewer devStateViewer;
    private StatusViewer devStatusViewer;
    private StateViewer attStateViewer;
    private fr.esrf.tangoatk.widget.attribute.StatusViewer attStatusViewer;
    private JTabbedPane jTabbedPane1;
    private JScrollPane jScrollPane1;
    private JPanel scrollJPanel;

    private MainPanel() {
        GridBagConstraints trendGbc = new GridBagConstraints();
        trendGbc.gridx = 0;
        trendGbc.gridy = 0;
        trendGbc.fill = 1;
        trendGbc.weightx = 1.0;
        trendGbc.weighty = 1.0;
        this.trendFrame = new JFrame();
        JPanel jp1 = new JPanel();
        this.trendFrame.getContentPane().add((Component)jp1, "Center");
        jp1.setPreferredSize(new Dimension(600, 300));
        jp1.setLayout(new GridBagLayout());
        this.globalTrend = new Trend(this.trendFrame);
        jp1.add((Component)this.globalTrend, trendGbc);
        this.trendFrame.pack();
        this.booleanTrendFrame = new JFrame();
        JPanel jp2 = new JPanel();
        this.booleanTrendFrame.getContentPane().add((Component)jp2, "Center");
        jp2.setPreferredSize(new Dimension(600, 300));
        jp2.setLayout(new GridBagLayout());
        this.booleanTrend = new BooleanTrend();
        jp2.add((Component)this.booleanTrend, trendGbc);
        this.booleanTrendFrame.pack();
    }

    public MainPanel(String devName) {
        this();
        if (!this.connectDevice(devName)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String[] args) {
        this(args[0]);
    }

    public MainPanel(String dev, boolean stda) {
        this();
        this.standAlone = stda;
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String[] args, boolean stda) {
        this();
        this.standAlone = stda;
        if (!this.connectDevice(args[0])) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, boolean stda, boolean keepStateRef) {
        this();
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, String tab, boolean stda, boolean keepStateRef) {
        this();
        this.startupTabName = tab;
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, boolean stda, boolean keepStateRef, boolean modifProp) {
        this();
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        this.modifPropButton = modifProp;
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, boolean stda, boolean keepStateRef, boolean modifProp, boolean ro) {
        this();
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        this.modifPropButton = modifProp;
        this.roMode = ro;
        if (ro) {
            this.modifPropButton = false;
        }
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, String tab, boolean stda, boolean keepStateRef, boolean modifProp, boolean ro) {
        this();
        this.startupTabName = tab;
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        this.modifPropButton = modifProp;
        this.roMode = ro;
        if (ro) {
            this.modifPropButton = false;
        }
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    public MainPanel(String dev, Boolean stda, Boolean keepStateRef, Boolean modifProp, Boolean ro) {
        this();
        this.standAlone = stda;
        this.keepStateRefresher = keepStateRef;
        this.modifPropButton = modifProp;
        this.roMode = ro;
        if (ro.booleanValue()) {
            this.modifPropButton = false;
        }
        if (!this.connectDevice(dev)) {
            this.splash.setVisible(false);
            return;
        }
        this.initComponents();
        this.startUp();
    }

    private void createDevTestPanel(String devName) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, DevFailed {
        Object[] params;
        Class[] paramCls;
        Class<?> jiveExecDevClass = Class.forName("jive.ExecDev");
        Constructor<?> devTestPanelNew = jiveExecDevClass.getConstructor(paramCls = new Class[]{devName.getClass()});
        Object obj = devTestPanelNew.newInstance(params = new Object[]{devName});
        if (obj != null && obj instanceof JPanel) {
            JPanel devTestPanel = (JPanel)obj;
            this.tgDevtestDlg.setContentPane(devTestPanel);
            return;
        }
        this.tgDevtestDlg = null;
    }

    private boolean connectDevice(String devName) {
        String message;
        String versionText = new String(REVISION);
        int colon_idx = versionText.lastIndexOf(":");
        int dollar_idx = versionText.length();
        String versNumber = versionText.substring(colon_idx + 1, dollar_idx);
        this.splash.setTitle("AtkPanel  " + versNumber);
        this.splash.setCopyright("(c) ESRF 2002-2015");
        this.splash.setMessage("Waiting for device-name...");
        this.splash.initProgress();
        this.splash.setMaxProgress(12);
        if (devName == null) {
            this.splash.toBack();
            devName = JOptionPane.showInputDialog(null, (Object)"Please enter the device name");
            this.splash.toFront();
        }
        this.all_scalar_atts = new AttributeList();
        this.all_scalar_atts.setRefreshInterval(globalRefPeriod);
        this.all_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof IScalarAttribute || entity instanceof IBooleanScalar || entity instanceof IEnumScalar || entity instanceof IDevStateScalar) {
                    return !entity.getNameSansDevice().equalsIgnoreCase("Status") && !entity.getNameSansDevice().equalsIgnoreCase("State");
                }
                return false;
            }
        });
        this.op_scalar_atts = new AttributeList();
        this.op_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof IScalarAttribute || entity instanceof IBooleanScalar || entity instanceof IEnumScalar || entity instanceof IDevStateScalar) {
                    if (entity.getNameSansDevice().equalsIgnoreCase("Status") || entity.getNameSansDevice().equalsIgnoreCase("State")) {
                        return false;
                    }
                    if (entity.isOperator()) {
                        String message = "Adding Operator scalar attributes(";
                        MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                        return true;
                    }
                }
                return false;
            }
        });
        this.exp_scalar_atts = new AttributeList();
        this.exp_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof IScalarAttribute || entity instanceof IBooleanScalar || entity instanceof IEnumScalar || entity instanceof IDevStateScalar) {
                    if (entity.getNameSansDevice().equalsIgnoreCase("Status") || entity.getNameSansDevice().equalsIgnoreCase("State")) {
                        return false;
                    }
                    if (!entity.isOperator()) {
                        String message = "Adding Expert scalar attributes(";
                        MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                        return true;
                    }
                }
                return false;
            }
        });
        this.state_status_atts = new AttributeList();
        this.state_status_atts.setRefreshInterval(globalRefPeriod);
        this.numberAndState_scalar_atts = new AttributePolledList();
        this.numberAndState_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberScalar || entity instanceof IDevStateScalar) {
                    String message = "Adding number/state scalar attributes to trend (";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.boolean_scalar_atts = new AttributePolledList();
        this.boolean_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof IBooleanScalar) {
                    String message = "Adding boolean scalar attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.refUtil.setTabsRefreshInterval(globalRefPeriod);
        this.all_spectrum_atts = new AttributeList();
        this.all_spectrum_atts.setForceRefresh(true);
        this.all_spectrum_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberSpectrum || entity instanceof IStringSpectrum || entity instanceof IDevStateSpectrum || entity instanceof IBooleanSpectrum) {
                    String message = "Adding to all_spectrum_atts : ";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice());
                    return true;
                }
                return false;
            }
        });
        this.op_spectrum_atts = new AttributeList();
        this.op_spectrum_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if ((entity instanceof INumberSpectrum || entity instanceof IStringSpectrum || entity instanceof IDevStateSpectrum || entity instanceof IBooleanSpectrum) && entity.isOperator()) {
                    String message = "Adding to op_spectrum_atts : ";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.all_number_image_atts = new AttributeList();
        this.all_number_image_atts.setForceRefresh(true);
        this.all_number_image_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberImage) {
                    if (entity instanceof INumberSpectrum) {
                        return false;
                    }
                    String message = "Adding image attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.op_number_image_atts = new AttributeList();
        this.op_number_image_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof INumberImage) {
                    if (entity instanceof INumberSpectrum) {
                        return false;
                    }
                    if (entity.isOperator()) {
                        String message = "Adding image attributes(";
                        MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                        return true;
                    }
                }
                return false;
            }
        });
        this.all_string_image_atts = new AttributeList();
        this.all_string_image_atts.setForceRefresh(true);
        this.all_string_image_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof IStringImage) {
                    String message = "Adding String Image attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.op_string_image_atts = new AttributeList();
        this.op_string_image_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof IStringImage && entity.isOperator()) {
                    String message = "Adding String Image attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.all_raw_image_atts = new AttributeList();
        this.all_raw_image_atts.setForceRefresh(true);
        this.all_raw_image_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof IRawImage) {
                    String message = "Adding Raw Image attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.op_raw_image_atts = new AttributeList();
        this.op_raw_image_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof IRawImage && entity.isOperator()) {
                    String message = "Adding Raw Image attributes(";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.all_cmdl = new CommandList();
        this.op_cmdl = new CommandList();
        this.op_cmdl.setFilter(new IEntityFilter(){

            public boolean keep(IEntity entity) {
                if (entity instanceof ICommand && entity.isOperator()) {
                    String message = "Adding Operator command (";
                    MainPanel.this.splash.setMessage(message + entity.getNameSansDevice() + ")...");
                    return true;
                }
                return false;
            }
        });
        this.panelDev = null;
        this.errorHistory = new ErrorHistory();
        this.errorPopup = ErrorPopup.getInstance();
        this.all_scalar_atts.addErrorListener((IErrorListener)this.errorHistory);
        this.all_scalar_atts.addSetErrorListener((ISetErrorListener)this.errorPopup);
        this.all_scalar_atts.addSetErrorListener((ISetErrorListener)this.errorHistory);
        this.state_status_atts.addErrorListener((IErrorListener)this.errorHistory);
        this.all_spectrum_atts.addErrorListener((IErrorListener)this.errorHistory);
        this.all_number_image_atts.addErrorListener((IErrorListener)this.errorHistory);
        this.all_string_image_atts.addErrorListener((IErrorListener)this.errorHistory);
        this.all_raw_image_atts.addErrorListener((IErrorListener)this.errorHistory);
        this.all_cmdl.addErrorListener((IErrorListener)this.errorHistory);
        this.all_cmdl.addErrorListener((IErrorListener)this.errorPopup);
        try {
            message = "Getting device " + devName + "...";
            this.splash.setMessage(message);
            this.panelDev = DeviceFactory.getInstance().getDevice(devName);
            this.splash.progress(1);
            this.splash.setMessage(message + "done");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot connect to the device.\nCheck the device name you entered; Application will abort ...\nConnection Exception : " + e, "Connection to device failed", 0);
            System.out.println("AtkPanel: Cannot connect to the device.");
            System.out.println("AtkPanel: Check the device name you entered;");
            System.out.println("AtkPanel: Application aborted....");
            System.out.println("AtkPanel: Connection Exception : " + e);
            this.abortAppli();
            return false;
        }
        if (this.panelDev == null) {
            JOptionPane.showMessageDialog(null, "Cannot initialize the device object.\nCheck the device name you entered; Application will abort ...\n", "Device init failed", 0);
            System.out.println("AtkPanel: cannot initialize the device object.");
            System.out.println("AtkPanel: Check the device name you entered;");
            System.out.println("AtkPanel: Application aborted....");
            this.abortAppli();
            return false;
        }
        try {
            message = "Importing attributes from " + devName + "...";
            try {
                this.splash.setMessage(message);
                this.op_scalar_atts.add(devName + "/*");
                this.exp_scalar_atts.add(devName + "/*");
                this.numberAndState_scalar_atts.add(devName + "/*");
                this.boolean_scalar_atts.add(devName + "/*");
                this.splash.progress(4);
                this.all_spectrum_atts.add(devName + "/*");
                this.op_spectrum_atts.add(devName + "/*");
                this.splash.progress(5);
                this.all_number_image_atts.add(devName + "/*");
                this.op_number_image_atts.add(devName + "/*");
                this.splash.progress(6);
                this.all_string_image_atts.add(devName + "/*");
                this.op_string_image_atts.add(devName + "/*");
                this.splash.progress(7);
                this.all_raw_image_atts.add(devName + "/*");
                this.op_raw_image_atts.add(devName + "/*");
                this.splash.progress(7);
                this.splash.setMessage(message + "done");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Cannot build the attribute list.\nApplication will abort ...\nException received : " + e, "No Attribute Exception", 0);
                System.out.println("AtkPanel: Cannot build attribute list.");
                System.out.println("AtkPanel: Application aborted....");
                System.out.println("AtkPanel: Connection Exception : " + e);
                this.abortAppli();
                return false;
            }
            message = "Importing commands from " + devName + "...";
            this.all_cmdl.add(devName + "/*");
            this.op_cmdl.add(devName + "/*");
            this.splash.progress(7);
            this.splash.setMessage(message + "done");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot build the command list.\nApplication will abort ...\nException received : " + e, "No Command Exception", 0);
            System.out.println("AtkPanel: Cannot build the command list.");
            System.out.println("AtkPanel: Application aborted....");
            System.out.println("AtkPanel: Connection Exception : " + e);
            this.abortAppli();
            return false;
        }
        if (this.roMode) {
            return true;
        }
        this.setTitle("AtkPanel " + versNumber + " : " + devName);
        this.tgDevtestDlg = new JDialog((Frame)this, false);
        this.tgDevtestDlg.setTitle("Test Device : " + devName);
        try {
            this.createDevTestPanel(devName);
        }
        catch (ClassNotFoundException ex) {
            this.tgDevtestDlg = null;
        }
        catch (NoSuchMethodException ex) {
            this.tgDevtestDlg = null;
        }
        catch (IllegalArgumentException ex) {
            this.tgDevtestDlg = null;
        }
        catch (InvocationTargetException ex) {
            this.tgDevtestDlg = null;
        }
        catch (InstantiationException ex) {
            this.tgDevtestDlg = null;
        }
        catch (IllegalAccessException ex) {
            this.tgDevtestDlg = null;
        }
        catch (DevFailed ex) {
            this.tgDevtestDlg = null;
        }
        return true;
    }

    private void startUp() {
        if (this.tgDevtestDlg == null) {
            this.tgDevTestJMenuItem.setEnabled(false);
        }
        String message = "Initializing commands...";
        this.splash.setMessage(message);
        this.createAllCmdList();
        if (this.all_cmdl.getSize() > 0) {
            if (this.operatorView) {
                this.show_operator_commands();
            } else {
                this.show_all_commands();
            }
        }
        if (this.roMode) {
            this.commandComboViewer1.setVisible(false);
        }
        this.splash.progress(8);
        this.splash.setMessage(message + "done");
        message = "Initializing scalar attributes...";
        this.splash.setMessage(message);
        this.allScalarListViewer = null;
        this.operatorScalarListViewer = null;
        this.createAllScalarListViewers();
        this.globalTrend.setModel(this.numberAndState_scalar_atts);
        this.booleanTrend.setModel(this.boolean_scalar_atts);
        if (this.all_scalar_atts.getSize() > 0 && this.allScalarListViewer != null && this.operatorScalarListViewer != null) {
            if (this.operatorView) {
                this.show_operator_scalars();
                this.expertCheckBoxMenuItem.setState(false);
                this.operatorCheckBoxMenuItem.setState(true);
            } else {
                this.show_all_scalars();
                this.expertCheckBoxMenuItem.setState(true);
                this.operatorCheckBoxMenuItem.setState(false);
            }
        }
        try {
            this.stateAtt = (IDevStateScalar)this.state_status_atts.add(this.panelDev.getName() + "/State");
            this.statusAtt = (IStringScalar)this.state_status_atts.add(this.panelDev.getName() + "/Status");
        }
        catch (Exception e) {
            this.stateAtt = null;
            this.statusAtt = null;
        }
        if (this.stateAtt == null || this.statusAtt == null) {
            System.out.println("AtkPanel: Cannot get the State and / or Status attributes for the device.");
            System.out.println("AtkPanel: May be an old IDL 2 device server....");
            this.devStateViewer.setVisible(true);
            this.devStatusViewer.setVisible(true);
            this.attStateViewer.setVisible(false);
            this.attStatusViewer.setVisible(false);
        } else {
            this.devStateViewer.setVisible(false);
            this.devStatusViewer.setVisible(false);
            if (this.standAlone || !this.keepStateRefresher) {
                DeviceFactory.getInstance().stopRefresher();
            }
            this.attStateViewer.setModel(this.stateAtt);
            this.attStatusViewer.setModel(this.statusAtt);
            this.attStateViewer.setVisible(true);
            this.attStatusViewer.setVisible(true);
            if (!this.stateAtt.hasEvents() || !this.statusAtt.hasEvents()) {
                this.state_status_atts.startRefresher();
            }
        }
        this.splash.progress(10);
        this.splash.setMessage(message + "done");
        message = "Initializing number spectrum attributes...";
        this.splash.setMessage(message);
        this.createAllSpectrumTabs();
        if (this.all_spectrum_atts.getSize() > 0) {
            if (this.operatorView) {
                this.show_operator_spectrums();
            } else {
                this.show_all_spectrums();
            }
        }
        this.splash.progress(11);
        this.splash.setMessage(message + "done");
        message = "Initializing number image attributes...";
        this.splash.setMessage(message);
        this.createAllNumberImageTabs();
        if (this.all_number_image_atts.getSize() > 0) {
            if (this.operatorView) {
                this.show_operator_images();
            } else {
                this.show_all_images();
            }
        }
        this.createAllStringImageTabs();
        if (this.all_string_image_atts.getSize() > 0) {
            if (this.operatorView) {
                this.show_operator_string_images();
            } else {
                this.show_all_string_images();
            }
        }
        this.createAllRawImageTabs();
        if (this.all_raw_image_atts.getSize() > 0) {
            if (this.operatorView) {
                this.show_operator_raw_images();
            } else {
                this.show_all_raw_images();
            }
        }
        if (this.all_scalar_atts.getSize() <= 0 && this.all_spectrum_atts.getSize() <= 0 && this.all_number_image_atts.getSize() <= 0 && this.all_string_image_atts.getSize() <= 0 && this.all_raw_image_atts.getSize() <= 0) {
            this.jTabbedPane1.setVisible(false);
        }
        this.startAllRefresher();
        this.splash.progress(12);
        this.splash.setMessage(message + "done");
        this.splash.setMessage(message);
        this.showStartupTab();
        this.splash.setVisible(false);
        this.pack();
        if (wpos == null) {
            ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
        } else {
            ATKGraphicsUtils.positionFrameOnScreen((Frame)this, (int)wpos[0], (int)wpos[1]);
        }
        this.setVisible(true);
    }

    private void showStartupTab() {
        if (this.startupTabName == null) {
            return;
        }
        this.startupTabIndex = -1;
        int nbTabs = this.jTabbedPane1.getTabCount();
        for (int i = 0; i < nbTabs; ++i) {
            if (!this.jTabbedPane1.getTitleAt(i).equalsIgnoreCase(this.startupTabName)) continue;
            this.startupTabIndex = i;
            break;
        }
        if (this.startupTabIndex > 0) {
            try {
                this.jTabbedPane1.setSelectedIndex(this.startupTabIndex);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainPanel.this.exitForm(evt);
            }
        });
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem5 = new JMenuItem();
        this.boolTrendJMenuItem = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.diagJMenuItem = new JMenuItem();
        this.tgDevTestJMenuItem = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.setRefPeriodJMenuItem = new JMenuItem();
        this.timeoutJMenuItem = new JMenuItem();
        this.expertCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.operatorCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jMenu4 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.mainJSplitPane = new JSplitPane();
        this.mainJSplitPane.setOrientation(0);
        this.mainJSplitPane.setOneTouchExpandable(true);
        this.stateAndCmdJPanel = new JPanel();
        this.stateAndCmdJPanel.setLayout(new GridBagLayout());
        this.topJPanel = new JPanel();
        this.topJPanel.setLayout(new GridBagLayout());
        this.scrollJPanel = new JPanel();
        this.scrollJPanel.setLayout(new GridBagLayout());
        this.commandComboViewer1 = new CommandComboViewer();
        this.devStateViewer = new fr.esrf.tangoatk.widget.device.StateViewer();
        this.devStateViewer.setStateInTooltip(true);
        this.devStatusViewer = new StatusViewer();
        this.attStateViewer = new StateViewer();
        this.attStateViewer.setStateInTooltip(true);
        this.attStatusViewer = new fr.esrf.tangoatk.widget.attribute.StatusViewer();
        this.jTabbedPane1 = new JTabbedPane();
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int iSelectedIndex = MainPanel.this.jTabbedPane1.getSelectedIndex();
                MainPanel.this.setSelectedTabbedPaneIndex(iSelectedIndex);
            }
        });
        this.jScrollPane1 = new JScrollPane();
        this.devStateViewer.setStateClickable(false);
        this.devStatusViewer.setPreferredSize(new Dimension(50, 100));
        this.attStatusViewer.setPreferredSize(new Dimension(50, 100));
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Quit");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu3.setText("View");
        this.tgDevTestJMenuItem.setText("Test Device");
        this.tgDevTestJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.testDeviceActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.tgDevTestJMenuItem);
        this.jMenuItem5.setText("Numeric & State Trend ");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.viewTrendActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem5);
        this.boolTrendJMenuItem.setText("Boolean Trend ");
        this.boolTrendJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.viewBooleanTrendActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.boolTrendJMenuItem);
        this.jMenuItem3.setText("Error History");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.viewErrHistoryActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem3);
        this.diagJMenuItem.setText("Diagnostic ...");
        this.diagJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        this.jMenu3.add(this.diagJMenuItem);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu2.setText("Preferences");
        this.jMenuItem6.setText("Stop   Refreshing");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.stopStartRefreshActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem6);
        this.jMenuItem7.setText("Refresh  once");
        this.jMenuItem7.setEnabled(false);
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.refreshOnceActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem7);
        this.setRefPeriodJMenuItem.setText("Set refreshing period ...");
        this.setRefPeriodJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.refPeriodActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.setRefPeriodJMenuItem);
        this.timeoutJMenuItem.setText("Set device timeout ...");
        this.timeoutJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.setTimeoutActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.timeoutJMenuItem);
        JSeparator jsep = new JSeparator();
        this.jMenu2.add(jsep);
        this.operatorCheckBoxMenuItem.setSelected(true);
        this.operatorCheckBoxMenuItem.setText("Operator  View");
        this.operatorCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.operatorCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.operatorCheckBoxMenuItem);
        this.expertCheckBoxMenuItem.setSelected(false);
        this.expertCheckBoxMenuItem.setText("Expert  View");
        this.expertCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.expertCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.expertCheckBoxMenuItem);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu4.setText("Help");
        this.jMenuItem4.setText("On Version ...");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.helpVersionActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMenuItem4);
        this.jMenuBar1.add(this.jMenu4);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.stateAndCmdJPanel.add((Component)this.attStateViewer, gridBagConstraints1);
        this.devStateViewer.setModel((IDevice)this.panelDev);
        this.stateAndCmdJPanel.add((Component)this.devStateViewer, gridBagConstraints1);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        this.stateAndCmdJPanel.add((Component)this.commandComboViewer1, gridBagConstraints1);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        this.topJPanel.add((Component)this.stateAndCmdJPanel, gridBagConstraints1);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.topJPanel.add((Component)this.attStatusViewer, gridBagConstraints1);
        this.devStatusViewer.setModel((IDevice)this.panelDev);
        this.topJPanel.add((Component)this.devStatusViewer, gridBagConstraints1);
        this.mainJSplitPane.setTopComponent(this.topJPanel);
        this.jTabbedPane1.setTabPlacement(3);
        this.jScrollPane1.setViewportView(this.scrollJPanel);
        this.jTabbedPane1.addTab("Scalar", this.jScrollPane1);
        this.mainJSplitPane.setBottomComponent(this.jTabbedPane1);
        this.getContentPane().add((Component)this.mainJSplitPane, "Center");
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void setSelectedTabbedPaneIndex(int tabIndex) {
        Component comp;
        boolean previousCompWasRefreshing = false;
        if (this.iTabbedPaneIndex < this.jTabbedPane1.getTabCount()) {
            if (this.jTabbedPane1.getTitleAt(this.iTabbedPaneIndex).equalsIgnoreCase("Scalar")) {
                previousCompWasRefreshing = this.all_scalar_atts.isRefresherStarted();
                this.all_scalar_atts.stopRefresher();
            } else {
                previousCompWasRefreshing = this.refUtil.isRefreshing();
                comp = this.jTabbedPane1.getComponent(this.iTabbedPaneIndex);
                this.refUtil.disableRefreshComponent(comp);
            }
        }
        if (this.jTabbedPane1.getTitleAt(this.jTabbedPane1.getSelectedIndex()).equalsIgnoreCase("Scalar")) {
            if (previousCompWasRefreshing) {
                this.all_scalar_atts.startRefresher();
            }
        } else {
            comp = this.jTabbedPane1.getSelectedComponent();
            this.refUtil.refreshComponent(comp);
            this.refUtil.enableComponentRefresh(comp);
            if (previousCompWasRefreshing) {
                this.refUtil.startTabsRefresher();
            }
        }
        this.iTabbedPaneIndex = tabIndex;
    }

    private void refreshOnceActionPerformed(ActionEvent evt) {
        this.all_scalar_atts.refresh();
        this.refUtil.refreshAllComponents(this.jTabbedPane1);
        if (this.devStateViewer.isVisible() || this.devStatusViewer.isVisible()) {
            DeviceFactory.getInstance().refresh();
        } else if (this.stateAtt != null && this.statusAtt != null) {
            this.state_status_atts.refresh();
        }
    }

    private void stopStartRefreshActionPerformed(ActionEvent evt) {
        JMenuItem menuButton = (JMenuItem)evt.getSource();
        if (menuButton.getText().equalsIgnoreCase("Stop   Refreshing")) {
            this.refresherActivated = false;
            menuButton.setText("Start   Refreshing");
            this.jMenuItem7.setEnabled(true);
            this.stopAllRefresher();
        } else {
            this.refresherActivated = true;
            menuButton.setText("Stop   Refreshing");
            this.jMenuItem7.setEnabled(false);
            this.startAllRefresher();
        }
    }

    private void stopAllRefresher() {
        this.all_scalar_atts.stopRefresher();
        this.refUtil.stopTabsRefresher();
        this.numberAndState_scalar_atts.stopRefresher();
        this.boolean_scalar_atts.stopRefresher();
        if (!this.keepStateRefresher) {
            DeviceFactory.getInstance().stopRefresher();
        }
        if (this.stateAtt != null && this.statusAtt != null) {
            this.state_status_atts.stopRefresher();
        }
        this.refreshOnceActionPerformed(null);
    }

    private void startAllRefresher() {
        if (this.jTabbedPane1.getTitleAt(this.jTabbedPane1.getSelectedIndex()).equalsIgnoreCase("Scalar")) {
            this.all_scalar_atts.startRefresher();
        }
        this.refUtil.startTabsRefresher();
        if (this.devStateViewer.isVisible() || this.devStatusViewer.isVisible()) {
            DeviceFactory.getInstance().startRefresher();
        } else if (!(this.stateAtt == null || this.statusAtt == null || this.stateAtt.hasEvents() && this.statusAtt.hasEvents())) {
            this.state_status_atts.startRefresher();
        }
    }

    private void helpVersionActionPerformed(ActionEvent evt) {
        String versionText = new String(REVISION);
        int colon_idx = versionText.lastIndexOf(":");
        int dollar_idx = versionText.length();
        String versNumber = versionText.substring(colon_idx + 1, dollar_idx);
        try {
            JOptionPane.showMessageDialog(this, "\n\n   atkpanel   : " + versNumber + "\n\n   ESRF  :   Accelerator Control Unit \n\n", "atkpanel   Version", -1);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void testDeviceActionPerformed(ActionEvent evt) {
        if (this.tgDevtestDlg == null) {
            this.tgDevTestJMenuItem.setEnabled(false);
            return;
        }
        ATKGraphicsUtils.centerDialog((Dialog)this.tgDevtestDlg);
        this.tgDevtestDlg.setVisible(true);
    }

    private void viewTrendActionPerformed(ActionEvent evt) {
        ATKGraphicsUtils.centerFrame((JComponent)this.mainJSplitPane, (Frame)this.trendFrame);
        this.trendFrame.setVisible(true);
    }

    private void viewBooleanTrendActionPerformed(ActionEvent evt) {
        ATKGraphicsUtils.centerFrame((JComponent)this.mainJSplitPane, (Frame)this.booleanTrendFrame);
        this.booleanTrendFrame.setVisible(true);
    }

    private void refPeriodActionPerformed(ActionEvent evt) {
        int ref_period = -1;
        String refp_str = JOptionPane.showInputDialog(this, "Enter refresh interval (ms)", new Integer(globalRefPeriod));
        if (refp_str != null) {
            try {
                int it;
                globalRefPeriod = it = Integer.parseInt(refp_str);
                this.all_scalar_atts.setRefreshInterval(globalRefPeriod);
                this.refUtil.setTabsRefreshInterval(globalRefPeriod);
                if (!(this.devStateViewer.isVisible() || this.devStatusViewer.isVisible() || this.stateAtt == null || this.statusAtt == null || this.stateAtt.hasEvents() && this.statusAtt.hasEvents())) {
                    this.state_status_atts.setRefreshInterval(globalRefPeriod);
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Invalid number !", "Error", 0);
                return;
            }
        }
    }

    private void setTimeoutActionPerformed(ActionEvent evt) {
        int devTmout = -1;
        if (this.panelDev == null) {
            return;
        }
        try {
            devTmout = this.panelDev.getDevTimeout();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Cannot  get the timeout for the device.\nCheck the device still repsonding.\n\nConnection Exception : " + ex, "getDevTimeout failed", 0);
            return;
        }
        String tmout_str = JOptionPane.showInputDialog(this, "Enter timeout for device (ms)", new Integer(devTmout));
        if (tmout_str != null) {
            try {
                int it = Integer.parseInt(tmout_str);
                this.panelDev.setDevTimeout(it);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Cannot set timeout. Invalid number !", "Error", 0);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Cannot  set the timeout for the device.\nCheck the device still repsonding.\n\nConnection Exception : " + ex, "setDevTimeout failed", 0);
                return;
            }
        }
    }

    private void viewErrHistoryActionPerformed(ActionEvent evt) {
        this.errorHistory.setVisible(true);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.stopAtkPanel();
    }

    private void expertCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.all_cmdl.getSize() > 0) {
            this.show_all_commands();
        }
        if (this.all_number_image_atts.getSize() > 0) {
            this.show_all_images();
        }
        if (this.all_string_image_atts.getSize() > 0) {
            this.show_all_string_images();
        }
        if (this.all_raw_image_atts.getSize() > 0) {
            this.show_all_raw_images();
        }
        if (this.all_spectrum_atts.getSize() > 0) {
            this.show_all_spectrums();
        }
        if (this.all_scalar_atts.getSize() > 0) {
            this.show_all_scalars();
        }
        this.expertCheckBoxMenuItem.setState(true);
        this.operatorCheckBoxMenuItem.setState(false);
    }

    private void operatorCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        if (this.all_cmdl.getSize() > 0) {
            this.show_operator_commands();
        }
        if (this.all_number_image_atts.getSize() > 0) {
            this.show_operator_images();
        }
        if (this.all_string_image_atts.getSize() > 0) {
            this.show_operator_string_images();
        }
        if (this.all_raw_image_atts.getSize() > 0) {
            this.show_operator_raw_images();
        }
        if (this.all_spectrum_atts.getSize() > 0) {
            this.show_operator_spectrums();
        }
        if (this.all_scalar_atts.getSize() > 0) {
            this.show_operator_scalars();
        }
        this.expertCheckBoxMenuItem.setState(false);
        this.operatorCheckBoxMenuItem.setState(true);
    }

    private void clearAllModels() {
        this.devStatusViewer.setModel(null);
        this.devStateViewer.clearModel();
        this.state_status_atts.removeErrorListener((IErrorListener)this.errorHistory);
        if (this.stateAtt != null && this.statusAtt != null) {
            this.attStateViewer.setModel(null);
            this.attStatusViewer.setModel(null);
        }
        if (this.globalTrend != null) {
            this.globalTrend.clearModel();
        }
        if (this.booleanTrend != null) {
            this.booleanTrend.clearModel();
        }
        if (this.allScalarListViewer != null) {
            this.allScalarListViewer.setModel(null);
        }
        if (this.operatorScalarListViewer != null) {
            this.operatorScalarListViewer.setModel(null);
        }
        this.all_scalar_atts.removeErrorListener((IErrorListener)this.errorHistory);
        this.all_scalar_atts.removeSetErrorListener((ISetErrorListener)this.errorHistory);
        this.all_scalar_atts.removeSetErrorListener((ISetErrorListener)this.errorPopup);
        for (JComponent sPanel : this.all_spectrum_panels) {
            if (sPanel instanceof SpectrumPanel) {
                SpectrumPanel nsPanel = (SpectrumPanel)sPanel;
                nsPanel.clearModel();
                continue;
            }
            if (sPanel instanceof StringSpectrumPanel) {
                StringSpectrumPanel ssPanel = (StringSpectrumPanel)sPanel;
                ssPanel.clearModel();
                continue;
            }
            if (sPanel instanceof DevStateSpectrumPanel) {
                DevStateSpectrumPanel dsPanel = (DevStateSpectrumPanel)sPanel;
                dsPanel.clearModel();
                continue;
            }
            if (!(sPanel instanceof BooleanSpectrumPanel)) continue;
            BooleanSpectrumPanel bsPanel = (BooleanSpectrumPanel)sPanel;
            bsPanel.clearModel();
        }
        this.all_spectrum_atts.removeErrorListener((IErrorListener)this.errorHistory);
        for (ImagePanel nimPanel : this.all_image_panels) {
            if (nimPanel == null) continue;
            nimPanel.clearModel();
        }
        this.all_number_image_atts.removeErrorListener((IErrorListener)this.errorHistory);
        for (StringImagePanel simPanel : this.all_string_image_panels) {
            if (simPanel == null) continue;
            simPanel.clearModel();
        }
        this.all_string_image_atts.removeErrorListener((IErrorListener)this.errorHistory);
        for (RawImagePanel rimPanel : this.all_raw_image_panels) {
            if (rimPanel == null) continue;
            rimPanel.clearModel();
        }
        this.all_raw_image_atts.removeErrorListener((IErrorListener)this.errorHistory);
        this.all_cmdl.removeErrorListener((IErrorListener)this.errorHistory);
    }

    private void stopAtkPanel() {
        if (this.standAlone) {
            System.exit(0);
        } else {
            this.all_scalar_atts.stopRefresher();
            this.refUtil.stopTabsRefresher();
            this.numberAndState_scalar_atts.stopRefresher();
            this.boolean_scalar_atts.stopRefresher();
            if (!this.keepStateRefresher) {
                DeviceFactory.getInstance().stopRefresher();
            }
            if (this.stateAtt != null && this.statusAtt != null) {
                this.state_status_atts.stopRefresher();
                this.attStateViewer.setModel(null);
                this.attStatusViewer.setModel(null);
            }
            this.clearAllModels();
            this.dispose();
        }
    }

    private void exitForm(WindowEvent evt) {
        this.stopAtkPanel();
    }

    private void abortAppli() {
        if (this.standAlone) {
            System.exit(-1);
        } else {
            this.splash.setVisible(false);
            this.all_scalar_atts.stopRefresher();
            this.refUtil.stopTabsRefresher();
            this.numberAndState_scalar_atts.stopRefresher();
            this.boolean_scalar_atts.stopRefresher();
            if (!this.keepStateRefresher) {
                DeviceFactory.getInstance().stopRefresher();
            }
            if (this.stateAtt != null && this.statusAtt != null) {
                this.state_status_atts.stopRefresher();
            }
            this.dispose();
        }
    }

    private void createAllScalarListViewers() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.allScalarListViewer = null;
        this.operatorScalarListViewer = null;
        if (this.op_scalar_atts.getSize() <= 0 && this.exp_scalar_atts.getSize() <= 0) {
            JLabel noatt = new JLabel();
            noatt.setText("No   attribute ");
            noatt.setFont(new Font("Helvetica", 0, 18));
            noatt.setForeground(Color.black);
            this.scrollJPanel.add((Component)noatt, gbc);
        } else {
            IEntity ie;
            int ind;
            for (ind = 0; ind < this.op_scalar_atts.getSize(); ++ind) {
                ie = (IEntity)this.op_scalar_atts.get(ind);
                this.all_scalar_atts.add(ie);
            }
            for (ind = 0; ind < this.exp_scalar_atts.getSize(); ++ind) {
                ie = (IEntity)this.exp_scalar_atts.get(ind);
                this.all_scalar_atts.add(ie);
            }
            this.allScalarListViewer = new ScalarListViewer();
            this.operatorScalarListViewer = new ScalarListViewer();
            this.allScalarListViewer.setToolTipDisplay("All");
            this.operatorScalarListViewer.setToolTipDisplay("All");
            if (!this.modifPropButton) {
                this.allScalarListViewer.setPropertyButtonVisible(false);
                this.operatorScalarListViewer.setPropertyButtonVisible(false);
            }
            if (this.roMode) {
                this.allScalarListViewer.setSetterVisible(false);
                this.operatorScalarListViewer.setSetterVisible(false);
            }
            this.allScalarListViewer.setTheFont(new Font("Dialog", 0, 14));
            this.allScalarListViewer.setBooleanSetterType("BooleanComboEditor");
            this.allScalarListViewer.setModel(this.all_scalar_atts);
            this.operatorScalarListViewer.setTheFont(new Font("Dialog", 0, 14));
            this.operatorScalarListViewer.setBooleanSetterType("BooleanComboEditor");
            this.operatorScalarListViewer.setModel(this.op_scalar_atts);
        }
    }

    private void show_all_scalars() {
        int neededWidth = this.allScalarListViewer.getPreferredSize().width;
        int neededHeight = this.allScalarListViewer.getPreferredSize().height;
        if (neededWidth < 220) {
            neededWidth = 220;
        }
        if (neededWidth > 570) {
            neededWidth = 570;
        }
        if (neededHeight < 220) {
            neededHeight = 220;
        }
        if (neededHeight > 570) {
            neededHeight = 570;
        }
        this.jScrollPane1.setViewportView((Component)this.allScalarListViewer);
        this.jTabbedPane1.setPreferredSize(new Dimension(neededWidth + 30, neededHeight + 30));
        this.pack();
    }

    private void show_operator_scalars() {
        int neededWidth = this.operatorScalarListViewer.getPreferredSize().width;
        int neededHeight = this.operatorScalarListViewer.getPreferredSize().height;
        if (neededWidth < 220) {
            neededWidth = 220;
        }
        if (neededWidth > 570) {
            neededWidth = 570;
        }
        if (neededHeight < 220) {
            neededHeight = 220;
        }
        if (neededHeight > 570) {
            neededHeight = 570;
        }
        this.jScrollPane1.setViewportView((Component)this.operatorScalarListViewer);
        this.jTabbedPane1.setPreferredSize(new Dimension(neededWidth + 30, neededHeight + 30));
        this.pack();
    }

    private void createAllSpectrumTabs() {
        IEntity ie;
        IEntity spectrum_att = null;
        INumberSpectrum nb_spectrum_att = null;
        IStringSpectrum str_spectrum_att = null;
        IDevStateSpectrum ds_spectrum_att = null;
        IBooleanSpectrum bool_spectrum_att = null;
        this.all_spectrum_panels = new Vector<JComponent>();
        int nb_atts = this.all_spectrum_atts.getSize();
        if (nb_atts > 0) {
            int ind;
            AttributeList all_sorted_spectrum_atts = new AttributeList();
            for (ind = 0; ind < this.op_spectrum_atts.getSize(); ++ind) {
                ie = (IEntity)this.op_spectrum_atts.get(ind);
                all_sorted_spectrum_atts.add(ie);
            }
            for (ind = 0; ind < this.all_spectrum_atts.getSize(); ++ind) {
                ie = (IEntity)this.all_spectrum_atts.get(ind);
                if (!ie.isExpert()) continue;
                all_sorted_spectrum_atts.add(ie);
            }
            this.all_spectrum_atts = all_sorted_spectrum_atts;
        }
        nb_atts = this.all_spectrum_atts.getSize();
        for (int idx = 0; idx < nb_atts; ++idx) {
            spectrum_att = (IEntity)this.all_spectrum_atts.getElementAt(idx);
            if (spectrum_att instanceof INumberSpectrum) {
                nb_spectrum_att = (INumberSpectrum)spectrum_att;
                SpectrumPanel sp_panel = new SpectrumPanel(nb_spectrum_att);
                this.jTabbedPane1.addTab(nb_spectrum_att.getNameSansDevice(), sp_panel);
                this.all_spectrum_panels.add(idx, sp_panel);
                if (this.all_scalar_atts.getSize() <= 0 || !nb_spectrum_att.hasMinxMaxxAttributes()) continue;
                String attFullName = null;
                INumberScalar minAtt = null;
                INumberScalar maxAtt = null;
                if (nb_spectrum_att.getMinxAttName() != null && nb_spectrum_att.getMaxxAttName() != null) {
                    attFullName = nb_spectrum_att.getDevice().getName() + "/" + nb_spectrum_att.getMinxAttName();
                    ie = this.all_scalar_atts.get(attFullName);
                    if (ie != null && ie instanceof INumberScalar) {
                        minAtt = (INumberScalar)ie;
                    }
                    if ((ie = this.all_scalar_atts.get(attFullName = nb_spectrum_att.getDevice().getName() + "/" + nb_spectrum_att.getMaxxAttName())) != null && ie instanceof INumberScalar) {
                        maxAtt = (INumberScalar)ie;
                    }
                }
                if (minAtt == null || maxAtt == null) continue;
                sp_panel.setXminXmaxModels(minAtt, maxAtt);
                continue;
            }
            if (spectrum_att instanceof IStringSpectrum) {
                str_spectrum_att = (IStringSpectrum)spectrum_att;
                StringSpectrumPanel str_sp_panel = new StringSpectrumPanel(str_spectrum_att);
                this.jTabbedPane1.addTab(str_spectrum_att.getNameSansDevice(), str_sp_panel);
                this.all_spectrum_panels.add(idx, str_sp_panel);
                continue;
            }
            if (spectrum_att instanceof IDevStateSpectrum) {
                ds_spectrum_att = (IDevStateSpectrum)spectrum_att;
                DevStateSpectrumPanel ds_sp_panel = new DevStateSpectrumPanel(ds_spectrum_att);
                this.jTabbedPane1.addTab(ds_spectrum_att.getNameSansDevice(), ds_sp_panel);
                this.all_spectrum_panels.add(idx, ds_sp_panel);
                continue;
            }
            if (!(spectrum_att instanceof IBooleanSpectrum)) continue;
            bool_spectrum_att = (IBooleanSpectrum)spectrum_att;
            BooleanSpectrumPanel bool_sp_panel = new BooleanSpectrumPanel(bool_spectrum_att);
            this.jTabbedPane1.addTab(bool_spectrum_att.getNameSansDevice(), bool_sp_panel);
            this.all_spectrum_panels.add(idx, bool_sp_panel);
        }
    }

    private void show_operator_spectrums() {
        int nb_tabs = 0;
        Component specPanel = null;
        INumberSpectrum nSpecAtt = null;
        IStringSpectrum strSpecAtt = null;
        IDevStateSpectrum dsSpecAtt = null;
        IBooleanSpectrum boolSpecAtt = null;
        nb_tabs = this.jTabbedPane1.getTabCount();
        for (int ind = 1; ind < nb_tabs; ++ind) {
            BooleanSpectrumPanel boolsp;
            int specInd;
            specPanel = this.jTabbedPane1.getComponentAt(ind);
            if (specPanel instanceof SpectrumPanel) {
                SpectrumPanel sp = (SpectrumPanel)specPanel;
                nSpecAtt = sp.getModel();
                specInd = this.op_spectrum_atts.indexOf((Object)nSpecAtt);
                if (specInd >= 0) continue;
                this.jTabbedPane1.removeTabAt(ind);
                nb_tabs = this.jTabbedPane1.getTabCount();
                --ind;
                continue;
            }
            if (specPanel instanceof StringSpectrumPanel) {
                StringSpectrumPanel strsp = (StringSpectrumPanel)specPanel;
                strSpecAtt = strsp.getModel();
                specInd = this.op_spectrum_atts.indexOf((Object)strSpecAtt);
                if (specInd >= 0) continue;
                this.jTabbedPane1.removeTabAt(ind);
                nb_tabs = this.jTabbedPane1.getTabCount();
                --ind;
                continue;
            }
            if (specPanel instanceof DevStateSpectrumPanel) {
                DevStateSpectrumPanel dssp = (DevStateSpectrumPanel)specPanel;
                dsSpecAtt = dssp.getModel();
                specInd = this.op_spectrum_atts.indexOf((Object)dsSpecAtt);
                if (specInd >= 0) continue;
                this.jTabbedPane1.removeTabAt(ind);
                nb_tabs = this.jTabbedPane1.getTabCount();
                --ind;
                continue;
            }
            if (!(specPanel instanceof BooleanSpectrumPanel) || (specInd = this.op_spectrum_atts.indexOf((Object)(boolSpecAtt = (boolsp = (BooleanSpectrumPanel)specPanel).getModel()))) >= 0) continue;
            this.jTabbedPane1.removeTabAt(ind);
            nb_tabs = this.jTabbedPane1.getTabCount();
            --ind;
        }
    }

    private void show_all_spectrums() {
        int nb_spectrums = 0;
        Object obj = null;
        JComponent spPanel = null;
        SpectrumPanel specPanel = null;
        StringSpectrumPanel strspecPanel = null;
        DevStateSpectrumPanel dsspecPanel = null;
        BooleanSpectrumPanel boolspecPanel = null;
        INumberSpectrum nSpecAtt = null;
        IStringSpectrum strSpecAtt = null;
        IDevStateSpectrum dsSpecAtt = null;
        IBooleanSpectrum boolSpecAtt = null;
        nb_spectrums = this.all_spectrum_atts.getSize();
        for (int ind = 0; ind < nb_spectrums; ++ind) {
            int specInd;
            obj = this.all_spectrum_atts.get(ind);
            if (obj instanceof INumberSpectrum) {
                nSpecAtt = (INumberSpectrum)obj;
                specInd = this.jTabbedPane1.indexOfTab(nSpecAtt.getNameSansDevice());
                if (specInd >= 0 || !((spPanel = this.all_spectrum_panels.get(ind)) instanceof SpectrumPanel)) continue;
                specPanel = (SpectrumPanel)spPanel;
                this.jTabbedPane1.addTab(nSpecAtt.getNameSansDevice(), specPanel);
                continue;
            }
            if (obj instanceof IStringSpectrum) {
                strSpecAtt = (IStringSpectrum)obj;
                specInd = this.jTabbedPane1.indexOfTab(strSpecAtt.getNameSansDevice());
                if (specInd >= 0 || !((spPanel = this.all_spectrum_panels.get(ind)) instanceof StringSpectrumPanel)) continue;
                strspecPanel = (StringSpectrumPanel)spPanel;
                this.jTabbedPane1.addTab(strSpecAtt.getNameSansDevice(), strspecPanel);
                continue;
            }
            if (obj instanceof IDevStateSpectrum) {
                dsSpecAtt = (IDevStateSpectrum)obj;
                specInd = this.jTabbedPane1.indexOfTab(dsSpecAtt.getNameSansDevice());
                if (specInd >= 0 || !((spPanel = this.all_spectrum_panels.get(ind)) instanceof DevStateSpectrumPanel)) continue;
                dsspecPanel = (DevStateSpectrumPanel)spPanel;
                this.jTabbedPane1.addTab(dsSpecAtt.getNameSansDevice(), dsspecPanel);
                continue;
            }
            if (!(obj instanceof IBooleanSpectrum) || (specInd = this.jTabbedPane1.indexOfTab((boolSpecAtt = (IBooleanSpectrum)obj).getNameSansDevice())) >= 0 || !((spPanel = this.all_spectrum_panels.get(ind)) instanceof BooleanSpectrumPanel)) continue;
            boolspecPanel = (BooleanSpectrumPanel)spPanel;
            this.jTabbedPane1.addTab(boolSpecAtt.getNameSansDevice(), boolspecPanel);
        }
    }

    private void createAllNumberImageTabs() {
        INumberImage image_att = null;
        this.all_image_panels = new Vector<ImagePanel>();
        int nb_atts = this.all_number_image_atts.getSize();
        if (nb_atts > 0) {
            IEntity ie;
            int ind;
            AttributeList all_sorted_image_atts = new AttributeList();
            for (ind = 0; ind < this.op_number_image_atts.getSize(); ++ind) {
                ie = (IEntity)this.op_number_image_atts.get(ind);
                all_sorted_image_atts.add(ie);
            }
            for (ind = 0; ind < this.all_number_image_atts.getSize(); ++ind) {
                ie = (IEntity)this.all_number_image_atts.get(ind);
                if (!ie.isExpert()) continue;
                all_sorted_image_atts.add(ie);
            }
            this.all_number_image_atts = all_sorted_image_atts;
        }
        nb_atts = this.all_number_image_atts.getSize();
        for (int idx = 0; idx < nb_atts; ++idx) {
            image_att = (INumberImage)this.all_number_image_atts.getElementAt(idx);
            ImagePanel att_tab = new ImagePanel(image_att);
            this.jTabbedPane1.addTab(image_att.getNameSansDevice(), att_tab);
            this.all_image_panels.add(idx, att_tab);
        }
    }

    private void show_operator_images() {
        int nb_tabs = 0;
        Component imagePanel = null;
        INumberImage nImageAtt = null;
        nb_tabs = this.jTabbedPane1.getTabCount();
        for (int ind = 1; ind < nb_tabs; ++ind) {
            ImagePanel ip;
            int imageInd;
            imagePanel = this.jTabbedPane1.getComponentAt(ind);
            if (!(imagePanel instanceof ImagePanel) || (imageInd = this.op_number_image_atts.indexOf((Object)(nImageAtt = (ip = (ImagePanel)imagePanel).getModel()))) >= 0) continue;
            this.jTabbedPane1.removeTabAt(ind);
            nb_tabs = this.jTabbedPane1.getTabCount();
            --ind;
        }
    }

    private void show_all_images() {
        int nb_images = 0;
        Object obj = null;
        ImagePanel imagePanel = null;
        INumberImage nImageAtt = null;
        nb_images = this.all_number_image_atts.getSize();
        for (int ind = 0; ind < nb_images; ++ind) {
            int imageInd;
            obj = this.all_number_image_atts.get(ind);
            if (!(obj instanceof INumberImage) || (imageInd = this.jTabbedPane1.indexOfTab((nImageAtt = (INumberImage)obj).getNameSansDevice())) >= 0) continue;
            imagePanel = this.all_image_panels.get(ind);
            this.jTabbedPane1.addTab(nImageAtt.getNameSansDevice(), imagePanel);
        }
    }

    private void createAllStringImageTabs() {
        IStringImage image_att = null;
        this.all_string_image_panels = new Vector<StringImagePanel>();
        int nb_atts = this.all_string_image_atts.getSize();
        if (nb_atts > 0) {
            IEntity ie;
            int ind;
            AttributeList all_sorted_image_atts = new AttributeList();
            for (ind = 0; ind < this.op_string_image_atts.getSize(); ++ind) {
                ie = (IEntity)this.op_string_image_atts.get(ind);
                all_sorted_image_atts.add(ie);
            }
            for (ind = 0; ind < this.all_string_image_atts.getSize(); ++ind) {
                ie = (IEntity)this.all_string_image_atts.get(ind);
                if (!ie.isExpert()) continue;
                all_sorted_image_atts.add(ie);
            }
            this.all_string_image_atts = all_sorted_image_atts;
        }
        nb_atts = this.all_string_image_atts.getSize();
        for (int idx = 0; idx < nb_atts; ++idx) {
            image_att = (IStringImage)this.all_string_image_atts.getElementAt(idx);
            StringImagePanel att_tab = new StringImagePanel(image_att);
            this.jTabbedPane1.addTab(image_att.getNameSansDevice(), att_tab);
            this.all_string_image_panels.add(idx, att_tab);
        }
    }

    private void show_operator_string_images() {
        int nb_tabs = 0;
        Component imagePanel = null;
        IStringImage sImageAtt = null;
        nb_tabs = this.jTabbedPane1.getTabCount();
        for (int ind = 1; ind < nb_tabs; ++ind) {
            StringImagePanel ip;
            int imageInd;
            imagePanel = this.jTabbedPane1.getComponentAt(ind);
            if (!(imagePanel instanceof StringImagePanel) || (imageInd = this.op_string_image_atts.indexOf((Object)(sImageAtt = (ip = (StringImagePanel)imagePanel).getModel()))) >= 0) continue;
            this.jTabbedPane1.removeTabAt(ind);
            nb_tabs = this.jTabbedPane1.getTabCount();
            --ind;
        }
    }

    private void show_all_string_images() {
        int nb_images = 0;
        Object obj = null;
        StringImagePanel strImagePanel = null;
        IStringImage sImageAtt = null;
        nb_images = this.all_string_image_atts.getSize();
        for (int ind = 0; ind < nb_images; ++ind) {
            int imageInd;
            obj = this.all_string_image_atts.get(ind);
            if (!(obj instanceof IStringImage) || (imageInd = this.jTabbedPane1.indexOfTab((sImageAtt = (IStringImage)obj).getNameSansDevice())) >= 0) continue;
            strImagePanel = this.all_string_image_panels.get(ind);
            this.jTabbedPane1.addTab(sImageAtt.getNameSansDevice(), strImagePanel);
        }
    }

    private void createAllRawImageTabs() {
        IRawImage image_att = null;
        this.all_raw_image_panels = new Vector<RawImagePanel>();
        int nb_atts = this.all_raw_image_atts.getSize();
        if (nb_atts > 0) {
            IEntity ie;
            int ind;
            AttributeList all_sorted_raw_image_atts = new AttributeList();
            for (ind = 0; ind < this.op_raw_image_atts.getSize(); ++ind) {
                ie = (IEntity)this.op_raw_image_atts.get(ind);
                all_sorted_raw_image_atts.add(ie);
            }
            for (ind = 0; ind < this.all_raw_image_atts.getSize(); ++ind) {
                ie = (IEntity)this.all_raw_image_atts.get(ind);
                if (!ie.isExpert()) continue;
                all_sorted_raw_image_atts.add(ie);
            }
            this.all_raw_image_atts = all_sorted_raw_image_atts;
        }
        nb_atts = this.all_raw_image_atts.getSize();
        for (int idx = 0; idx < nb_atts; ++idx) {
            image_att = (IRawImage)this.all_raw_image_atts.getElementAt(idx);
            RawImagePanel att_tab = new RawImagePanel(image_att);
            this.jTabbedPane1.addTab(image_att.getNameSansDevice(), att_tab);
            this.all_raw_image_panels.add(idx, att_tab);
        }
    }

    private void show_operator_raw_images() {
        int nb_tabs = 0;
        Component imagePanel = null;
        IRawImage rawImageAtt = null;
        nb_tabs = this.jTabbedPane1.getTabCount();
        for (int ind = 1; ind < nb_tabs; ++ind) {
            RawImagePanel rip;
            int imageInd;
            imagePanel = this.jTabbedPane1.getComponentAt(ind);
            if (!(imagePanel instanceof RawImagePanel) || (imageInd = this.op_raw_image_atts.indexOf((Object)(rawImageAtt = (rip = (RawImagePanel)imagePanel).getModel()))) >= 0) continue;
            this.jTabbedPane1.removeTabAt(ind);
            nb_tabs = this.jTabbedPane1.getTabCount();
            --ind;
        }
    }

    private void show_all_raw_images() {
        int nb_images = 0;
        Object obj = null;
        RawImagePanel rawImagePanel = null;
        IRawImage rawImageAtt = null;
        nb_images = this.all_raw_image_atts.getSize();
        for (int ind = 0; ind < nb_images; ++ind) {
            int imageInd;
            obj = this.all_raw_image_atts.get(ind);
            if (!(obj instanceof IRawImage) || (imageInd = this.jTabbedPane1.indexOfTab((rawImageAtt = (IRawImage)obj).getNameSansDevice())) >= 0) continue;
            rawImagePanel = this.all_raw_image_panels.get(ind);
            this.jTabbedPane1.addTab(rawImageAtt.getNameSansDevice(), rawImagePanel);
        }
    }

    private void createAllCmdList() {
        int nb_cmds = this.all_cmdl.getSize();
        if (nb_cmds > 0) {
            IEntity ie;
            int ind;
            CommandList all_sorted_cmds = new CommandList();
            for (ind = 0; ind < this.op_cmdl.getSize(); ++ind) {
                ie = (IEntity)this.op_cmdl.get(ind);
                all_sorted_cmds.add(ie);
            }
            for (ind = 0; ind < this.all_cmdl.getSize(); ++ind) {
                ie = (IEntity)this.all_cmdl.get(ind);
                if (!ie.isExpert()) continue;
                all_sorted_cmds.add(ie);
            }
            this.all_cmdl = all_sorted_cmds;
            this.commandComboViewer1.setModel(this.all_cmdl);
        } else {
            this.commandComboViewer1.setModel(null);
        }
    }

    private void show_operator_commands() {
        if (this.all_cmdl.getSize() > 0) {
            this.commandComboViewer1.setModel(this.op_cmdl);
        }
    }

    private void show_all_commands() {
        if (this.all_cmdl.getSize() > 0) {
            this.commandComboViewer1.setModel(this.all_cmdl);
        }
    }

    public void setExpertView(boolean expView) {
        boolean currentExpview = this.expertCheckBoxMenuItem.isSelected();
        if (currentExpview == expView) {
            return;
        }
        if (expView) {
            this.expertCheckBoxMenuItem.doClick();
        } else {
            this.operatorCheckBoxMenuItem.doClick();
        }
    }

    public void doFileQuit() {
        this.jMenuItem1.doClick();
    }

    private static boolean getReadOnly(String[] args) {
        if (args.length <= 0) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-ro")) continue;
            return true;
        }
        return false;
    }

    private static int getRefIntervalFromArgs(String[] args) {
        if (args.length <= 0) {
            return -1;
        }
        String refIntStr = null;
        int refInterval = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-refresh")) continue;
            if (++i >= args.length) break;
            refIntStr = args[i];
            break;
        }
        if (refIntStr == null) {
            return -1;
        }
        try {
            refInterval = Integer.parseInt(refIntStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return refInterval;
    }

    private static boolean getExpertView(String[] args) {
        if (args.length <= 0) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-expert")) continue;
            return true;
        }
        return false;
    }

    private static String getDevName(String[] args) {
        if (args.length <= 0) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].contains("/")) {
                    return args[i];
                }
                Device dv = null;
                try {
                    dv = new Device(args[i]);
                    return args[i];
                }
                catch (DevFailed devFailed) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getTabName(String[] args) {
        if (args.length < 1) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-ro") || args[i].equalsIgnoreCase("-expert") || args[i].equalsIgnoreCase("-refresh") || args[i].equalsIgnoreCase("-wpos")) continue;
            try {
                if (args[i].contains("/")) continue;
                return args[i];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String[] removeArg(String[] args, String option) {
        ArrayList<String> al = new ArrayList<String>();
        if (option.equalsIgnoreCase("-wpos")) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-wpos")) {
                    ++i;
                    continue;
                }
                al.add(args[i]);
            }
            String[] newArgs = new String[al.size()];
            newArgs = al.toArray(newArgs);
            return newArgs;
        }
        if (option.equalsIgnoreCase("-refresh")) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-refresh")) {
                    ++i;
                    continue;
                }
                al.add(args[i]);
            }
            String[] newArgs = new String[al.size()];
            newArgs = al.toArray(newArgs);
            return newArgs;
        }
        if (option.equalsIgnoreCase("-expert")) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-expert")) continue;
                al.add(args[i]);
            }
            String[] newArgs = new String[al.size()];
            newArgs = al.toArray(newArgs);
            return newArgs;
        }
        if (option.equalsIgnoreCase("-ro")) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-ro")) continue;
                al.add(args[i]);
            }
            String[] newArgs = new String[al.size()];
            newArgs = al.toArray(newArgs);
            return newArgs;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(option)) continue;
            al.add(args[i]);
        }
        if (al.isEmpty()) {
            return args;
        }
        String[] newArgs = new String[al.size()];
        newArgs = al.toArray(newArgs);
        return newArgs;
    }

    public static void main(String[] args) {
        MainPanel mp = null;
        boolean ro = false;
        boolean expertView = false;
        if (args.length <= 0) {
            mp = new MainPanel(null, true, false);
        } else {
            String dev_name;
            int refIt;
            wpos = ATKGraphicsUtils.getWindowPosFromArgs((String[])args);
            if (wpos != null) {
                args = MainPanel.removeArg(args, "-wpos");
            }
            if ((refIt = MainPanel.getRefIntervalFromArgs(args)) > 0) {
                globalRefPeriod = refIt;
                args = MainPanel.removeArg(args, "-refresh");
            }
            if (expertView = MainPanel.getExpertView(args)) {
                args = MainPanel.removeArg(args, "-expert");
            }
            if (ro = MainPanel.getReadOnly(args)) {
                args = MainPanel.removeArg(args, "-ro");
            }
            if ((dev_name = MainPanel.getDevName(args)) != null) {
                args = MainPanel.removeArg(args, dev_name);
            }
            String tab_name = MainPanel.getTabName(args);
            mp = dev_name == null ? (ro ? new MainPanel(dev_name, true, false, false, true) : new MainPanel(dev_name, true, false)) : (tab_name == null ? (ro ? new MainPanel(dev_name, true, false, false, true) : new MainPanel(dev_name, true, false)) : (ro ? new MainPanel(dev_name, tab_name, true, false, false, true) : new MainPanel(dev_name, tab_name, true, false)));
        }
        if (mp != null) {
            mp.setExpertView(expertView);
        }
    }
}

