/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jdraw;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributePolledList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IEntityFilter;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.jdraw.TangoSynopticHandler;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.SplashTimer;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.MissingResourceException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SimpleSynopticAppli
extends JFrame {
    private final SplashTimer splash = new SplashTimer(10000L, 200L);
    private ErrorHistory errorHistory = new ErrorHistory();
    private boolean standAlone = false;
    private boolean fileLoaded = false;
    private AttributePolledList numberAndState_scalar_atts;
    private JFrame trendFrame;
    private Trend globalTrend = null;
    private JMenuItem trendMenuItem;
    private JMenuItem errHistMenuItem;
    private JMenuItem diagtMenuItem;
    private JMenu fileJMenu;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JMenuItem quitJMenuItem;
    private TangoSynopticHandler tangoSynopHandler;
    private JMenu viewMenu;

    public SimpleSynopticAppli() {
        this.splash.setTitle("SimpleSynopticAppli  ");
        this.splash.setCopyright("(c) ESRF 2003-2015");
        this.splash.setMessage("Loading synoptic ...");
        this.splash.initProgress();
        this.splash.setVisible(true);
        this.numberAndState_scalar_atts = new AttributePolledList();
        this.numberAndState_scalar_atts.setFilter(new IEntityFilter(){

            public boolean keep(IEntity iEntity) {
                return iEntity instanceof INumberScalar || iEntity instanceof IDevStateScalar;
            }
        });
        this.trendFrame = new JFrame();
        JPanel jPanel = new JPanel();
        this.trendFrame.getContentPane().add((Component)jPanel, "Center");
        jPanel.setPreferredSize(new Dimension(600, 300));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.globalTrend = new Trend(this.trendFrame);
        jPanel.add((Component)this.globalTrend, gridBagConstraints);
        this.trendFrame.pack();
        this.initComponents();
    }

    public SimpleSynopticAppli(String string) {
        this();
        try {
            this.tangoSynopHandler.setSynopticFileName(string);
            this.splash.setMessage("Synoptic file loaded ...");
            this.tangoSynopHandler.setToolTipMode(3);
            this.tangoSynopHandler.setAutoZoom(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Cannot find the synoptic file : " + string + ".\n" + "Check the file name you entered;" + " Application will abort ...\n" + fileNotFoundException, "No such file", 0);
            this.splash.setVisible(false);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, "Cannot parse the synoptic file : " + string + ".\n" + "Check if the file is a Jdraw file." + " Application will abort ...\n" + illegalArgumentException, "Cannot parse the file", 0);
            this.splash.setVisible(false);
            return;
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog(null, "Cannot parse the synoptic file : " + string + ".\n" + " Application will abort ...\n" + missingResourceException, "Cannot parse the file", 0);
            this.splash.setVisible(false);
            return;
        }
        this.setTrendAttributeList();
        this.splash.setVisible(false);
        this.fileLoaded = true;
        this.setTitle(string);
        this.pack();
        this.setVisible(true);
    }

    public SimpleSynopticAppli(String string, boolean bl) {
        this(string);
        this.standAlone = bl;
    }

    private void setTrendAttributeList() {
        AttributeList attributeList = this.tangoSynopHandler.getAttributeList();
        for (int i = 0; i < attributeList.getSize(); ++i) {
            IEntity iEntity = (IEntity)attributeList.get(i);
            try {
                this.numberAndState_scalar_atts.add(iEntity.getName());
                continue;
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
        this.globalTrend.setModel(this.numberAndState_scalar_atts);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.tangoSynopHandler = new TangoSynopticHandler();
        this.jMenuBar1 = new JMenuBar();
        this.fileJMenu = new JMenu();
        this.quitJMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.trendMenuItem = new JMenuItem();
        this.errHistMenuItem = new JMenuItem();
        this.diagtMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SimpleSynopticAppli.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        if (this.errorHistory != null) {
            try {
                this.tangoSynopHandler.setErrorHistoryWindow(this.errorHistory);
            }
            catch (Exception exception) {
                System.out.println("Cannot set Error History Window");
            }
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.tangoSynopHandler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.fileJMenu.setText("File");
        this.quitJMenuItem.setText("Quit");
        this.quitJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSynopticAppli.this.quitJMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileJMenu.add(this.quitJMenuItem);
        this.jMenuBar1.add(this.fileJMenu);
        this.viewMenu.setText("View");
        this.trendMenuItem.setText("Numeric & State Trend ");
        this.trendMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSynopticAppli.this.viewTrendActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.trendMenuItem);
        this.viewMenu.add(this.errHistMenuItem);
        this.errHistMenuItem.setText("Error History ...");
        this.errHistMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSynopticAppli.this.errHistMenuItemActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.errHistMenuItem);
        this.diagtMenuItem.setText("Diagnostic ...");
        this.diagtMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        this.viewMenu.add(this.diagtMenuItem);
        this.jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void viewTrendActionPerformed(ActionEvent actionEvent) {
        ATKGraphicsUtils.centerFrame(this.getRootPane(), this.trendFrame);
        this.trendFrame.setVisible(true);
    }

    private void errHistMenuItemActionPerformed(ActionEvent actionEvent) {
        this.errorHistory.setVisible(true);
    }

    private void quitJMenuItemActionPerformed(ActionEvent actionEvent) {
        this.stopSimpleSynopticAppli();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.stopSimpleSynopticAppli();
    }

    public void stopSimpleSynopticAppli() {
        if (this.standAlone) {
            System.exit(0);
        } else {
            this.tangoSynopHandler.getAttributeList().stopRefresher();
            if (this.globalTrend != null) {
                this.globalTrend.clearModel();
            }
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        SimpleSynopticAppli simpleSynopticAppli = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length >= 2) {
            string2 = stringArray[0];
            string3 = stringArray[1];
            string = string2 == null ? string3 : (string2.length() <= 0 ? string3 : string2 + "/" + string3);
        } else if (stringArray.length == 1) {
            string = stringArray[0];
        }
        if (string == null) {
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("[SimpleSynopticAppli] Open a synoptic file");
            JDFileFilter jDFileFilter = new JDFileFilter("JDraw synoptic", new String[]{"jdw"});
            jFileChooser.addChoosableFileFilter(jDFileFilter);
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                string = file.getAbsolutePath();
            } else {
                System.exit(0);
            }
        }
        simpleSynopticAppli = new SimpleSynopticAppli(string, true);
        if (!simpleSynopticAppli.fileLoaded) {
            System.exit(-1);
        }
        ATKGraphicsUtils.centerFrameOnScreen(simpleSynopticAppli);
    }
}

