/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.LineProfilerPanel;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class LineProfilerViewer
extends JFrame {
    public static final int LINE_MODE_SINGLE = 1;
    public static final int LINE_MODE_DOUBLE = 2;
    public static final int HISTOGRAM_MODE = 3;
    private JSplitPane splitPane = new JSplitPane(0);
    private LineProfilerPanel profile1 = new LineProfilerPanel();
    private LineProfilerPanel profile2 = null;
    private int mode;

    public LineProfilerViewer() {
        this.splitPane.setLeftComponent(this.profile1);
        this.splitPane.setRightComponent(null);
        this.mode = 1;
        this.setContentPane(this.splitPane);
        this.pack();
    }

    public void setXAxisName(String string) {
        this.profile1.getChart().getXAxis().setName(string);
    }

    public void setYAxisName(String string) {
        this.profile1.getChart().getY1Axis().setName(string);
    }

    public void setFormat(String string) {
        this.profile1.setFormat(string);
        if (this.profile2 != null) {
            this.profile2.setFormat(string);
        }
    }

    public void setMode(int n) {
        this.mode = n;
        switch (this.mode) {
            case 1: {
                this.setTitle("[profile] ImageViewer");
                this.profile1.getChart().setHeader("Line profile");
                this.profile1.getChart().getXAxis().setName("Pixel index");
                this.profile1.getChart().getY1Axis().setName("Value");
                this.profile1.getChart().setName("Pixel value");
                if (this.profile1.getChart().isZoomed()) {
                    this.profile1.getChart().exitZoom();
                }
                if (this.profile2 == null) break;
                this.splitPane.setRightComponent(null);
                this.profile2.setVisible(false);
                break;
            }
            case 2: {
                this.setTitle("[profile] ImageViewer");
                if (this.profile2 == null) {
                    this.profile2 = new LineProfilerPanel();
                }
                this.profile1.getChart().setHeader("Line profile (Horizontal)");
                this.profile1.getChart().getXAxis().setName("Pixel index");
                this.profile1.getChart().getY1Axis().setName("Value");
                this.profile1.getChart().setName("Pixel value");
                if (this.profile1.getChart().isZoomed()) {
                    this.profile1.getChart().exitZoom();
                }
                this.profile2.getChart().setHeader("Line profile (Vertical)");
                this.profile2.getChart().getXAxis().setName("Pixel index");
                this.profile2.getChart().getY1Axis().setName("Value");
                this.profile2.getChart().setName("Pixel value");
                if (this.profile2.getChart().isZoomed()) {
                    this.profile2.getChart().exitZoom();
                }
                this.splitPane.setRightComponent(this.profile2);
                this.profile2.setVisible(true);
                break;
            }
            case 3: {
                this.setTitle("[Histogram] ImageViewer");
                this.profile1.getChart().setHeader("Histogram");
                this.profile1.getChart().getXAxis().setName("Pixel value");
                this.profile1.getChart().getY1Axis().setName("Number");
                this.profile1.getChart().setName("pixel number");
                if (this.profile1.getChart().isZoomed()) {
                    this.profile1.getChart().exitZoom();
                }
                if (this.profile2 == null) break;
                this.splitPane.setRightComponent(null);
                this.profile2.setVisible(false);
            }
        }
        this.pack();
    }

    public void setLineProfileMode() {
        this.setMode(1);
    }

    public void setHistogramMode() {
        this.setMode(3);
    }

    public void setData(double[] dArray) {
        this.setData(dArray, 0);
    }

    public void setData(double[] dArray, double d, double d2) {
        this.profile1.setData(dArray, d, d2);
    }

    public void setData(double[] dArray, int n) {
        this.profile1.setData(dArray, n);
    }

    public void setData2(double[] dArray) {
        this.setData2(dArray, 0);
    }

    public void setData2(double[] dArray, int n) {
        if (this.profile2 != null) {
            this.profile2.setData(dArray, n);
        }
    }

    public LineProfilerPanel getProfile1() {
        return this.profile1;
    }

    public LineProfilerPanel getProfile2() {
        return this.profile2;
    }

    public static void main(String[] stringArray) {
        LineProfilerViewer lineProfilerViewer = new LineProfilerViewer();
        lineProfilerViewer.setDefaultCloseOperation(3);
        lineProfilerViewer.setVisible(true);
    }
}

