/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class LineProfilerPanel
extends JPanel
implements IJLChartListener,
ActionListener {
    protected JPanel cfgPanel;
    protected JLChart theGraph;
    protected JLDataView theDataY;
    protected JTableRow theTable = null;
    protected Font panelFont;
    protected JCheckBox tableCheck;
    protected JLabel minLabel;
    protected JTextField minText;
    protected JLabel maxLabel;
    protected JTextField maxText;
    protected JLabel avgLabel;
    protected JTextField avgText;
    protected JLabel stdLabel;
    protected JTextField stdText;
    protected String userFormat = "";
    protected static String[] colName = new String[]{"Index", "Value"};
    protected static String[][] emptyStr = new String[][]{{"", ""}};

    public LineProfilerPanel() {
        this.setLayout(new BorderLayout());
        this.panelFont = new Font("Dialog", 0, 11);
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 25));
        this.add((Component)this.cfgPanel, "South");
        this.tableCheck = new JCheckBox("View table");
        this.tableCheck.setSelected(false);
        this.tableCheck.setFont(this.panelFont);
        this.tableCheck.setBounds(5, 3, 80, 20);
        this.tableCheck.addActionListener(this);
        this.cfgPanel.add(this.tableCheck);
        this.minLabel = new JLabel("Min");
        this.minLabel.setFont(this.panelFont);
        this.minLabel.setHorizontalAlignment(4);
        this.minLabel.setBounds(85, 3, 30, 20);
        this.cfgPanel.add(this.minLabel);
        this.minText = new JTextField("");
        this.minText.setMargin(new Insets(0, 0, 0, 0));
        this.minText.setFont(this.panelFont);
        this.minText.setBounds(120, 3, 60, 20);
        this.cfgPanel.add(this.minText);
        this.maxLabel = new JLabel("Max");
        this.maxLabel.setFont(this.panelFont);
        this.maxLabel.setHorizontalAlignment(4);
        this.maxLabel.setBounds(180, 3, 30, 20);
        this.cfgPanel.add(this.maxLabel);
        this.maxText = new JTextField("");
        this.maxText.setMargin(new Insets(0, 0, 0, 0));
        this.maxText.setFont(this.panelFont);
        this.maxText.setBounds(215, 3, 60, 20);
        this.cfgPanel.add(this.maxText);
        this.avgLabel = new JLabel("Avg");
        this.avgLabel.setFont(this.panelFont);
        this.avgLabel.setHorizontalAlignment(4);
        this.avgLabel.setBounds(275, 3, 30, 20);
        this.cfgPanel.add(this.avgLabel);
        this.avgText = new JTextField("");
        this.avgText.setMargin(new Insets(0, 0, 0, 0));
        this.avgText.setFont(this.panelFont);
        this.avgText.setBounds(310, 3, 60, 20);
        this.cfgPanel.add(this.avgText);
        this.stdLabel = new JLabel("Std");
        this.stdLabel.setFont(this.panelFont);
        this.stdLabel.setHorizontalAlignment(4);
        this.stdLabel.setBounds(370, 3, 30, 20);
        this.cfgPanel.add(this.stdLabel);
        this.stdText = new JTextField("");
        this.stdText.setMargin(new Insets(0, 0, 0, 0));
        this.stdText.setFont(this.panelFont);
        this.stdText.setBounds(405, 3, 60, 20);
        this.cfgPanel.add(this.stdText);
        this.theGraph = new JLChart();
        this.theGraph.setBorder(new EtchedBorder());
        this.theGraph.getXAxis().setAutoScale(true);
        this.theGraph.getXAxis().setAnnotation(2);
        this.theGraph.getXAxis().setGridVisible(true);
        this.theGraph.getXAxis().setLabelFormat(3);
        this.theDataY = new JLDataView();
        this.theGraph.getY1Axis().setAutoScale(true);
        this.theGraph.getY1Axis().addDataView(this.theDataY);
        this.theGraph.getY1Axis().setGridVisible(true);
        this.theGraph.setPreferredSize(new Dimension(600, 400));
        this.theGraph.setMinimumSize(new Dimension(600, 400));
        this.theGraph.setHeaderFont(new Font("Dialog", 1, 18));
        this.theGraph.setJLChartListener(this);
        this.add((Component)this.theGraph, "Center");
        this.theTable = new JTableRow();
        this.theTable.setPreferredSize(new Dimension(170, 0));
        this.theTable.setVisible(false);
        this.add((Component)this.theTable, "East");
    }

    public void setFormat(String string) {
        this.userFormat = string;
    }

    private void refreshTable() {
        if (this.theTable.isVisible()) {
            Object[][] objectArray;
            LineProfilerPanel.colName[0] = this.theGraph.getXAxis().getName();
            LineProfilerPanel.colName[1] = this.theGraph.getY1Axis().getName();
            if (this.theDataY.getDataLength() > 0) {
                objectArray = new String[this.theDataY.getDataLength()][2];
                DataList dataList = this.theDataY.getData();
                for (int i = 0; i < this.theDataY.getDataLength(); ++i) {
                    objectArray[i][0] = Integer.toString((int)dataList.x);
                    objectArray[i][1] = Double.toString(dataList.y);
                    dataList = dataList.next;
                }
            } else {
                objectArray = emptyStr;
            }
            this.theTable.setData(objectArray, colName);
        }
    }

    public void setData(double[] dArray, int n) {
        this.theDataY.reset();
        if (dArray != null) {
            int n2;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = dArray.length;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                this.theDataY.add(n2 + n, dArray[n2]);
                d += dArray[n2];
            }
            d3 = d / d5;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                d2 += (dArray[n2] - d3) * (dArray[n2] - d3);
            }
            d4 = Math.sqrt(d2 / d5);
            this.minText.setText(Double.toString(this.theDataY.getMinimum()));
            this.minText.setCaretPosition(0);
            this.maxText.setText(Double.toString(this.theDataY.getMaximum()));
            this.maxText.setCaretPosition(0);
            Double d6 = new Double(d3);
            Double d7 = new Double(d4);
            this.avgText.setText(String.format("%.2f", d6));
            this.avgText.setCaretPosition(0);
            this.stdText.setText(String.format("%.2f", d7));
            this.stdText.setCaretPosition(0);
        } else {
            this.minText.setText("");
            this.maxText.setText("");
            this.avgText.setText("");
            this.stdText.setText("");
        }
        this.theGraph.repaint();
        this.refreshTable();
    }

    public void setData(double[] dArray, double d, double d2) {
        this.theDataY.reset();
        if (dArray != null) {
            int n;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = dArray.length;
            for (n = 0; n < dArray.length; ++n) {
                this.theDataY.add((double)n * d + d2, dArray[n]);
                d3 += dArray[n];
            }
            d5 = d3 / d7;
            for (n = 0; n < dArray.length; ++n) {
                d4 += (dArray[n] - d5) * (dArray[n] - d5);
            }
            d6 = Math.sqrt(d4 / d7);
            this.minText.setText(Double.toString(this.theDataY.getMinimum()));
            this.minText.setCaretPosition(0);
            this.maxText.setText(Double.toString(this.theDataY.getMaximum()));
            this.maxText.setCaretPosition(0);
            Double d8 = new Double(d5);
            Double d9 = new Double(d6);
            this.avgText.setText(String.format("%.2f", d8));
            this.avgText.setCaretPosition(0);
            this.stdText.setText(String.format("%.2f", d9));
            this.stdText.setCaretPosition(0);
        } else {
            this.minText.setText("");
            this.maxText.setText("");
            this.avgText.setText("");
            this.stdText.setText("");
        }
        this.theGraph.repaint();
        this.refreshTable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.tableCheck) {
            this.theTable.setVisible(this.tableCheck.isSelected());
            this.refreshTable();
            this.revalidate();
        }
    }

    @Override
    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        String[] stringArray = new String[]{this.theGraph.getXAxis().getName() + " = " + jLChartEvent.getTransformedXValue(), this.userFormat.length() > 0 ? this.theGraph.getY1Axis().getName() + " = " + ATKFormat.format(this.userFormat, jLChartEvent.getTransformedYValue()) : this.theGraph.getY1Axis().getName() + " = " + jLChartEvent.getTransformedYValue()};
        return stringArray;
    }

    public JLChart getChart() {
        return this.theGraph;
    }
}

