/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.CommandFactory;
import fr.esrf.tangoatk.widget.command.SimpleCommandButtonViewer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SettableCommandButtonViewer
extends SimpleCommandButtonViewer {
    protected boolean defaultHelpText = false;
    protected String helpText = "";
    protected String buttonText = "";
    protected boolean askConfirmation = false;
    protected String askConfirmationTitle = "Confirmation";
    protected String askConfirmationText = "Execute command ?";
    protected String errorTitle = "Error";
    protected String errorText = "Can not execute command";
    protected String errorReasonTitle = "Reason:";
    protected String[] commandInput = new String[]{""};
    protected List<String> m_argin = null;
    protected boolean threadedCommand = false;

    public SettableCommandButtonViewer() {
        this.setEnabled(true);
        this.setHorizontalAlignment(0);
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String string) {
        this.helpText = string;
        if (this.isDefaultHelpText()) {
            super.setToolTipText(this.getText());
            return;
        }
        if (string.equals("")) {
            super.setToolTipText(null);
            return;
        }
        super.setToolTipText(string);
    }

    public boolean isDefaultHelpText() {
        return this.defaultHelpText;
    }

    public void setDefaultHelpText(boolean bl) {
        this.defaultHelpText = bl;
        this.setHelpText(this.helpText);
    }

    public void setCommandInput(String[] stringArray) {
        this.commandInput = stringArray;
        if (stringArray == null || stringArray.length == 0) {
            if (this.m_argin != null) {
                this.m_argin.clear();
            }
            this.m_argin = null;
            return;
        }
        this.m_argin = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if ("".equals(stringArray[i])) {
                this.m_argin.clear();
                this.m_argin = null;
                return;
            }
            this.m_argin.add(stringArray[i]);
        }
    }

    public String[] getCommandInput() {
        return this.commandInput;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getCommandModel() == null) {
            return;
        }
        int n = 0;
        if (this.askConfirmation) {
            n = JOptionPane.showConfirmDialog(this, this.askConfirmationText, this.askConfirmationTitle, 0);
        }
        if (n == 0) {
            if (this.m_argin != null && this.getCommandModel().takesInput()) {
                if (this.isThreadedCommand()) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                SettableCommandButtonViewer.this.getCommandModel().execute(SettableCommandButtonViewer.this.m_argin);
                            }
                            catch (Throwable throwable) {
                                SettableCommandButtonViewer.this.displayErrorMessage(throwable, SettableCommandButtonViewer.this.getCommandModel());
                            }
                        }
                    }.start();
                } else {
                    try {
                        this.getCommandModel().execute(this.m_argin);
                    }
                    catch (Throwable throwable) {
                        this.displayErrorMessage(throwable, this.getCommandModel());
                    }
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String string) {
        this.buttonText = string;
        this.setText(string);
    }

    public boolean isAskConfirmation() {
        return this.askConfirmation;
    }

    public void setAskConfirmation(boolean bl) {
        this.askConfirmation = bl;
    }

    public String getAskConfirmationText() {
        return this.askConfirmationText;
    }

    public void setAskConfirmationText(String string) {
        if (!string.equals("")) {
            this.askConfirmationText = string;
        }
    }

    public String getAskConfirmationTitle() {
        return this.askConfirmationTitle;
    }

    public void setAskConfirmationTitle(String string) {
        if (!string.equals("")) {
            this.askConfirmationTitle = string;
        }
    }

    protected void displayErrorMessage(Throwable throwable, ICommand iCommand) {
        StringBuffer stringBuffer = new StringBuffer(this.errorText);
        if (iCommand != null) {
            stringBuffer.append(" ").append(iCommand.getName());
        }
        if (throwable != null) {
            stringBuffer.append(this.errorReasonTitle);
            stringBuffer.append("\n-").append(throwable.getClass()).append("-");
            stringBuffer.append("\n").append(throwable.getMessage());
        }
        JOptionPane.showMessageDialog(this, throwable, stringBuffer.toString(), 0);
    }

    public String getErrorTitle() {
        return this.errorTitle;
    }

    public void setErrorTitle(String string) {
        if (string != null && !"".equals(string)) {
            this.errorTitle = string;
        }
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String string) {
        if (string != null && !"".equals(string)) {
            this.errorText = string;
        }
    }

    public String getErrorReasonTitle() {
        return this.errorReasonTitle;
    }

    public void setErrorReasonTitle(String string) {
        if (string != null && !"".equals(string)) {
            this.errorReasonTitle = string;
        }
    }

    public boolean isThreadedCommand() {
        return this.threadedCommand;
    }

    public void setThreadedCommand(boolean bl) {
        this.threadedCommand = bl;
    }

    public static void main(String[] stringArray) throws ConnectionException, DevFailed {
        JFrame jFrame = new JFrame();
        String string = "tango/tangotest/1/DevShort";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        SettableCommandButtonViewer settableCommandButtonViewer = new SettableCommandButtonViewer();
        settableCommandButtonViewer.setCommandModel(CommandFactory.getInstance().getCommand(string));
        settableCommandButtonViewer.setAskConfirmation(true);
        settableCommandButtonViewer.setDefaultHelpText(true);
        jFrame.getContentPane().add((Component)settableCommandButtonViewer, "Center");
        jFrame.setSize(640, 480);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }
}

