/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringImageListener;
import fr.esrf.tangoatk.core.StringImageEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.JTableRow;
import java.awt.Color;
import javax.swing.JFrame;

public class StringImageTableViewer
extends JTableRow
implements IStringImageListener {
    private IStringImage attModel = null;
    private boolean qualityEnabled = false;
    private Color background = this.getBackground();

    public IStringImage getAttModel() {
        return this.attModel;
    }

    public void setAttModel(IStringImage iStringImage) {
        this.clearModel();
        if (iStringImage != null) {
            this.attModel = iStringImage;
            this.attModel.addStringImageListener((IStringImageListener)this);
            this.attModel.refresh();
            this.setStringImageValue(this.attModel.getValue());
        } else {
            this.setStringImageValue(null);
        }
    }

    public boolean getQualityEnabled() {
        return this.qualityEnabled;
    }

    public void setQualityEnabled(boolean bl) {
        this.qualityEnabled = bl;
        if (!this.qualityEnabled) {
            super.setBackground(this.background);
            this.repaint();
        }
    }

    public void clearModel() {
        if (this.attModel != null) {
            this.attModel.removeStringImageListener((IStringImageListener)this);
            this.attModel = null;
            this.clearData();
        }
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
        super.setBackground(color);
    }

    public void stringImageChange(StringImageEvent stringImageEvent) {
        this.setStringImageValue(stringImageEvent.getValue());
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        String string = attributeStateEvent.getState();
        if (!this.qualityEnabled) {
            return;
        }
        super.setBackground(ATKConstant.getColor4Quality(string));
        this.repaint();
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    protected void setStringImageValue(String[][] stringArray) {
        if (stringArray == null) {
            this.clearData();
            return;
        }
        if (stringArray.length == 0) {
            this.clearData();
            return;
        }
        int n = stringArray[0].length;
        if (n == 0) {
            this.clearData();
            return;
        }
        super.setData(stringArray, 0, 0);
    }

    public static void main(String[] stringArray) {
        IStringImage iStringImage = null;
        AttributeList attributeList = new AttributeList();
        JFrame jFrame = new JFrame();
        StringImageTableViewer stringImageTableViewer = new StringImageTableViewer();
        try {
            IEntity iEntity = attributeList.add("fp/test/1/string_image_ro");
            if (!(iEntity instanceof IStringImage)) {
                System.out.println("fp/test/1/string_image_ro is not a IStringImage");
                System.exit(-1);
            }
            iStringImage = (IStringImage)iEntity;
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to fp/test/1/string_image_ro");
            System.exit(-1);
        }
        jFrame.setContentPane(stringImageTableViewer);
        jFrame.setDefaultCloseOperation(3);
        stringImageTableViewer.setAttModel(iStringImage);
        attributeList.startRefresher();
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

