/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.widget.attribute.NumberScalarComboEditor;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.attribute.SimpleScalarViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.JAutoScrolledText;
import fr.esrf.tangoatk.widget.util.JAutoScrolledTextListener;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NumberScalarListViewer
extends JPanel
implements JAutoScrolledTextListener {
    public static final String DEFAULT_SETTER = "WheelEditor";
    public static final String COMBO_SETTER = "ComboEditor";
    protected Vector<IAttribute> listModel = null;
    protected Vector<LabelViewer> nsLabels = null;
    protected Vector<JComponent> nsViewers = null;
    protected Vector<JComponent> nsSetters = null;
    protected Vector<JButton> nsPropButtons = null;
    protected SimplePropertyFrame propFrame = new SimplePropertyFrame();
    protected Font theFont = new Font("Dialog", 0, 14);
    private boolean labelVisible = true;
    private boolean setterVisible = true;
    private boolean propertyButtonVisible = true;
    private boolean propertyListEditable = true;
    private boolean unitVisible = true;
    private String setterType = "WheelEditor";
    private Color arrowColor = null;
    private String toolTipDisplay = "None";
    public static final String TOOLTIP_DISPLAY_NONE = "None";
    public static final String TOOLTIP_DISPLAY_NAME_ONLY = "Name";
    public static final String TOOLTIP_DISPLAY_ALL = "All";

    public NumberScalarListViewer() {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
    }

    public void setModel(AttributeList attributeList) {
        if (this.listModel != null) {
            this.removeComponents();
            this.listModel = null;
        }
        if (attributeList == null) {
            return;
        }
        int n = attributeList.getSize();
        if (n <= 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.initComponents(attributeList);
        this.setVisible(true);
    }

    protected void removeComponents() {
        IAttribute iAttribute = null;
        INumberScalar iNumberScalar = null;
        LabelViewer labelViewer = null;
        JComponent jComponent = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        this.propFrame = null;
        this.propFrame = new SimplePropertyFrame();
        int n = this.listModel.size();
        for (int i = 0; i < n; ++i) {
            try {
                iAttribute = this.listModel.get(i);
                if (!(iAttribute instanceof INumberScalar)) continue;
                iNumberScalar = (INumberScalar)iAttribute;
                labelViewer = this.nsLabels.get(i);
                labelViewer.setModel(null);
                jComponent = this.nsViewers.get(i);
                if (jComponent instanceof SimpleScalarViewer) {
                    simpleScalarViewer = (SimpleScalarViewer)jComponent;
                    simpleScalarViewer.clearModel();
                }
                if ((jComponent = this.nsSetters.get(i)) instanceof NumberScalarWheelEditor) {
                    numberScalarWheelEditor = (NumberScalarWheelEditor)jComponent;
                    if (!iNumberScalar.isWritable()) continue;
                    numberScalarWheelEditor.setModel(null);
                    continue;
                }
                if (!(jComponent instanceof NumberScalarComboEditor)) continue;
                numberScalarComboEditor = (NumberScalarComboEditor)jComponent;
                if (!iNumberScalar.isWritable()) continue;
                numberScalarComboEditor.setNumberModel(null);
                continue;
            }
            catch (Exception exception) {
                System.out.println("NumberScalarListViewer : setTheFont : Caught exception  " + exception.getMessage());
            }
        }
        this.nsLabels.removeAllElements();
        this.nsViewers.removeAllElements();
        this.nsSetters.removeAllElements();
        this.nsPropButtons.removeAllElements();
        this.listModel.removeAllElements();
        this.removeAll();
        this.listModel = null;
        this.nsLabels = null;
        this.nsViewers = null;
        this.nsSetters = null;
        this.nsPropButtons = null;
    }

    public Font getTheFont() {
        return this.theFont;
    }

    public void setTheFont(Font font) {
        LabelViewer labelViewer = null;
        JButton jButton = null;
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        if (font != null) {
            this.theFont = font;
            if (this.listModel != null) {
                int n = this.listModel.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        labelViewer = this.nsLabels.get(i);
                        labelViewer.setFont(this.theFont);
                        jComponent = this.nsViewers.get(i);
                        if (jComponent != null && jComponent instanceof SimpleScalarViewer) {
                            jComponent.setFont(this.theFont);
                        }
                        if ((jComponent2 = this.nsSetters.get(i)) != null && (jComponent2 instanceof NumberScalarWheelEditor || jComponent2 instanceof NumberScalarComboEditor)) {
                            jComponent2.setFont(this.theFont);
                        }
                        jButton = this.nsPropButtons.get(i);
                        jButton.setFont(this.theFont);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("NumberScalarListViewer : setTheFont : Caught exception  " + exception.getMessage());
                    }
                }
            }
        }
    }

    public boolean getLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        if (this.labelVisible != bl) {
            this.labelVisible = bl;
            this.changeLabelVisibility();
        }
    }

    private void changeLabelVisibility() {
        LabelViewer labelViewer = null;
        if (this.nsLabels != null) {
            int n = this.nsLabels.size();
            for (int i = 0; i < n; ++i) {
                try {
                    labelViewer = this.nsLabels.get(i);
                    labelViewer.setVisible(this.labelVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changeLabelVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getSetterVisible() {
        return this.setterVisible;
    }

    public void setSetterVisible(boolean bl) {
        if (this.setterVisible != bl) {
            this.setterVisible = bl;
            this.changeSetterVisibility();
        }
    }

    private void changeSetterVisibility() {
        JComponent jComponent = null;
        if (this.nsSetters != null) {
            int n = this.nsSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.nsSetters.get(i);
                    if (jComponent == null || !(jComponent instanceof NumberScalarWheelEditor) && !(jComponent instanceof NumberScalarComboEditor)) continue;
                    jComponent.setVisible(this.setterVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changeSetterVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyButtonVisible() {
        return this.propertyButtonVisible;
    }

    public void setPropertyButtonVisible(boolean bl) {
        if (this.propertyButtonVisible != bl) {
            this.propertyButtonVisible = bl;
            this.changePropButtonVisibility();
        }
    }

    private void changePropButtonVisibility() {
        JButton jButton = null;
        if (this.nsPropButtons != null) {
            int n = this.nsPropButtons.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jButton = this.nsPropButtons.get(i);
                    jButton.setVisible(this.propertyButtonVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changePropButtonVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public boolean getPropertyListEditable() {
        return this.propertyListEditable;
    }

    public void setPropertyListEditable(boolean bl) {
    }

    public boolean getUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        if (this.unitVisible != bl) {
            this.unitVisible = bl;
            this.changeUnitVisibility();
        }
    }

    private void changeUnitVisibility() {
        JComponent jComponent = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        if (this.nsViewers != null) {
            int n = this.nsViewers.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.nsViewers.get(i);
                    if (jComponent instanceof SimpleScalarViewer) {
                        simpleScalarViewer = (SimpleScalarViewer)jComponent;
                        simpleScalarViewer.setUnitVisible(this.unitVisible);
                    }
                    if ((jComponent = this.nsSetters.get(i)) == null || !(jComponent instanceof NumberScalarComboEditor)) continue;
                    numberScalarComboEditor = (NumberScalarComboEditor)jComponent;
                    numberScalarComboEditor.setUnitVisible(this.unitVisible);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changeUnitVisibility : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    public String getToolTipDisplay() {
        return this.toolTipDisplay;
    }

    public void setToolTipDisplay(String string) {
        if (this.listModel != null) {
            return;
        }
        this.toolTipDisplay = string.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL) ? TOOLTIP_DISPLAY_ALL : (string.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY) ? TOOLTIP_DISPLAY_NAME_ONLY : TOOLTIP_DISPLAY_NONE);
    }

    public String getSetterType() {
        return this.setterType;
    }

    public void setSetterType(String string) {
        if (this.listModel != null) {
            return;
        }
        this.setterType = string.equalsIgnoreCase(DEFAULT_SETTER) ? DEFAULT_SETTER : (string.equalsIgnoreCase(COMBO_SETTER) ? COMBO_SETTER : DEFAULT_SETTER);
    }

    public Color getArrowColor() {
        if (this.arrowColor == null) {
            return this.getBackground();
        }
        return this.arrowColor;
    }

    public void setArrowColor(Color color) {
        if (color == this.arrowColor) {
            return;
        }
        this.changeArrowColors(color);
        this.arrowColor = color;
    }

    private void changeArrowColors(Color color) {
        JComponent jComponent = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        if (this.nsSetters != null) {
            int n = this.nsSetters.size();
            for (int i = 0; i < n; ++i) {
                try {
                    jComponent = this.nsSetters.get(i);
                    if (!(jComponent instanceof NumberScalarWheelEditor)) continue;
                    numberScalarWheelEditor = (NumberScalarWheelEditor)jComponent;
                    if (color == null) {
                        numberScalarWheelEditor.setButtonColor(numberScalarWheelEditor.getBackground());
                        continue;
                    }
                    numberScalarWheelEditor.setButtonColor(color);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("NumberScalarListViewer : changeArrowColors : Caught exception  " + exception.getMessage());
                }
            }
        }
    }

    @Override
    public void textExceedBounds(JAutoScrolledText jAutoScrolledText) {
        this.revalidate();
    }

    protected void initComponents(AttributeList attributeList) {
        LabelViewer labelViewer = null;
        SimpleScalarViewer simpleScalarViewer = null;
        NumberScalarWheelEditor numberScalarWheelEditor = null;
        NumberScalarComboEditor numberScalarComboEditor = null;
        JComponent jComponent = null;
        JButton jButton = null;
        boolean bl = false;
        this.listModel = new Vector();
        this.nsLabels = new Vector();
        this.nsViewers = new Vector();
        this.nsSetters = new Vector();
        this.nsPropButtons = new Vector();
        int n = 0;
        int n2 = attributeList.size();
        for (int i = 0; i < n2; ++i) {
            Object object = attributeList.getElementAt(i);
            if (!(object instanceof INumberScalar)) continue;
            INumberScalar iNumberScalar = (INumberScalar)object;
            boolean bl2 = false;
            if (iNumberScalar.getPossibleValues() != null && iNumberScalar.getPossibleValues().length > 0) {
                bl2 = true;
            }
            labelViewer = new LabelViewer();
            simpleScalarViewer = new SimpleScalarViewer();
            jButton = new JButton();
            labelViewer.setFont(this.theFont);
            labelViewer.setHorizontalAlignment(JSmoothLabel.RIGHT_ALIGNMENT);
            labelViewer.setBackground(this.getBackground());
            labelViewer.setText(iNumberScalar.getLabel());
            if (this.labelVisible) {
                labelViewer.setVisible(true);
            } else {
                labelViewer.setVisible(false);
            }
            labelViewer.setModel((IAttribute)iNumberScalar);
            if (bl2) {
                numberScalarComboEditor = new NumberScalarComboEditor();
                numberScalarComboEditor.setFont(this.theFont);
                numberScalarComboEditor.setBackground(this.getBackground());
                numberScalarComboEditor.setUnitVisible(this.unitVisible);
                if (iNumberScalar.isWritable()) {
                    numberScalarComboEditor.setNumberModel(iNumberScalar);
                    numberScalarComboEditor.setVisible(this.setterVisible);
                    jComponent = numberScalarComboEditor;
                } else {
                    jComponent = null;
                }
                this.nsSetters.add(jComponent);
            } else {
                numberScalarWheelEditor = new NumberScalarWheelEditor();
                numberScalarWheelEditor.setFont(this.theFont);
                numberScalarWheelEditor.setBackground(this.getBackground());
                if (iNumberScalar.isWritable()) {
                    numberScalarWheelEditor.setModel(iNumberScalar);
                    numberScalarWheelEditor.setVisible(this.setterVisible);
                    jComponent = numberScalarWheelEditor;
                } else {
                    jComponent = null;
                }
                this.nsSetters.add(jComponent);
            }
            if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_ALL)) {
                simpleScalarViewer.setHasToolTip(true);
                simpleScalarViewer.setQualityInTooltip(true);
            } else if (this.toolTipDisplay.equalsIgnoreCase(TOOLTIP_DISPLAY_NAME_ONLY)) {
                simpleScalarViewer.setHasToolTip(true);
                simpleScalarViewer.setQualityInTooltip(false);
            } else {
                simpleScalarViewer.setHasToolTip(false);
                simpleScalarViewer.setQualityInTooltip(false);
            }
            simpleScalarViewer.setFont(this.theFont);
            simpleScalarViewer.setUnitVisible(this.unitVisible);
            simpleScalarViewer.setBackgroundColor(this.getBackground());
            simpleScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
            simpleScalarViewer.setAlarmEnabled(true);
            simpleScalarViewer.setModel(iNumberScalar);
            jButton.setFont(this.theFont);
            jButton.setBackground(this.getBackground());
            jButton.setText(" ... ");
            jButton.setMargin(new Insets(-3, 0, 3, 0));
            jButton.setToolTipText("Attribute Properties");
            if (!this.propertyButtonVisible && jButton != null) {
                jButton.setVisible(false);
            }
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NumberScalarListViewer.this.propertyButtonActionPerformed(actionEvent);
                }
            });
            iNumberScalar.refresh();
            simpleScalarViewer.addTextListener(this);
            int n3 = 0;
            int n4 = labelViewer.getPreferredSize().height + 4;
            if (n4 > n3) {
                n3 = n4;
            }
            if ((n4 = simpleScalarViewer.getPreferredSize().height + 4) > n3) {
                n3 = n4;
            }
            if (jComponent != null && jComponent.isVisible() && (n4 = jComponent.getPreferredSize().height + 4) > n3) {
                n3 = n4;
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 5, 1, 1);
            this.add((Component)labelViewer, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 2, 1, 1);
            this.add((Component)simpleScalarViewer, gridBagConstraints);
            if (jComponent != null) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = n;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(1, 1, 1, 1);
                this.add((Component)jComponent, gridBagConstraints);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n;
            gridBagConstraints.insets = new Insets(1, 3, 1, 5);
            this.add((Component)jButton, gridBagConstraints);
            this.listModel.add((IAttribute)iNumberScalar);
            this.nsLabels.add(labelViewer);
            this.nsViewers.add(simpleScalarViewer);
            this.nsPropButtons.add(jButton);
            if (simpleScalarViewer instanceof SimpleScalarViewer) {
                SimpleScalarViewer simpleScalarViewer2 = simpleScalarViewer;
                n4 = simpleScalarViewer.getPreferredSize().height;
                int n5 = n4 < n3 ? (n3 - n4) / 2 : 0;
                Insets insets = simpleScalarViewer2.getMargin();
                insets.top += n5;
                insets.bottom += n5;
                insets.left += 2;
                insets.right += 2;
                simpleScalarViewer2.setMargin(insets);
            }
            ++n;
        }
    }

    private void propertyButtonActionPerformed(ActionEvent actionEvent) {
        int n = -1;
        if (this.nsPropButtons == null) {
            return;
        }
        if (this.listModel == null) {
            return;
        }
        int n2 = this.nsPropButtons.size();
        for (int i = 0; i < n2; ++i) {
            try {
                JButton jButton = this.nsPropButtons.get(i);
                if (!jButton.equals(actionEvent.getSource())) continue;
                n = i;
                break;
            }
            catch (Exception exception) {
                System.out.println("NumberScalarListViewer : propertyButtonActionPerformed : Caught exception  " + exception.getMessage());
                return;
            }
        }
        if (n < 0) {
            return;
        }
        INumberScalar iNumberScalar = null;
        try {
            IAttribute iAttribute = this.listModel.get(n);
            if (iAttribute instanceof INumberScalar) {
                iNumberScalar = (INumberScalar)iAttribute;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iNumberScalar == null) {
            return;
        }
        if (this.propFrame != null) {
            this.propFrame.setModel((IAttribute)iNumberScalar);
            this.propFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        NumberScalarListViewer numberScalarListViewer = new NumberScalarListViewer();
        double[] dArray = new double[]{0.1, 0.3, 1.0, 3.0, 10.0, 30.0, 100.0, 300.0};
        try {
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_un");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_deux");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_trois");
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_quatre");
            numberScalarListViewer.setModel(attributeList);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(numberScalarListViewer);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

